/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyFunctionQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.CaseTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DerefQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DescendantSelfAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NotQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.ParentAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.SimilarityQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.WildcardQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.fulltext.ParseException;
import org.exoplatform.services.jcr.impl.core.query.lucene.fulltext.QueryParser;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.xml.XMLChar;
import org.exoplatform.services.log.ExoLogger;

public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static final String NS_FN_PREFIX = "fn";
    public static final String NS_FN_URI = "http://www.w3.org/2005/xpath-functions";
    private static final String NS_FN_OLD_PREFIX = "fn_old";
    public static final String NS_FN_OLD_URI = "http://www.w3.org/2004/10/xpath-functions";
    private static final String NS_XS_PREFIX = "xs";
    public static final String NS_XS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final Log log = ExoLogger.getLogger(LuceneQueryBuilder.class);
    private QueryRootNode root;
    private SessionImpl session;
    private ItemDataConsumer sharedItemMgr;
    private NamespaceMappings nsMappings;
    private LocationFactory resolver;
    private Analyzer analyzer;
    private PropertyTypeRegistry propRegistry;
    private SynonymProvider synonymProvider;
    private IndexFormatVersion indexFormatVersion;
    private List<Exception> exceptions = new ArrayList<Exception>();
    private final NodeTypeDataManager nodeTypeDataManager;

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemDataConsumer sharedItemMgr, NamespaceMappings nsMappings, NodeTypeDataManager nodeTypeDataManager, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion) {
        this.root = root;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.nsMappings = nsMappings;
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.analyzer = analyzer;
        this.propRegistry = propReg;
        this.synonymProvider = synonymProvider;
        this.indexFormatVersion = indexFormatVersion;
        this.resolver = new LocationFactory(nsMappings);
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemDataConsumer sharedItemMgr, NamespaceMappings nsMappings, NodeTypeDataManager nodeTypeDataManager, Analyzer analyzer, PropertyTypeRegistry propReg, SynonymProvider synonymProvider, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sharedItemMgr, nsMappings, nodeTypeDataManager, analyzer, propReg, synonymProvider, indexFormatVersion);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            Iterator<Exception> it = builder.exceptions.iterator();
            while (it.hasNext()) {
                msg.append(it.next().toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() {
        return (Query)this.root.accept(this, null);
    }

    public Object visit(QueryRootNode node, Object data) {
        BooleanQuery root;
        Query wrapped = root = new BooleanQuery();
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    public Object visit(OrQueryNode node, Object data) {
        BooleanQuery orQuery = new BooleanQuery();
        Object[] result = node.acceptOperands(this, null);
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            orQuery.add(operand, BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    public Object visit(AndQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            andQuery.add(operand, BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(NotQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            b.add((Query)result[i], BooleanClause.Occur.SHOULD);
        }
        return new NotQuery(b);
    }

    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = this.resolver.createJCRName(node.getPropertyName()).getAsString();
            value = this.resolver.createJCRName(node.getValue()).getAsString();
        }
        catch (RepositoryException e) {
            log.warn(e.getLocalizedMessage());
        }
        return new TermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        ArrayList<Term> terms = new ArrayList<Term>();
        try {
            Term t;
            String mixinTypesField = this.resolver.createJCRName(Constants.JCR_MIXINTYPES).getAsString();
            String primaryTypeField = this.resolver.createJCRName(Constants.JCR_PRIMARYTYPE).getAsString();
            NodeTypeData base = this.nodeTypeDataManager.findNodeType(node.getValue());
            if (base.isMixin()) {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.resolver.createJCRName(node.getValue()).getAsString()));
                terms.add(t);
            } else {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.resolver.createJCRName(node.getValue()).getAsString()));
                terms.add(t);
            }
            List<NodeTypeData> allTypes = this.nodeTypeDataManager.getAllNodeTypes();
            for (NodeTypeData nodeTypeData : allTypes) {
                InternalQName[] superTypes = nodeTypeData.getDeclaredSupertypeNames();
                if (!Arrays.asList(superTypes).contains(base.getName())) continue;
                String ntName = this.nsMappings.translatePropertyName(nodeTypeData.getName());
                Term t2 = nodeTypeData.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        catch (IllegalNameException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        if (terms.size() == 0) {
            return new BooleanQuery();
        }
        if (terms.size() == 1) {
            return new TermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        Iterator it = terms.iterator();
        while (it.hasNext()) {
            b.add(new TermQuery((Term)it.next()), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            QPath relPath = node.getRelativePath();
            if (relPath == null || !node.getReferencesProperty()) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                InternalQName propName = relPath.getName();
                StringBuffer tmp = new StringBuffer();
                fieldname = FieldNames.createFullTextFieldName(this.resolver.createJCRName(propName).getAsString());
            }
            QueryParser parser = new QueryParser(fieldname, this.analyzer, this.synonymProvider);
            parser.setOperator(1);
            StringBuffer query = new StringBuffer();
            String textsearch = node.getQuery();
            textsearch = textsearch.replaceAll("AND", "and");
            textsearch = textsearch.replaceAll("NOT", "not");
            boolean escaped = false;
            for (int i = 0; i < textsearch.length(); ++i) {
                if (textsearch.charAt(i) == '\\') {
                    if (escaped) {
                        query.append("\\\\");
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                if (textsearch.charAt(i) == '\'') {
                    if (escaped) {
                        escaped = false;
                    }
                    query.append(textsearch.charAt(i));
                    continue;
                }
                if (escaped) {
                    query.append('\\');
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
            }
            Query context = parser.parse(query.toString());
            if (!(relPath == null || node.getReferencesProperty() && relPath.getEntries().length <= 1)) {
                QPathEntry[] elements = relPath.getEntries();
                for (int i = elements.length - 1; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].equals(RelationQueryNode.STAR_NAME_TEST)) {
                        name = this.resolver.createJCRName(elements[i]).getAsString();
                    }
                    if (name != null && (node.getReferencesProperty() && i == elements.length - 2 || !node.getReferencesProperty() && i == elements.length - 1)) {
                        TermQuery q = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add(q, BooleanClause.Occur.MUST);
                        and.add(context, BooleanClause.Occur.MUST);
                        context = and;
                        continue;
                    }
                    if ((!node.getReferencesProperty() || i >= elements.length - 2) && (node.getReferencesProperty() || i >= elements.length - 1)) continue;
                    context = new ParentAxisQuery(context, name);
                }
                context = new ParentAxisQuery(context, null);
            }
            return context;
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        catch (ParseException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return null;
    }

    public Object visit(PathQueryNode node, Object data) {
        BooleanQuery constraint;
        Query context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                InternalQName nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else if (nameTest.getName().length() == 0) {
                    context = new TermQuery(new Term(FieldNames.UUID, "00exo0jcr0root0uuid0000000000000"));
                } else {
                    String name = "";
                    try {
                        name = this.resolver.createJCRName(nameTest).getAsString();
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add(e);
                    }
                    BooleanQuery and = new BooleanQuery();
                    and.add(new TermQuery(new Term(FieldNames.PARENT, "")), BooleanClause.Occur.MUST);
                    and.add(new TermQuery(new Term(FieldNames.LABEL, name)), BooleanClause.Occur.MUST);
                    context = and;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new TermQuery(new Term(FieldNames.PARENT, ""));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Number of location steps must be > 0"));
        }
        for (int i = 0; i < steps.length; ++i) {
            context = (Query)steps[i].accept(this, context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add(context, BooleanClause.Occur.MUST);
            context = constraint;
        }
        return context;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        Object[] predicates = node.acceptOperands(this, data);
        for (int i = 0; i < predicates.length; ++i) {
            andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
        }
        QueryNode[] pred = node.getPredicates();
        for (int i = 0; i < pred.length; ++i) {
            RelationQueryNode pos;
            if (pred[i].getType() != 2 || (pos = (RelationQueryNode)pred[i]).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        TermQuery nameTest = null;
        if (node.getNameTest() != null) {
            try {
                String internalName = this.resolver.createJCRName(node.getNameTest()).getAsString();
                nameTest = new TermQuery(new Term(FieldNames.LABEL, internalName));
            }
            catch (RepositoryException e) {
                this.exceptions.add(e);
            }
        }
        if (node.getIncludeDescendants()) {
            if (nameTest != null) {
                andQuery.add(new DescendantSelfAxisQuery(context, nameTest), BooleanClause.Occur.MUST);
            } else if (predicates.length > 0) {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery = new DescendantSelfAxisQuery(context, andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add(subQuery, BooleanClause.Occur.MUST);
                }
            } else {
                Query subQuery = null;
                try {
                    subQuery = this.createMatchAllQuery(this.resolver.createJCRName(Constants.JCR_PRIMARYTYPE).getAsString());
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    context = new DescendantSelfAxisQuery(context, subQuery);
                    andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
                } else {
                    andQuery.add(subQuery, BooleanClause.Occur.MUST);
                }
            }
        } else if (nameTest != null) {
            andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getTerm().text(), node.getIndex()), BooleanClause.Occur.MUST);
        } else {
            andQuery.add(new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(DerefQueryNode node, Object data) {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.resolver.createJCRName(node.getRefProperty()).getAsString();
            String nameTest = null;
            if (node.getNameTest() != null) {
                nameTest = this.resolver.createJCRName(node.getNameTest()).getAsString();
            }
            if (node.getIncludeDescendants()) {
                Query refPropQuery = this.createMatchAllQuery(refProperty);
                context = new DescendantSelfAxisQuery(context, refPropQuery, false);
            }
            context = new DerefQuery(context, refProperty, nameTest);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (int i = 0; i < predicates.length; ++i) {
                    andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return context;
    }

    public Object visit(RelationQueryNode node, Object data) {
        Query query;
        String[] stringValues = new String[1];
        switch (node.getValueType()) {
            case 0: {
                break;
            }
            case 4: {
                stringValues[0] = DateField.dateToString(node.getDateValue());
                break;
            }
            case 2: {
                stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                break;
            }
            case 1: {
                stringValues[0] = LongField.longToString(node.getLongValue());
                break;
            }
            case 3: {
                if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                    InternalQName propertyName = node.getRelativePath().getName();
                    stringValues = this.getStringValues(propertyName, node.getStringValue());
                    break;
                }
                stringValues[0] = node.getStringValue();
                break;
            }
            case 6: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
            }
        }
        if (node.getRelativePath() == null && node.getOperation() != 28 && node.getOperation() != 29) {
            this.exceptions.add(new InvalidQueryException("@* not supported in predicate"));
            return data;
        }
        final int[] transform = new int[]{0};
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            public Object visit(PropertyFunctionQueryNode node, Object data) {
                if (node.getFunctionName().equals("lower-case")) {
                    transform[0] = 1;
                } else if (node.getFunctionName().equals("upper-case")) {
                    transform[0] = 2;
                }
                return data;
            }
        }, null);
        QPath relPath = node.getRelativePath();
        if (node.getOperation() == 28) {
            relPath = QPath.makeChildPath(relPath, Constants.JCR_PRIMARYTYPE);
        }
        String field = "";
        try {
            field = this.resolver.createJCRName(relPath.getName()).getAsString();
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        InternalQName propName = relPath.getName();
        if (propName.getNamespace().equals(NS_FN_URI) && propName.getName().equals("name()")) {
            if (node.getValueType() != 3) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with a string literal"));
                return data;
            }
            if (node.getOperation() != 11 && node.getOperation() != 12) {
                this.exceptions.add(new InvalidQueryException("Name function can only be used in conjunction with an equals operator"));
                return data;
            }
            if (XMLChar.isValidName(node.getStringValue())) {
                try {
                    InternalQName n = this.session.getLocationFactory().parseJCRName(ISO9075.decode(node.getStringValue())).getInternalName();
                    String translatedQName = this.nsMappings.translatePropertyName(n);
                    Term t = new Term(FieldNames.LABEL, translatedQName);
                    query = new TermQuery(t);
                }
                catch (RepositoryException e) {
                    this.exceptions.add(e);
                    return data;
                }
                catch (IllegalNameException e) {
                    this.exceptions.add(e);
                    return data;
                }
            } else {
                query = new TermQuery(new Term(FieldNames.UUID, "x"));
            }
        } else {
            switch (node.getOperation()) {
                case 11: 
                case 12: {
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        or.add(q, BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 11) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 19: 
                case 20: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add(new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 19) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 17: 
                case 18: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                        or.add(new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 17) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 21: 
                case 22: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add(new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 21) break;
                    query = this.createSingleValueConstraint(query, field);
                    break;
                }
                case 23: {
                    if (stringValues[0].equals("%")) {
                        query = this.createMatchAllQuery(field);
                        break;
                    }
                    query = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0], transform[0]);
                    break;
                }
                case 15: 
                case 16: {
                    Term upper;
                    BooleanQuery or = new BooleanQuery();
                    for (int i = 0; i < stringValues.length; ++i) {
                        Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                        upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        or.add(new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                    }
                    query = or;
                    if (node.getOperation() != 15) break;
                    query = this.createSingleValueConstraint(or, field);
                    break;
                }
                case 13: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(this.createMatchAllQuery(field), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        notQuery.add(q, BooleanClause.Occur.MUST_NOT);
                    }
                    notQuery.add(new TermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
                    query = notQuery;
                    break;
                }
                case 14: {
                    Term t;
                    BooleanQuery notQuery = new BooleanQuery();
                    notQuery.add(this.createMatchAllQuery(field), BooleanClause.Occur.SHOULD);
                    for (int i = 0; i < stringValues.length; ++i) {
                        t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                        NotQuery svp = new NotQuery(new TermQuery(new Term(FieldNames.MVP, field)));
                        BooleanQuery and = new BooleanQuery();
                        Query q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                        and.add(q, BooleanClause.Occur.MUST);
                        and.add(svp, BooleanClause.Occur.MUST);
                        notQuery.add(and, BooleanClause.Occur.MUST_NOT);
                    }
                    query = notQuery;
                    break;
                }
                case 26: {
                    query = new NotQuery(this.createMatchAllQuery(field));
                    break;
                }
                case 28: {
                    String uuid = "x";
                    try {
                        QPath path = this.resolver.parseJCRPath(node.getStringValue()).getInternalPath();
                        NodeData parent = (NodeData)this.sharedItemMgr.getItemData("00exo0jcr0root0uuid0000000000000");
                        if (path.equals(Constants.ROOT_PATH)) {
                            uuid = "00exo0jcr0root0uuid0000000000000";
                        } else {
                            QPathEntry[] relPathEntries = path.getRelPath(path.getDepth());
                            ItemData item = parent;
                            for (int i = 0; i < relPathEntries.length && (item = this.sharedItemMgr.getItemData(parent, relPathEntries[i])) != null; ++i) {
                                if (item.isNode()) {
                                    parent = (NodeData)item;
                                    continue;
                                }
                                if (i >= relPathEntries.length - 1) continue;
                                throw new IllegalPathException("Path can not contains a property as the intermediate element");
                            }
                            uuid = item.getIdentifier();
                        }
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add(e);
                    }
                    query = new SimilarityQuery(uuid, this.analyzer);
                    break;
                }
                case 27: {
                    query = this.createMatchAllQuery(field);
                    break;
                }
                case 29: {
                    query = this.createMatchAllQuery(field);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
                }
            }
        }
        if (relPath.getEntries().length > 1) {
            try {
                QPathEntry[] elements = relPath.getEntries();
                for (int i = elements.length - 2; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].equals(RelationQueryNode.STAR_NAME_TEST)) {
                        name = this.resolver.createJCRName(elements[i]).getAsString();
                    }
                    if (i == elements.length - 2) {
                        if (name == null) continue;
                        TermQuery nameTest = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add(query, BooleanClause.Occur.MUST);
                        and.add(nameTest, BooleanClause.Occur.MUST);
                        query = and;
                        continue;
                    }
                    query = new ParentAxisQuery(query, name);
                }
            }
            catch (RepositoryException e) {
                this.exceptions.add(e);
            }
            query = new ParentAxisQuery(query, null);
        }
        return query;
    }

    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    public Object visit(PropertyFunctionQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        TermQuery mvp = new TermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery(mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, BooleanClause.Occur.MUST);
        and.add(svp, BooleanClause.Occur.MUST);
        return and;
    }

    private String[] getStringValues(InternalQName propertyName, String literal) {
        PropertyTypeRegistry.TypeMapping[] types = this.propRegistry.getPropertyTypes(propertyName);
        ArrayList<String> values = new ArrayList<String>();
        block25: for (int i = 0; i < types.length; ++i) {
            switch (types[i].type) {
                case 7: {
                    try {
                        InternalQName n = this.session.getLocationFactory().parseJCRName(literal).getInternalName();
                        values.add(this.nsMappings.translatePropertyName(n));
                        log.debug("Coerced " + literal + " into NAME.");
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    catch (IllegalNameException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    continue block25;
                }
                case 8: {
                    try {
                        QPath p = this.session.getLocationFactory().parseJCRPath(literal).getInternalPath();
                        values.add(this.resolver.createJCRPath(p).getAsString(true));
                        log.debug("Coerced " + literal + " into PATH.");
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    continue block25;
                }
                case 5: {
                    Calendar c = ISO8601.parse(literal);
                    if (c != null) {
                        values.add(DateField.timeToString(c.getTimeInMillis()));
                        log.debug("Coerced " + literal + " into DATE.");
                        continue block25;
                    }
                    log.warn("Unable to coerce '" + literal + "' into a DATE.");
                    continue block25;
                }
                case 4: {
                    try {
                        double d = Double.parseDouble(literal);
                        values.add(DoubleField.doubleToString(d));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a DOUBLE: " + e.toString());
                    }
                    continue block25;
                }
                case 3: {
                    try {
                        long l = Long.parseLong(literal);
                        values.add(LongField.longToString(l));
                        log.debug("Coerced " + literal + " into LONG.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a LONG: " + e.toString());
                    }
                    continue block25;
                }
                case 1: {
                    values.add(literal);
                    log.debug("Using literal " + literal + " as is.");
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            if (literal.indexOf(47) > -1) {
                try {
                    QPath p = this.session.getLocationFactory().parseJCRPath(literal).getInternalPath();
                    values.add(this.resolver.createJCRPath(p).getAsString(true));
                    log.debug("Coerced " + literal + " into PATH.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (XMLChar.isValidName(literal)) {
                try {
                    InternalQName n = this.session.getLocationFactory().parseJCRName(literal).getInternalName();
                    values.add(this.nsMappings.translatePropertyName(n));
                    log.debug("Coerced " + literal + " into NAME.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (literal.indexOf(58) > -1) {
                Calendar c = ISO8601.parse(literal);
                if (c != null) {
                    values.add(DateField.timeToString(c.getTimeInMillis()));
                    log.debug("Coerced " + literal + " into DATE.");
                }
            } else {
                try {
                    values.add(LongField.longToString(Long.parseLong(literal)));
                    log.debug("Coerced " + literal + " into LONG.");
                }
                catch (NumberFormatException e) {
                    try {
                        values.add(DoubleField.doubleToString(Double.parseDouble(literal)));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            log.debug("Using literal " + literal + " as is.");
        }
        return values.toArray(new String[values.size()]);
    }

    private final Query createMatchAllQuery(String field) {
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new TermQuery(new Term(FieldNames.PROPERTIES_SET, field));
        }
        return new MatchAllQuery(field);
    }
}

