/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class ByteArrayPersistedValueData
extends AbstractValueData {
    protected byte[] data;

    public ByteArrayPersistedValueData(byte[] data, int orderNumber) {
        super(orderNumber);
        this.data = data;
    }

    public InputStream getAsStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public byte[] getAsByteArray() throws IllegalStateException {
        return this.data;
    }

    public long getLength() {
        return this.data.length;
    }

    public boolean isByteArray() {
        return true;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        try {
            return new TransientValueData(this.orderNumber, this.data, null, null, null, -1, null, false);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }
}

