/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.io.File;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.MySQLSingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class MySQLConnectionFactory
extends GenericConnectionFactory {
    public MySQLConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public MySQLConnectionFactory(DataSource dbDataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        super(dbDataSource, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        try {
            if (this.multiDb) {
                return new MySQLMultiDbJDBCConnection(this.getJdbcConnection(), this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new MySQLSingleDbJDBCConnection(this.getJdbcConnection(), this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }
}

