/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.update;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;

public class StorageUpdateManager {
    protected static Log log = ExoLogger.getLogger("jcr.StorageUpdateManager");
    public static final String STORAGE_VERSION_1_0_0 = "1.0";
    public static final String STORAGE_VERSION_1_0_1 = "1.0.1";
    public static final String STORAGE_VERSION_1_1_0 = "1.1";
    public static final String STORAGE_VERSION_1_5_0 = "1.5";
    public static final String STORAGE_VERSION_1_6_0 = "1.6";
    public static final String STORAGE_VERSION_1_7_0 = "1.7";
    public static final String FIRST_STORAGE_VERSION = "1.0";
    public static final String PREV_STORAGE_VERSION = "1.6";
    public static final String REQUIRED_STORAGE_VERSION = "1.7";
    protected final String SQL_INSERT_VERSION;
    protected static final String SQL_INSERT_VERSION_MULTIDB = "insert into JCR_MCONTAINER(VERSION) values(?)";
    protected static final String SQL_INSERT_VERSION_SINGLEDB = "insert into JCR_SCONTAINER(VERSION) values(?)";
    protected final String SQL_UPDATE_VERSION;
    protected static final String SQL_UPDATE_VERSION_MULTIDB = "update JCR_MCONTAINER set VERSION=?";
    protected static final String SQL_UPDATE_VERSION_SINGLEDB = "update JCR_SCONTAINER set VERSION=?";
    protected final String SQL_SELECT_VERSION;
    protected static final String SQL_SELECT_VERSION_MULTIDB = "select VERSION from JCR_MCONTAINER";
    protected static final String SQL_SELECT_VERSION_SINGLEDB = "select VERSION from JCR_SCONTAINER";
    protected static final String SQL_UPDATE_JCRUUID_MULTIDB = "update JCR_MVALUE set DATA=? where ID=?";
    protected static final String SQL_UPDATE_JCRUUID_SINGLEDB = "update JCR_SVALUE set DATA=? where ID=?";
    protected static final String SQL_SELECT_JCRUUID_MULTIDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_MITEM I, JCR_MNODE N, JCR_MPROPERTY P, JCR_MVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '%" + Constants.JCR_UUID.getAsString() + "%' " + "order by V.ID";
    protected static final String SQL_SELECT_JCRUUID_SINGLEDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_SITEM I, JCR_SNODE N, JCR_SPROPERTY P, JCR_SVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '%" + Constants.JCR_UUID.getAsString() + "%' " + "order by V.ID";
    protected static final String FROZENJCRUUID = "$FROZENJCRUUID$";
    protected static final String SQL_SELECT_FROZENJCRUUID_MULTIDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_MITEM I, JCR_MNODE N, JCR_MPROPERTY P, JCR_MVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '$FROZENJCRUUID$' order by V.ID";
    protected static final String SQL_SELECT_FROZENJCRUUID_SINGLEDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_SITEM I, JCR_SNODE N, JCR_SPROPERTY P, JCR_SVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '$FROZENJCRUUID$' order by V.ID";
    protected static final String SQL_SELECT_REFERENCES_MULTIDB = "select I.PATH, V.PROPERTY_ID, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MPROPERTY P, JCR_MVALUE V where I.ID=P.ID and P.ID=V.PROPERTY_ID and P.TYPE=9 order by I.ID, V.ORDER_NUM";
    protected static final String SQL_SELECT_REFERENCES_SINGLEDB = "select I.PATH, V.PROPERTY_ID, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SPROPERTY P, JCR_SVALUE V where I.ID=P.ID and P.ID=V.PROPERTY_ID and P.TYPE=9 order by I.ID, V.ORDER_NUM";
    protected static final String SQL_INSERT_REFERENCES_MULTIDB = "insert into JCR_MREF (NODE_ID, PROPERTY_ID, ORDER_NUM) values(?,?,?)";
    protected static final String SQL_INSERT_REFERENCES_SINGLEDB = "insert into JCR_SREF (NODE_ID, PROPERTY_ID, ORDER_NUM) values(?,?,?)";
    protected final String SQL_SELECT_JCRUUID;
    protected final String SQL_SELECT_FROZENJCRUUID;
    protected final String SQL_UPDATE_JCRUUID;
    protected final String SQL_SELECT_REFERENCES;
    protected final String SQL_INSERT_REFERENCES;
    private final Connection connection;
    private final String sourceName;
    private final boolean multiDB;

    private StorageUpdateManager(String sourceName, Connection connection, boolean multiDB) throws SQLException {
        this.connection = connection;
        this.sourceName = sourceName;
        this.multiDB = multiDB;
        this.SQL_SELECT_VERSION = multiDB ? SQL_SELECT_VERSION_MULTIDB : SQL_SELECT_VERSION_SINGLEDB;
        this.SQL_INSERT_VERSION = multiDB ? SQL_INSERT_VERSION_MULTIDB : SQL_INSERT_VERSION_SINGLEDB;
        this.SQL_UPDATE_VERSION = multiDB ? SQL_UPDATE_VERSION_MULTIDB : SQL_UPDATE_VERSION_SINGLEDB;
        this.SQL_SELECT_JCRUUID = multiDB ? SQL_SELECT_JCRUUID_MULTIDB : SQL_SELECT_JCRUUID_SINGLEDB;
        this.SQL_SELECT_FROZENJCRUUID = multiDB ? SQL_SELECT_FROZENJCRUUID_MULTIDB : SQL_SELECT_FROZENJCRUUID_SINGLEDB;
        this.SQL_UPDATE_JCRUUID = multiDB ? SQL_UPDATE_JCRUUID_MULTIDB : SQL_UPDATE_JCRUUID_SINGLEDB;
        this.SQL_SELECT_REFERENCES = multiDB ? SQL_SELECT_REFERENCES_MULTIDB : SQL_SELECT_REFERENCES_SINGLEDB;
        this.SQL_INSERT_REFERENCES = multiDB ? SQL_INSERT_REFERENCES_MULTIDB : SQL_INSERT_REFERENCES_SINGLEDB;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String checkVersion(String sourceName, Connection connection, boolean multiDB, boolean updateNow) throws RepositoryException {
        String string;
        int transactIsolation = 2;
        try {
            try {
                connection.setAutoCommit(false);
                transactIsolation = connection.getTransactionIsolation();
                connection.setTransactionIsolation(8);
                StorageUpdateManager manager = new StorageUpdateManager(sourceName, connection, multiDB);
                String version = manager.applyUpdate(updateNow);
                connection.commit();
                string = version;
                Object var9_10 = null;
            }
            catch (Exception e) {
                try {
                    connection.rollback();
                    throw new RepositoryException(e);
                }
                catch (SQLException er) {
                    log.warn("Error of connection rollback (close) " + er, er);
                }
                throw new RepositoryException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                connection.setTransactionIsolation(transactIsolation);
                connection.close();
                throw throwable;
            }
            catch (SQLException e2) {
                log.warn("Error of connection finalyzation (close) " + e2, e2);
                throw throwable;
            }
        }
        try {}
        catch (SQLException e2) {
            log.warn("Error of connection finalyzation (close) " + e2, e2);
            return string;
        }
        connection.setTransactionIsolation(transactIsolation);
        connection.close();
        return string;
    }

    private String applyUpdate(boolean updateNow) throws Exception {
        String curVersion = this.currentVersion();
        Updater updater = null;
        if (!curVersion.startsWith("1.7")) {
            log.warn("UPDATE IS NOT AVAILABLE from " + curVersion + " to " + "1.7" + " using auto-update option. Use XML export/import to migrate to the next version of JCR. " + "See for details: http://wiki.exoplatform.org/xwiki/bin/view/JCR/How+to+JCR+import+export. " + "All data which were created prior (with " + curVersion + " and older) and stored in external value storage(s) will be unavailable with storage " + "1.7" + ". " + "No auto-update changes was made to database.");
        }
        if (updater != null) {
            if (!updateNow) {
                log.warn("STORAGE VERSION OF " + this.sourceName + " IS " + curVersion + " IT IS HIGHLY RECOMMENDED TO UPDATE IT TO " + "1.7" + " ENABLE UPDATING in the CONFIGURATION:\n <container class='...'>\n" + "  <properties> \n   <property name='update-storage' value='true'/> \n ...\n");
            } else {
                updater.update();
                curVersion = "1.7";
            }
        }
        return curVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String currentVersion() throws SQLException {
        ResultSet version;
        block7: {
            String string;
            version = null;
            try {
                try {
                    version = this.connection.createStatement().executeQuery(this.SQL_SELECT_VERSION);
                    if (!version.next()) break block7;
                    string = version.getString("VERSION");
                    Object var5_5 = null;
                    if (version == null) return string;
                }
                catch (SQLException e) {
                    String string2 = "1.0";
                    Object var5_7 = null;
                    if (version == null) return string2;
                    version.close();
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (version == null) throw throwable;
                version.close();
                throw throwable;
            }
            version.close();
            return string;
        }
        Object var5_6 = null;
        if (version != null) {
            version.close();
        }
        PreparedStatement insertVersion = this.connection.prepareStatement(this.SQL_INSERT_VERSION);
        insertVersion.setString(1, "1.7");
        insertVersion.executeUpdate();
        return "1.7";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixCopyIdentifierBug(Connection conn) throws SQLException {
        Statement update;
        block11: {
            ResultSet refs = null;
            update = null;
            try {
                try {
                    refs = conn.createStatement().executeQuery(this.SQL_SELECT_JCRUUID);
                    update = conn.prepareStatement(this.SQL_UPDATE_JCRUUID);
                    while (refs.next()) {
                        try {
                            JcrIdentifier jcrIdentifier = new JcrIdentifier(refs.getString("PATH"), refs.getString("NID"), refs.getString("VID"), refs.getBinaryStream("DATA"));
                            if (jcrIdentifier.getNodeIdentifier().equals(jcrIdentifier.getJcrIdentifier())) continue;
                            log.info("STORAGE UPDATE >>>: Property jcr:uuid have to be updated with actual value. Property: " + jcrIdentifier.getPath() + ", actual:" + jcrIdentifier.getNodeIdentifier() + ", existed: " + jcrIdentifier.getJcrIdentifier());
                            update.clearParameters();
                            update.setBinaryStream(1, new ByteArrayInputStream(jcrIdentifier.getNodeIdentifier().getBytes()), jcrIdentifier.getNodeIdentifier().length());
                            update.setString(2, jcrIdentifier.getValueId());
                            if (update.executeUpdate() != 1) {
                                log.warn("STORAGE UPDATE !!!: More than one jcr:uuid property values were updated. Updated value id: " + jcrIdentifier.getValueId());
                                continue;
                            }
                            log.info("STORAGE UPDATE <<<: Property jcr:uuid update successful. Property: " + jcrIdentifier.getPath());
                        }
                        catch (IOException e) {
                            log.error("Can't read property value data: " + e.getMessage(), e);
                        }
                    }
                    Object var6_7 = null;
                    if (refs == null) break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Object var6_8 = null;
                    if (refs != null) {
                        refs.close();
                    }
                    if (update == null) return;
                    update.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (refs != null) {
                    refs.close();
                }
                if (update == null) throw throwable;
                update.close();
                throw throwable;
            }
            refs.close();
        }
        if (update == null) return;
        update.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixCopyFrozenIdentifierBug(JcrIdentifier jcrIdentifier, Connection conn) throws SQLException {
        Statement update;
        block10: {
            String searchCriteria = "'" + Constants.JCR_VERSION_STORAGE_PATH.getAsString() + ":1[]" + jcrIdentifier.getNodeIdentifier() + "%" + Constants.JCR_FROZENUUID.getAsString() + "%' ";
            ResultSet refs = null;
            update = null;
            try {
                try {
                    String sql = this.SQL_SELECT_FROZENJCRUUID.replaceAll(FROZENJCRUUID, searchCriteria);
                    refs = conn.createStatement().executeQuery(this.SQL_SELECT_FROZENJCRUUID);
                    while (refs.next()) {
                        try {
                            JcrIdentifier frozenIdentifier = new JcrIdentifier(refs.getString("PATH"), refs.getString("NID"), refs.getString("VID"), refs.getBinaryStream("DATA"));
                            if (frozenIdentifier.getNodeIdentifier().equals(frozenIdentifier.getJcrIdentifier())) continue;
                            log.info("VERSION STORAGE UPDATE >>>: Property jcr:frozenUuid have to be updated with actual value. Property: " + frozenIdentifier.getPath() + ", actual:" + jcrIdentifier.getNodeIdentifier() + ", existed: " + frozenIdentifier.getJcrIdentifier());
                        }
                        catch (IOException e) {
                            log.error("Can't read property value data: " + e.getMessage(), e);
                        }
                    }
                    Object var9_10 = null;
                    if (refs == null) break block10;
                }
                catch (SQLException e) {
                    log.error("Fix of copy uuid bug. Storage update error: " + e.getMessage(), e);
                    Object var9_11 = null;
                    if (refs != null) {
                        refs.close();
                    }
                    if (update == null) return;
                    update.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (refs != null) {
                    refs.close();
                }
                if (update == null) throw throwable;
                update.close();
                throw throwable;
            }
            refs.close();
        }
        if (update == null) return;
        update.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillReferences(Connection conn) throws SQLException {
        Statement update;
        block11: {
            ResultSet refs = null;
            update = null;
            try {
                try {
                    refs = conn.createStatement().executeQuery(this.SQL_SELECT_REFERENCES);
                    update = conn.prepareStatement(this.SQL_INSERT_REFERENCES);
                    while (refs.next()) {
                        try {
                            String refNodeIdentifier = new String(this.readIdentifierStream(refs.getBinaryStream("DATA")));
                            String refPropertyIdentifier = refs.getString("PROPERTY_ID");
                            int refOrderNum = refs.getInt("ORDER_NUM");
                            String refPropertyPath = refs.getString("PATH");
                            log.info("INSERT REFERENCE >>> Property: " + refPropertyPath + ", " + refPropertyIdentifier + ", " + refOrderNum + "; Node UUID: " + refNodeIdentifier);
                            update.clearParameters();
                            update.setString(1, refNodeIdentifier);
                            update.setString(2, refPropertyIdentifier);
                            update.setInt(3, refOrderNum);
                            if (update.executeUpdate() != 1) {
                                log.warn("INSERT REFERENCE !!!: More than one REFERENCE property was copied");
                                continue;
                            }
                            log.info("INSERT REFERENCE <<<: Done. Property: " + refPropertyPath);
                        }
                        catch (IOException e) {
                            log.error("Can't read property value data: " + e.getMessage(), e);
                        }
                    }
                    Object var9_10 = null;
                    if (refs == null) break block11;
                }
                catch (SQLException e) {
                    log.error("Fill references. Storage update error: " + e.getMessage(), e);
                    Object var9_11 = null;
                    if (refs != null) {
                        refs.close();
                    }
                    if (update == null) return;
                    update.close();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (refs != null) {
                    refs.close();
                }
                if (update == null) throw throwable;
                update.close();
                throw throwable;
            }
            refs.close();
        }
        if (update == null) return;
        update.close();
    }

    private byte[] readIdentifierStream(InputStream stream) throws IOException {
        byte[] buf = new byte[32];
        stream.read(buf);
        return buf;
    }

    private class Updater101
    extends Updater {
        private Updater101() {
        }

        public void updateBody(Connection conn) throws SQLException {
            StorageUpdateManager.this.fillReferences(conn);
        }
    }

    private class Updater100
    extends Updater {
        private Updater100() {
        }

        public void updateBody(Connection conn) throws SQLException {
            StorageUpdateManager.this.fixCopyIdentifierBug(conn);
            StorageUpdateManager.this.fillReferences(conn);
        }
    }

    private abstract class Updater {
        private Updater() {
        }

        protected abstract void updateBody(Connection var1) throws SQLException;

        public void update() throws SQLException {
            try {
                this.updateBody(StorageUpdateManager.this.connection);
                PreparedStatement insertVersion = StorageUpdateManager.this.connection.prepareStatement(StorageUpdateManager.this.SQL_UPDATE_VERSION);
                insertVersion.setString(1, "1.7");
                insertVersion.executeUpdate();
                StorageUpdateManager.this.connection.commit();
            }
            catch (Exception e) {
                try {
                    StorageUpdateManager.this.connection.rollback();
                }
                catch (SQLException sqle) {
                    log.warn("Error of update rollback: " + sqle.getMessage(), sqle);
                }
            }
        }
    }

    private class JcrIdentifier {
        private final String path;
        private final String nodeIdentifier;
        private final String jcrIdentifier;
        private final String valueId;

        public JcrIdentifier(String path, String nodeIdentifier, String valueId, InputStream valueData) throws IOException {
            this.path = path;
            this.nodeIdentifier = nodeIdentifier;
            this.valueId = valueId;
            this.jcrIdentifier = new String(StorageUpdateManager.this.readIdentifierStream(valueData));
        }

        public String getNodeIdentifier() {
            return this.nodeIdentifier;
        }

        public String getJcrIdentifier() {
            return this.jcrIdentifier;
        }

        public String getPath() {
            return this.path;
        }

        public String getValueId() {
            return this.valueId;
        }
    }
}

