/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.PropertyType;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.ValueStorageFilterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataNotFoundException;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValuePluginFilter;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneStoragePluginProvider
extends ArrayList<ValueStoragePlugin>
implements ValueStoragePluginProvider {
    private static final long serialVersionUID = 4537116106932443262L;
    private static Log log = ExoLogger.getLogger("jcr.ValueStoragePluginFactory");

    public StandaloneStoragePluginProvider(WorkspaceEntry wsConfig) throws RepositoryConfigurationException, IOException {
        ArrayList storages = wsConfig.getContainer().getValueStorages();
        if (storages != null) {
            for (ValueStorageEntry storageEntry : storages) {
                for (ValueStoragePlugin vsp : this) {
                    if (!vsp.getId().equals(storageEntry.getId())) continue;
                    throw new RepositoryConfigurationException("Value storage with ID '" + storageEntry.getId() + "' already exists");
                }
                Object o = null;
                try {
                    o = Class.forName(storageEntry.getType()).newInstance();
                }
                catch (Exception e) {
                    log.error("Value Storage Plugin instantiation FAILED. ", e);
                    continue;
                }
                if (!(o instanceof ValueStoragePlugin)) {
                    log.error("Not a ValueStoragePlugin object IGNORED: " + o);
                    continue;
                }
                ValueStoragePlugin plugin = o;
                ArrayList<ValuePluginFilter> filters = new ArrayList<ValuePluginFilter>();
                ArrayList<ValueStorageFilterEntry> filterEntries = storageEntry.getFilters();
                for (ValueStorageFilterEntry filterEntry : filterEntries) {
                    ValuePluginFilter filter = new ValuePluginFilter(PropertyType.valueFromName(filterEntry.getPropertyType()), null, null, filterEntry.getMinValueSize());
                    filters.add(filter);
                }
                Properties props = new Properties();
                List paramEntries = storageEntry.getParameters();
                for (SimpleParameterEntry paramEntry : paramEntries) {
                    props.setProperty(paramEntry.getName(), paramEntry.getValue());
                }
                plugin.init(props);
                plugin.setId(storageEntry.getId());
                plugin.setFilters(filters);
                this.add(plugin);
                log.info("Value Storage Plugin initialized " + plugin);
            }
        }
    }

    @Override
    public ValueIOChannel getApplicableChannel(PropertyData property, int valueOrderNumer) throws IOException {
        for (ValueStoragePlugin plugin : this) {
            List<ValuePluginFilter> filters = plugin.getFilters();
            for (ValuePluginFilter filter : filters) {
                if (!filter.match(property, valueOrderNumer)) continue;
                return plugin.openIOChannel();
            }
        }
        return null;
    }

    @Override
    public Iterator<ValueStoragePlugin> plugins() {
        return this.iterator();
    }

    @Override
    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
        Iterator<ValueStoragePlugin> plugins = this.plugins();
        while (plugins.hasNext()) {
            ValueStoragePlugin plugin = plugins.next();
            plugin.checkConsistency(dataConnection);
        }
    }

    @Override
    public ValueIOChannel getChannel(String storageId) throws IOException, ValueDataNotFoundException {
        for (ValueStoragePlugin plugin : this) {
            if (!plugin.match(storageId)) continue;
            return plugin.openIOChannel();
        }
        throw new ValueDataNotFoundException("No value storage found with id " + storageId);
    }
}

