/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.exporting.HandlingContentExporter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SystemViewContentExporter
extends HandlingContentExporter {
    public SystemViewContentExporter(ContentHandler handler, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(handler, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(this.getSvNamespaceUri(), "name", "sv:name", "CDATA", this.getExportName(node, false));
            this.contentHandler.startElement(this.getSvNamespaceUri(), "node", "sv:node", atts);
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(this.getSvNamespaceUri(), "name", "sv:name", "CDATA", this.getExportName(property, false));
            atts.addAttribute(this.getSvNamespaceUri(), "type", "sv:type", "CDATA", ExtendedPropertyType.nameFromValue(property.getType()));
            this.contentHandler.startElement(this.getSvNamespaceUri(), "property", "sv:property", atts);
            List<ValueData> values = property.getValues();
            for (ValueData valueData : values) {
                this.contentHandler.startElement(this.getSvNamespaceUri(), "value", "sv:value", new AttributesImpl());
                this.writeValueData(valueData, property.getType());
                this.contentHandler.endElement(this.getSvNamespaceUri(), "value", "sv:value");
            }
        }
        catch (SAXException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), e);
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), e);
        }
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            this.contentHandler.endElement(this.getSvNamespaceUri(), "node", "sv:node");
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
        try {
            this.contentHandler.endElement(this.getSvNamespaceUri(), "property", "sv:property");
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    protected void writeValueData(ValueData data, int type) throws RepositoryException, IllegalStateException, IOException, SAXException {
        if (2 == type) {
            if (!this.isSkipBinary()) {
                if (data.getLength() < 9216L) {
                    String charValue = this.getValueAsStringForExport(data, type);
                    this.contentHandler.characters(charValue.toCharArray(), 0, charValue.length());
                } else {
                    int len;
                    InputStream is = data.getAsStream();
                    byte[] buffer = new byte[9216];
                    while ((len = is.read(buffer)) > 0) {
                        char[] charbuf1 = Base64.encode(buffer, 0, len, 0, "").toCharArray();
                        this.contentHandler.characters(charbuf1, 0, charbuf1.length);
                    }
                }
            }
        } else {
            String charValue = this.getValueAsStringForExport(data, type);
            this.contentHandler.characters(charValue.toCharArray(), 0, charValue.length());
        }
    }
}

