/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.impl.Jdk14Logger;
import org.exoplatform.services.log.impl.BufferedLog;

public class BufferedJdk14Logger
extends Jdk14Logger {
    private BufferedLog bufLogger;

    public BufferedJdk14Logger(String name) {
        super(name);
        this.bufLogger = new BufferedLog(this, name);
    }

    public void debug(Object message) {
        this.log(Level.FINE, String.valueOf(message), null);
        this.bufLogger.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.log(Level.FINE, String.valueOf(message), t);
        this.bufLogger.debug(message, t);
    }

    public void info(Object message) {
        this.log(Level.INFO, String.valueOf(message), null);
        this.bufLogger.info(message);
    }

    public void info(Object message, Throwable t) {
        this.log(Level.INFO, String.valueOf(message), t);
        this.bufLogger.info(message, t);
    }

    public void warn(Object message) {
        this.log(Level.WARNING, String.valueOf(message), null);
        this.bufLogger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, String.valueOf(message), t);
        this.bufLogger.warn(message, t);
    }

    public void error(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
        this.bufLogger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, String.valueOf(message), t);
        this.bufLogger.error(message, t);
    }

    public void fatal(Object message) {
        this.log(Level.SEVERE, String.valueOf(message), null);
        this.bufLogger.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.log(Level.SEVERE, String.valueOf(message), t);
        this.bufLogger.fatal(message, t);
    }

    private void log(Level level, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (locations != null && locations.length > 2) {
                StackTraceElement caller = locations[2];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            if (ex == null) {
                logger.logp(level, cname, method, msg);
            } else {
                logger.logp(level, cname, method, msg, ex);
            }
        }
    }
}

