/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.log.impl;

import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Level;
import org.exoplatform.services.log.impl.BufferedLog;

public class BufferedLog4JLogger
extends Log4JLogger {
    private BufferedLog bufLogger;
    private static final String FQCN = BufferedLog4JLogger.class.getName();

    public BufferedLog4JLogger(String name) {
        super(name);
        this.bufLogger = new BufferedLog(this, name);
    }

    public void debug(Object message) {
        this.getLogger().log(FQCN, Level.DEBUG, message, null);
        this.bufLogger.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.getLogger().log(FQCN, Level.DEBUG, message, t);
        this.bufLogger.debug(message, t);
    }

    public void info(Object message) {
        this.getLogger().log(FQCN, Level.INFO, message, null);
        this.bufLogger.info(message);
    }

    public void info(Object message, Throwable t) {
        this.getLogger().log(FQCN, Level.INFO, message, t);
        this.bufLogger.info(message, t);
    }

    public void warn(Object message) {
        this.getLogger().log(FQCN, Level.WARN, message, null);
        this.bufLogger.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.getLogger().log(FQCN, Level.WARN, message, t);
        this.bufLogger.warn(message, t);
    }

    public void error(Object message) {
        this.getLogger().log(FQCN, Level.ERROR, message, null);
        this.bufLogger.error(message);
    }

    public void error(Object message, Throwable t) {
        this.getLogger().log(FQCN, Level.ERROR, message, t);
        this.bufLogger.error(message, t);
    }

    public void fatal(Object message) {
        this.getLogger().log(FQCN, Level.FATAL, message, null);
        this.bufLogger.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.getLogger().log(FQCN, Level.FATAL, message, null);
        this.bufLogger.fatal(message);
    }
}

