/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.mail.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.ExoAuthenticator;

public class MailServiceImpl
implements MailService {
    private Session mailSession_;
    private Properties props_ = new Properties(System.getProperties());

    public MailServiceImpl(InitParams params) throws Exception {
        this.props_.putAll((Map<?, ?>)params.getPropertiesParam("config").getProperties());
        if ("true".equals(this.props_.getProperty("mail.smtp.auth"))) {
            String username = this.props_.getProperty("mail.smtp.auth.username");
            String password = this.props_.getProperty("mail.smtp.auth.password");
            ExoAuthenticator auth = new ExoAuthenticator(username, password);
            this.mailSession_ = Session.getDefaultInstance(this.props_, auth);
        } else {
            this.mailSession_ = Session.getDefaultInstance(this.props_, null);
        }
    }

    public Session getMailSession() {
        return this.mailSession_;
    }

    public String getOutgoingMailServer() {
        return this.props_.getProperty("mail.smtp.host");
    }

    public void sendMessage(String from, String to, String subject, String body) throws MessagingException, IOException {
        Message message = new Message();
        message.setFrom(from);
        message.setTo(to);
        message.setSubject(subject);
        message.setBody(body);
        this.sendMessage(message);
    }

    public void sendMessage(Message message) throws MessagingException {
        int i;
        MimeMessage mimeMessage = new MimeMessage(this.getMailSession());
        String FROM = message.getFrom();
        String TO = message.getTo();
        String CC = message.getCC();
        String BCC = message.getBCC();
        String subject = message.getSubject();
        String mimeType = message.getMimeType();
        String body = message.getBody();
        List<Attachment> attachment = message.getAttachment();
        if (FROM != null && !FROM.equals("")) {
            InternetAddress sentFrom = new InternetAddress(FROM);
            mimeMessage.setFrom(sentFrom);
        }
        Address[] sendTo = new InternetAddress[this.getArrs(TO).length];
        for (int i2 = 0; i2 < this.getArrs(TO).length; ++i2) {
            sendTo[i2] = new InternetAddress(this.getArrs(TO)[i2]);
        }
        mimeMessage.setRecipients(Message.RecipientType.TO, sendTo);
        if (this.getArrs(CC) != null && this.getArrs(CC).length > 0) {
            Address[] copyTo = new InternetAddress[this.getArrs(CC).length];
            for (i = 0; i < this.getArrs(CC).length; ++i) {
                copyTo[i] = new InternetAddress(this.getArrs(CC)[i]);
            }
            mimeMessage.setRecipients(Message.RecipientType.CC, copyTo);
        }
        if (this.getArrs(BCC) != null && this.getArrs(BCC).length > 0) {
            Address[] bccTo = new InternetAddress[this.getArrs(BCC).length];
            for (i = 0; i < this.getArrs(BCC).length; ++i) {
                bccTo[i] = new InternetAddress(this.getArrs(BCC)[i]);
            }
            mimeMessage.setRecipients(Message.RecipientType.BCC, bccTo);
        }
        mimeMessage.setSubject(subject);
        if (attachment != null && attachment.size() > 0) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            if (mimeType != null && !mimeType.equals("")) {
                messageBodyPart.setContent(body, mimeType);
            } else {
                messageBodyPart.setContent(body, "text/plain");
            }
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart(messageBodyPart);
            mimeMessage.setContent(multipart);
        } else if (mimeType != null && !mimeType.equals("")) {
            mimeMessage.setContent(body, mimeType);
        } else {
            mimeMessage.setContent(body, "text/plain");
        }
        this.sendMessage(mimeMessage);
    }

    public void sendMessage(MimeMessage message) throws MessagingException {
        try {
            Transport.send(message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    private String[] getArrs(String toArray) {
        if (toArray != null && !toArray.equals("")) {
            return toArray.split(",");
        }
        return null;
    }
}

