/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.remote.group.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.remote.group.CommunicationService;
import org.exoplatform.services.remote.group.CommunicationServiceMonitor;
import org.exoplatform.services.remote.group.MemberInfo;
import org.exoplatform.services.remote.group.Message;
import org.exoplatform.services.remote.group.MessageHandler;
import org.exoplatform.services.remote.group.PingResult;
import org.exoplatform.services.remote.group.Response;
import org.exoplatform.services.remote.group.ResultHandler;
import org.exoplatform.services.remote.group.impl.CommunicationChannelListener;
import org.exoplatform.services.remote.group.impl.MessageImpl;
import org.exoplatform.services.remote.group.impl.RequestHandlerImpl;
import org.exoplatform.services.remote.group.impl.Util;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

@Deprecated
public class CommunicationServiceImpl
implements CommunicationService {
    private String properties_;
    private JChannel channel_;
    private MessageDispatcher mdispatcher_;
    private RequestHandlerImpl requestHandler_;
    private CommunicationChannelListener channelListener_ = new CommunicationChannelListener();
    private Log LOG = ExoLogger.getLogger(CommunicationServiceImpl.class.getName());

    public CommunicationServiceImpl(InitParams confParams) throws Exception {
        ValuesParam param = confParams.getValuesParam("jgroups.channel.properties");
        ArrayList values = param.getValues();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            b.append((String)values.get(i));
            if (i == values.size() - 1) continue;
            b.append(":");
        }
        this.properties_ = b.toString();
        this.configure(this.properties_);
    }

    public void configure(String props) throws Exception {
        this.channel_ = new JChannel(props);
        this.requestHandler_ = new RequestHandlerImpl();
        this.mdispatcher_ = new MessageDispatcher((Channel)this.channel_, null, null, (RequestHandler)this.requestHandler_);
        this.channel_.setChannelListener((ChannelListener)this.channelListener_);
        this.channel_.connect("Portal");
    }

    public synchronized void addPlugin(ComponentPlugin plugin) {
        MessageHandler handler = (MessageHandler)plugin;
        handler.init(this);
        this.requestHandler_.registerMessageHandler(handler);
    }

    public ComponentPlugin removePlugin(String name) {
        throw new RuntimeException("this method is not supported");
    }

    public Collection getPlugins() {
        throw new RuntimeException("");
    }

    public Message createMessage(String targetHandler) {
        MessageImpl m = new MessageImpl();
        m.setTargetHandler(targetHandler);
        return m;
    }

    public synchronized Object send(MemberInfo member, Message message) throws Exception {
        Address dest = Util.findAddress(this.channel_, member);
        if (dest == null) {
            throw new Exception("Cannot find the member: " + member.getIpAddress());
        }
        org.jgroups.Message jmessage = new org.jgroups.Message(dest, null, (Serializable)message);
        Object result = this.mdispatcher_.sendMessage(jmessage, 2, 0L);
        return result;
    }

    public synchronized void broadcast(Message message, boolean include) throws Exception {
        Vector members = null;
        if (!include) {
            members = this.getMembersExcludeMe();
        }
        org.jgroups.Message jmessage = new org.jgroups.Message(null, null, (Serializable)message);
        this.mdispatcher_.castMessage(members, jmessage, 6, 0L);
    }

    public synchronized void broadcast(Message message, ResultHandler handler, boolean include) throws Exception {
        Vector members = null;
        if (!include) {
            members = this.getMembersExcludeMe();
        }
        org.jgroups.Message jmessage = new org.jgroups.Message(null, null, (Serializable)message);
        RspList res = this.mdispatcher_.castMessage(members, jmessage, 2, 0L);
        Response response = new Response();
        Vector list = res.getResults();
        for (int i = 0; i < list.size(); ++i) {
            Rsp rsp = (Rsp)list.get(i);
            response.populate(rsp);
            handler.handleResponse(response);
        }
    }

    public synchronized PingResult ping(MemberInfo member, String message) throws Exception {
        Address dest = Util.findAddress(this.channel_, member);
        if (dest == null) {
            throw new Exception("Cannot find the member: " + member.getIpAddress());
        }
        Message pingMesg = this.createMessage("PingMessageHandler");
        pingMesg.setMessage(message);
        org.jgroups.Message jmessage = new org.jgroups.Message(dest, null, (Serializable)pingMesg);
        Object result = this.mdispatcher_.sendMessage(jmessage, 2, 0L);
        PingResult p = new PingResult(member, (String)result);
        return p;
    }

    public synchronized List pingAll(String message) throws Exception {
        Message pingMesg = this.createMessage("PingMessageHandler");
        pingMesg.setMessage(message);
        org.jgroups.Message jmessage = new org.jgroups.Message(null, null, (Serializable)pingMesg);
        RspList res = this.mdispatcher_.castMessage(null, jmessage, 2, 0L);
        ArrayList<PingResult> results = new ArrayList<PingResult>();
        for (int i = 0; i < res.size(); ++i) {
            Rsp rsp = (Rsp)res.elementAt(i);
            PingResult result = new PingResult(Util.createMemberInfo(rsp.getSender()), (String)rsp.getValue());
            results.add(result);
        }
        return results;
    }

    public CommunicationServiceMonitor getCommunicationServiceMonitor(MemberInfo info) throws Exception {
        if (info == null) {
            info = Util.createMemberInfo(this.channel_.getView().getCreator());
            CommunicationServiceMonitor monitor = new CommunicationServiceMonitor(this.requestHandler_.getMessageHandlerMonitors(), info);
            return monitor;
        }
        Message message = this.createMessage("GetCommunicationMonitorHandler");
        CommunicationServiceMonitor monitor = (CommunicationServiceMonitor)this.send(info, message);
        return monitor;
    }

    public List getMembersInfo() {
        ArrayList<MemberInfo> list = new ArrayList<MemberInfo>();
        View view = this.channel_.getView();
        Vector members = view.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Object member = members.get(i);
            list.add(Util.createMemberInfo(member));
        }
        return list;
    }

    public Vector getMembersExcludeMe() {
        View view = this.channel_.getView();
        Address addr = view.getCreator();
        Vector members = view.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Object member = members.get(i);
            if (!member.equals(addr)) continue;
            members.remove(i);
            return members;
        }
        return members;
    }

    public String getInfo() {
        StringBuffer b = new StringBuffer();
        List members = this.getMembersInfo();
        for (int i = 0; i < members.size(); ++i) {
            MemberInfo addr = (MemberInfo)members.get(i);
            b.append("Name: " + addr.getHostName()).append("; Address " + addr.getIpAddress()).append("; Port " + addr.getPort()).append("\n");
        }
        return b.toString();
    }
}

