/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources.impl;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;

public class LocaleConfigImpl
implements LocaleConfig {
    private static Map<String, Locale> predefinedLocaleMap_ = null;
    private Locale locale_;
    private String outputEncoding_;
    private String inputEncoding_;
    private String description_;
    private String localeName_;
    private Orientation orientation;

    public final String getDescription() {
        return this.description_;
    }

    public final void setDescription(String desc) {
        this.description_ = desc;
    }

    public final String getOutputEncoding() {
        return this.outputEncoding_;
    }

    public final void setOutputEncoding(String enc) {
        this.outputEncoding_ = enc;
    }

    public final String getInputEncoding() {
        return this.inputEncoding_;
    }

    public final void setInputEncoding(String enc) {
        this.inputEncoding_ = enc;
    }

    public final Locale getLocale() {
        return this.locale_;
    }

    public final void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public final void setLocale(String localeName) {
        this.localeName_ = localeName;
        this.locale_ = predefinedLocaleMap_.get(localeName);
        if (this.locale_ == null) {
            this.locale_ = new Locale(localeName);
        }
    }

    public final String getLanguage() {
        return this.locale_.getLanguage();
    }

    public final String getLocaleName() {
        return this.localeName_;
    }

    public ResourceBundle getResourceBundle(String name) {
        ResourceBundleService service = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(name, this.locale_);
        return res;
    }

    public ResourceBundle getMergeResourceBundle(String[] names) {
        ResourceBundleService service = (ResourceBundleService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(names, this.locale_);
        return res;
    }

    public ResourceBundle getNavigationResourceBundle(String ownerType, String ownerId) {
        return this.getResourceBundle("locale.navigation." + ownerType + "." + ownerId.replaceAll("/", "."));
    }

    public void setInput(HttpServletRequest req) throws UnsupportedEncodingException {
        req.setCharacterEncoding(this.inputEncoding_);
    }

    public void setOutput(HttpServletResponse res) {
        res.setContentType("text/html; charset=" + this.outputEncoding_);
        res.setLocale(this.locale_);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    static {
        predefinedLocaleMap_ = new HashMap<String, Locale>(10);
        predefinedLocaleMap_.put("us", Locale.US);
        predefinedLocaleMap_.put("en", Locale.ENGLISH);
        predefinedLocaleMap_.put("fr", Locale.FRANCE);
        predefinedLocaleMap_.put("zh", Locale.SIMPLIFIED_CHINESE);
    }
}

