/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.filter;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.RequestFilter;

public final class UriNormalizationFilter
implements RequestFilter {
    public void doFilter(GenericContainerRequest request) {
        request.setUris(UriNormalizationFilter.normalize(request.getRequestUri()), request.getBaseUri());
    }

    private static URI normalize(URI uri) {
        String oldPath = uri.getRawPath();
        String normalizedPath = UriNormalizationFilter.removeDotSegments(oldPath.toLowerCase());
        if (normalizedPath.equals(oldPath)) {
            return uri;
        }
        return UriBuilder.fromUri(uri).replacePath(normalizedPath).build(new Object[0]);
    }

    private static boolean isComplitePathSeg(String segment, String path) {
        boolean result = false;
        int segPlace = path.indexOf(segment);
        result = path.equals("/" + segment) ? true : path.charAt(segPlace + segment.length()) == '/';
        return result;
    }

    private static String removeDotSegments(String path) {
        String inputBuffer = path;
        StringBuffer outputBuffer = new StringBuffer();
        if (inputBuffer.contains("//")) {
            inputBuffer = inputBuffer.replaceAll("//", "/");
        }
        while (inputBuffer.length() != 0) {
            if (inputBuffer.startsWith("../") || inputBuffer.startsWith("./")) {
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf("/") + 1, inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/./") || inputBuffer.startsWith("/.") && UriNormalizationFilter.isComplitePathSeg(".", inputBuffer)) {
                if (inputBuffer.equals("/.")) {
                    inputBuffer = "";
                    outputBuffer.append("/");
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf("/", 1), inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/../") || inputBuffer.startsWith("/..") && UriNormalizationFilter.isComplitePathSeg("..", inputBuffer)) {
                if (inputBuffer.equals("/..")) {
                    inputBuffer = "";
                    outputBuffer.delete(outputBuffer.lastIndexOf("/") + 1, outputBuffer.length());
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf("/", 1), inputBuffer.length());
                outputBuffer.delete(outputBuffer.lastIndexOf("/"), outputBuffer.length());
                continue;
            }
            if (inputBuffer.equals(".") || inputBuffer.equals("..")) {
                inputBuffer = "";
                continue;
            }
            if (inputBuffer.indexOf("/") != inputBuffer.lastIndexOf(47)) {
                outputBuffer.append(inputBuffer.substring(0, inputBuffer.indexOf("/", 1)));
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf("/", 1));
                continue;
            }
            outputBuffer.append(inputBuffer);
            inputBuffer = "";
        }
        return outputBuffer.toString();
    }
}

