/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.ext.method.filter;

import java.lang.annotation.Annotation;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.GenericMethodResource;

public class MethodAccessFilter
implements MethodInvokerFilter {
    public void accept(GenericMethodResource method) throws WebApplicationException {
        for (Annotation a : method.getMethod().getAnnotations()) {
            Class<? extends Annotation> ac = a.annotationType();
            if (ac == PermitAll.class) {
                return;
            }
            if (ac == DenyAll.class) {
                throw new WebApplicationException(Response.status(Response.Status.FORBIDDEN).build());
            }
            if (ac != RolesAllowed.class) continue;
            SecurityContext context = ApplicationContext.getCurrent().getSecurityContext();
            for (String role : MethodAccessFilter.getAllowedRoles(a)) {
                if (!context.isUserInRole(role)) continue;
                return;
            }
            throw new WebApplicationException(Response.status(Response.Status.FORBIDDEN).build());
        }
    }

    private static String[] getAllowedRoles(Annotation roles) {
        return ((RolesAllowed)roles).value();
    }
}

