/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.impl.VariantsHandler;
import org.exoplatform.services.rest.impl.header.AcceptLanguage;
import org.exoplatform.services.rest.impl.header.AcceptMediaType;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.impl.header.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerRequest
implements GenericContainerRequest {
    private String method;
    private InputStream entityStream;
    private MultivaluedMap<String, String> httpHeaders;
    private Map<String, Cookie> cookies;
    private List<String> cookieHeaders;
    private MediaType contentType;
    private Locale contentLanguage;
    private List<MediaType> acceptMediaType;
    private List<Locale> acceptLanguage;
    private URI requestUri;
    private URI baseUri;

    public ContainerRequest(String method, URI requestUri, URI baseUri, InputStream entityStream, MultivaluedMap<String, String> httpHeaders) {
        this.method = method;
        this.requestUri = requestUri;
        this.baseUri = baseUri;
        this.entityStream = entityStream;
        this.httpHeaders = httpHeaders;
    }

    @Override
    public MediaType getAcceptableMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return this.getAcceptableMediaTypes().get(0);
        }
        List<MediaType> l = this.getAcceptableMediaTypes();
        for (MediaType at : l) {
            if (at.isWildcardType()) {
                return mediaTypes.get(0);
            }
            for (MediaType rt : mediaTypes) {
                if (!rt.isCompatible(at) || rt.isWildcardType() || rt.isWildcardSubtype()) continue;
                return rt;
            }
        }
        return null;
    }

    @Override
    public List<String> getCookieHeaders() {
        if (this.cookieHeaders == null) {
            List<String> c = this.getRequestHeader("Cookie");
            this.cookieHeaders = c != null && c.size() > 0 ? Collections.unmodifiableList(this.getRequestHeader("Cookie")) : Collections.emptyList();
        }
        return this.cookieHeaders;
    }

    @Override
    public InputStream getEntityStream() {
        return this.entityStream;
    }

    @Override
    public URI getRequestUri() {
        return this.requestUri;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setEntityStream(InputStream entityStream) {
        this.entityStream = entityStream;
        ApplicationContext.getCurrent().getAttributes().remove("org.exoplatform.ws.rest.entity.form");
    }

    @Override
    public void setUris(URI requestUri, URI baseUri) {
        this.requestUri = requestUri;
        this.baseUri = baseUri;
    }

    @Override
    public void setCookieHeaders(List<String> cookieHeaders) {
        this.cookieHeaders = cookieHeaders;
        this.cookies = null;
    }

    @Override
    public void setRequestHeaders(MultivaluedMap<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        this.cookieHeaders = null;
        this.cookies = null;
        this.contentType = null;
        this.contentLanguage = null;
        this.acceptMediaType = null;
        this.acceptLanguage = null;
    }

    @Override
    public String getAuthenticationScheme() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(EntityTag etag) {
        Response.ResponseBuilder rb = this.evaluateIfMatch(etag);
        if (rb != null) {
            return rb;
        }
        return this.evaluateIfNoneMatch(etag);
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder rb = this.evaluateIfModified(lastModifiedTime);
        if (rb != null) {
            return rb;
        }
        return this.evaluateIfUnmodified(lastModifiedTime);
    }

    @Override
    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag etag) {
        Response.ResponseBuilder rb = this.evaluateIfMatch(etag);
        if (rb != null) {
            return rb;
        }
        long lastModifiedTime = lastModified.getTime();
        rb = this.evaluateIfModified(lastModifiedTime);
        if (rb != null) {
            return rb;
        }
        rb = this.evaluateIfNoneMatch(etag);
        if (rb != null) {
            return rb;
        }
        return this.evaluateIfUnmodified(lastModifiedTime);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Variant selectVariant(List<Variant> variants) {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("The list of variants is null or empty");
        }
        return VariantsHandler.handleVariants(this, variants);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        if (this.acceptLanguage == null) {
            List<AcceptLanguage> l = HeaderHelper.createAcceptedLanguageList(HeaderHelper.convertToString(this.getRequestHeader("Accept-Language")));
            ArrayList<Locale> t = new ArrayList<Locale>(l.size());
            for (AcceptLanguage al : l) {
                t.add(al.getLocale());
            }
            this.acceptLanguage = Collections.unmodifiableList(t);
        }
        return this.acceptLanguage;
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        if (this.acceptMediaType == null) {
            ArrayList<AcceptMediaType> t = new ArrayList<AcceptMediaType>(HeaderHelper.createAcceptedMediaTypeList(HeaderHelper.convertToString(this.getRequestHeader("Accept"))));
            this.acceptMediaType = Collections.unmodifiableList(t);
        }
        return this.acceptMediaType;
    }

    @Override
    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            HashMap<String, Cookie> t = new HashMap<String, Cookie>();
            for (String ch : this.getCookieHeaders()) {
                List<Cookie> l = HeaderHelper.parseCookies(ch);
                for (Cookie c : l) {
                    t.put(c.getName(), c);
                }
            }
            this.cookies = Collections.unmodifiableMap(t);
        }
        return this.cookies;
    }

    @Override
    public Locale getLanguage() {
        if (this.contentLanguage == null && this.httpHeaders.getFirst("Content-Language") != null) {
            this.contentLanguage = Language.getLocale(this.httpHeaders.getFirst("Content-Language"));
        }
        return this.contentLanguage;
    }

    @Override
    public MediaType getMediaType() {
        if (this.contentType == null && this.httpHeaders.getFirst("Content-Type") != null) {
            this.contentType = MediaType.valueOf(this.httpHeaders.getFirst("Content-Type"));
        }
        return this.contentType;
    }

    @Override
    public List<String> getRequestHeader(String name) {
        return (List)this.httpHeaders.get(name);
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.httpHeaders;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag etag) {
        String ifMatch = this.getRequestHeaders().getFirst("If-Match");
        if (ifMatch == null) {
            return null;
        }
        EntityTag otherEtag = EntityTag.valueOf(ifMatch);
        if (etag.isWeak() || otherEtag.isWeak() || !"*".equals(otherEtag.getValue()) && !etag.getValue().equals(otherEtag.getValue())) {
            return Response.status(Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag etag) {
        String ifNoneMatch = this.getRequestHeaders().getFirst("If-None-Match");
        if (ifNoneMatch == null) {
            return null;
        }
        EntityTag otherEtag = EntityTag.valueOf(ifNoneMatch);
        String httpMethod = this.getMethod();
        if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
            if ("*".equals(otherEtag.getValue()) || etag.getValue().equals(otherEtag.getValue())) {
                return Response.notModified(etag);
            }
        } else if (!etag.isWeak() && !otherEtag.isWeak() && ("*".equals(otherEtag.getValue()) || etag.getValue().equals(otherEtag.getValue()))) {
            return Response.status(Response.Status.PRECONDITION_FAILED);
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModified(long lastModified) {
        String ifUnmodified = this.getRequestHeaders().getFirst("If-Unmodified-Since");
        if (ifUnmodified == null) {
            return null;
        }
        try {
            long unmodifiedSince = HeaderHelper.parseDateHeader(ifUnmodified).getTime();
            if (lastModified > unmodifiedSince) {
                return Response.status(Response.Status.PRECONDITION_FAILED);
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodified(long lastModified) {
        String ifModified = this.getRequestHeaders().getFirst("If-Modified-Since");
        if (ifModified == null) {
            return null;
        }
        try {
            long modifiedSince = HeaderHelper.parseDateHeader(ifModified).getTime();
            if (lastModified < modifiedSince) {
                return Response.notModified();
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        return null;
    }
}

