/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.List;
import javax.ws.rs.core.Cookie;
import org.exoplatform.services.rest.header.AbstractHeaderDelegate;
import org.exoplatform.services.rest.impl.header.HeaderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieHeaderDelegate
extends AbstractHeaderDelegate<Cookie> {
    @Override
    public Class<Cookie> support() {
        return Cookie.class;
    }

    @Override
    public Cookie fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        List<Cookie> l = HeaderHelper.parseCookies(header);
        if (l.size() > 0) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public String toString(Cookie cookie) {
        StringBuilder sb = new StringBuilder();
        sb.append("$Version=").append(cookie.getVersion()).append(';');
        sb.append(cookie.getName()).append('=').append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getValue()));
        if (cookie.getDomain() != null) {
            sb.append(';').append("$Domain=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getDomain()));
        }
        if (cookie.getPath() != null) {
            sb.append(';').append("$Path=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getPath()));
        }
        return sb.toString();
    }
}

