/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.Locale;
import javax.ws.rs.ext.RuntimeDelegate;

public class Language {
    private static final RuntimeDelegate.HeaderDelegate<Locale> DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(Locale.class);
    private final Locale locale;

    public Language(Locale locale) {
        this.locale = locale;
    }

    public static Locale getLocale(String language) {
        return DELEGATE.fromString(language);
    }

    public String getPrimaryTag() {
        return this.locale.getLanguage().toLowerCase();
    }

    public String getSubTag() {
        return this.locale.getCountry().toLowerCase();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isCompatible(Language other) {
        if (other == null) {
            return false;
        }
        if ("*".equals(this.getPrimaryTag())) {
            return true;
        }
        if (this.getPrimaryTag().equalsIgnoreCase(other.getPrimaryTag()) && "".equals(this.getSubTag())) {
            return true;
        }
        return this.toString().equalsIgnoreCase(other.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getPrimaryTag());
        if (!"".equals(this.getSubTag())) {
            sb.append('-').append(this.getSubTag());
        }
        return sb.toString();
    }
}

