/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.ParameterResolverFactory;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.resource.GenericMethodResource;

public final class DefaultMethodInvoker
implements MethodInvoker {
    private static final Log LOG = ExoLogger.getLogger(DefaultMethodInvoker.class.getName());

    public Object invokeMethod(Object resource, GenericMethodResource genericMethodResource, ApplicationContext context) {
        for (MethodInvokerFilter f : context.getRequestHandler().getInvokerFilters()) {
            f.accept(genericMethodResource);
        }
        Object[] p = new Object[genericMethodResource.getMethodParameters().size()];
        int i = 0;
        for (MethodParameter mp : genericMethodResource.getMethodParameters()) {
            Annotation a = mp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i++] = pr.resolve(mp, context);
                    continue;
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    throw DefaultMethodInvoker.createException(mp);
                }
            }
            InputStream entityStream = context.getContainerRequest().getEntityStream();
            if (entityStream == null) {
                p[i++] = null;
                continue;
            }
            MediaType contentType = context.getContainerRequest().getMediaType();
            MultivaluedMap<String, String> headers = context.getContainerRequest().getRequestHeaders();
            MessageBodyReader<?> entityReader = context.getRequestHandler().getMessageBodyReader(mp.getParameterClass(), mp.getParameterType(), mp.getAnnotations(), contentType);
            if (entityReader == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unsupported media type. ");
                }
                throw new WebApplicationException(Response.status(Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
            }
            try {
                p[i++] = entityReader.readFrom(mp.getParameterClass(), mp.getParameterType(), mp.getAnnotations(), contentType, headers, entityStream);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new WebApplicationException(e);
            }
        }
        try {
            return genericMethodResource.getMethod().invoke(resource, p);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new WebApplicationException(e);
        }
        catch (Throwable thr) {
            if (LOG.isDebugEnabled()) {
                thr.printStackTrace();
            }
            throw new WebApplicationException(thr);
        }
    }

    private static WebApplicationException createException(MethodParameter mp) {
        Class<? extends Annotation> a = mp.getAnnotation().annotationType();
        if (a == MatrixParam.class || a == QueryParam.class || a == PathParam.class) {
            return new WebApplicationException(Response.status(Response.Status.NOT_FOUND).build());
        }
        return new WebApplicationException(Response.status(Response.Status.BAD_REQUEST).build());
    }
}

