/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.impl.method.MethodParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.method.TypeProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormParameterResolver
extends ParameterResolver<FormParam> {
    private static final Type FORM_TYPE = (ParameterizedType)MultivaluedMapImpl.class.getGenericInterfaces()[0];
    private final FormParam formParam;

    FormParameterResolver(FormParam formParam) {
        this.formParam = formParam;
    }

    @Override
    public Object resolve(MethodParameter parameter, ApplicationContext context) throws Exception {
        String param = this.formParam.value();
        TypeProducer typeProducer = MethodParameterHelper.createTypeProducer(parameter.getParameterClass(), parameter.getParameterType());
        MediaType conetentType = context.getHttpHeaders().getMediaType();
        MessageBodyReader<?> reader = context.getRequestHandler().getMessageBodyReader(MultivaluedMap.class, FORM_TYPE, null, conetentType);
        if (reader == null) {
            throw new IllegalStateException("Can't find appropriate entity reader for entity type " + MultivaluedMap.class.getName() + " and content-type " + conetentType);
        }
        MultivaluedMap form = reader.readFrom(MultivaluedMap.class, FORM_TYPE, null, conetentType, context.getHttpHeaders().getRequestHeaders(), context.getContainerRequest().getEntityStream());
        return typeProducer.createValue(param, form, parameter.getDefaultValue());
    }
}

