/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.exoplatform.services.rest.impl.AnnotationUtils;
import org.exoplatform.services.rest.impl.method.CollectionStringConstructorProducer;
import org.exoplatform.services.rest.impl.method.CollectionStringProducer;
import org.exoplatform.services.rest.impl.method.CollectionStringValueOfProducer;
import org.exoplatform.services.rest.impl.method.PrimitiveTypeProducer;
import org.exoplatform.services.rest.impl.method.StringConstructorProducer;
import org.exoplatform.services.rest.impl.method.StringProducer;
import org.exoplatform.services.rest.impl.method.StringValueOfProducer;
import org.exoplatform.services.rest.method.TypeProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodParameterHelper {
    public static final Map<String, AnnotationUtils.PARAMETER_ANNOTATIONS> PARAMETER_ANNOTATIONS_MAP;

    static TypeProducer createTypeProducer(Class<?> parameterClass, Type parameterType) {
        if (parameterClass == List.class || parameterClass == Set.class || parameterClass == SortedSet.class) {
            Class<?> clazz = MethodParameterHelper.getGenericType(parameterType);
            Method methodValueOf = null;
            Constructor<?> constructor = null;
            if (clazz == String.class || clazz == null) {
                return new CollectionStringProducer(parameterClass);
            }
            methodValueOf = MethodParameterHelper.getStringValueOfMethod(clazz);
            if (methodValueOf != null) {
                return new CollectionStringValueOfProducer(parameterClass, methodValueOf);
            }
            constructor = MethodParameterHelper.getStringConstructor(clazz);
            if (constructor != null) {
                return new CollectionStringConstructorProducer(parameterClass, constructor);
            }
        } else {
            Method methodValueOf = null;
            Constructor<?> constructor = null;
            if (parameterClass.isPrimitive()) {
                return new PrimitiveTypeProducer(parameterClass);
            }
            if (parameterClass == String.class) {
                return new StringProducer();
            }
            methodValueOf = MethodParameterHelper.getStringValueOfMethod(parameterClass);
            if (methodValueOf != null) {
                return new StringValueOfProducer(methodValueOf);
            }
            constructor = MethodParameterHelper.getStringConstructor(parameterClass);
            if (constructor != null) {
                return new StringConstructorProducer(constructor);
            }
        }
        return null;
    }

    boolean isValidAnnotatedParameter(Class<?> parameterClass, Type parameterType, AnnotationUtils.PARAMETER_ANNOTATIONS parameterAnnotation) {
        if (parameterClass == List.class || parameterClass == Set.class || parameterClass == SortedSet.class) {
            if (parameterAnnotation == AnnotationUtils.PARAMETER_ANNOTATIONS.PATH_PARAM) {
                return false;
            }
            Class<?> clazz = MethodParameterHelper.getGenericType(parameterType);
            if (clazz == null || clazz == String.class || MethodParameterHelper.getStringValueOfMethod(clazz) != null || MethodParameterHelper.getStringConstructor(clazz) != null) {
                return true;
            }
            if (parameterClass.isPrimitive() && PrimitiveTypeProducer.PRIMITIVE_TYPES_MAP.get(parameterClass) != null) {
                return true;
            }
            if (parameterClass == String.class || MethodParameterHelper.getStringValueOfMethod(parameterClass) != null || MethodParameterHelper.getStringConstructor(parameterClass) != null) {
                return true;
            }
        }
        return false;
    }

    static Method getStringValueOfMethod(Class<?> clazz) {
        try {
            Method method = clazz.getDeclaredMethod("valueOf", String.class);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static Constructor<?> getStringConstructor(Class<?> clazz) {
        try {
            return clazz.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Class<?> getGenericType(Type type) {
        ParameterizedType parameterizedType;
        Type[] genericTypes;
        if (type instanceof ParameterizedType && (genericTypes = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            try {
                return (Class)genericTypes[0];
            }
            catch (ClassCastException e) {
                throw new RuntimeException("Unsupported type");
            }
        }
        return null;
    }

    static {
        HashMap<String, AnnotationUtils.PARAMETER_ANNOTATIONS> m = new HashMap<String, AnnotationUtils.PARAMETER_ANNOTATIONS>(7);
        m.put(CookieParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.COOKIE_PARAM);
        m.put(Context.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.CONTEXT);
        m.put(FormParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.FORM_PARAM);
        m.put(HeaderParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.HEADER_PARAM);
        m.put(MatrixParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.MATRIX_PARAM);
        m.put(PathParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.PATH_PARAM);
        m.put(QueryParam.class.getName(), AnnotationUtils.PARAMETER_ANNOTATIONS.QUERY_PARAM);
        PARAMETER_ANNOTATIONS_MAP = Collections.unmodifiableMap(m);
    }
}

