/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.lang.annotation.Annotation;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.exoplatform.services.rest.impl.method.ContextParameterResolver;
import org.exoplatform.services.rest.impl.method.CookieParameterResolver;
import org.exoplatform.services.rest.impl.method.FormParameterResolver;
import org.exoplatform.services.rest.impl.method.HeaderParameterResolver;
import org.exoplatform.services.rest.impl.method.MatrixParameterResolver;
import org.exoplatform.services.rest.impl.method.MethodParameterHelper;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.PathParameterResolver;
import org.exoplatform.services.rest.impl.method.QueryParameterResolver;

public final class ParameterResolverFactory {
    private ParameterResolverFactory() {
    }

    public static ParameterResolver createParameterResolver(Annotation annotation) {
        String className = annotation.annotationType().getName();
        switch (MethodParameterHelper.PARAMETER_ANNOTATIONS_MAP.get(className)) {
            case COOKIE_PARAM: {
                return new CookieParameterResolver((CookieParam)annotation);
            }
            case CONTEXT: {
                return new ContextParameterResolver((Context)annotation);
            }
            case FORM_PARAM: {
                return new FormParameterResolver((FormParam)annotation);
            }
            case HEADER_PARAM: {
                return new HeaderParameterResolver((HeaderParam)annotation);
            }
            case MATRIX_PARAM: {
                return new MatrixParameterResolver((MatrixParam)annotation);
            }
            case PATH_PARAM: {
                return new PathParameterResolver((PathParam)annotation);
            }
            case QUERY_PARAM: {
                return new QueryParameterResolver((QueryParam)annotation);
            }
        }
        return null;
    }
}

