/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.provider.EntityProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityProviderMap
extends TreeMap<MediaType, List<EntityProvider<?>>> {
    private static final long serialVersionUID = 3359642490673587123L;
    private static final Comparator<MediaType> COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            int r = MediaTypeHelper.MEDIA_TYPE_COMPARATOR.compare(o1, o2);
            if (r == 0) {
                r = this.toString0(o1).compareToIgnoreCase(this.toString0(o2));
            }
            return r;
        }

        private String toString0(MediaType mime) {
            return mime.getType() + "/" + mime.getSubtype();
        }
    };

    public EntityProviderMap() {
        super(COMPARATOR);
    }

    public List<EntityProvider<?>> getList(MediaType mediaType) {
        ArrayList l = (ArrayList)this.get(mediaType);
        if (l == null) {
            l = new ArrayList();
            this.put(mediaType, l);
        }
        return l;
    }
}

