/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.provider.EntityProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Consumes(value={"application/xml", "text/xml", "application/xhtml+xml"})
@Produces(value={"application/xml", "text/xml", "application/xhtml+xml", "application/vnd.sun.wadl+xml"})
public class JAXBObjectEntityProvider
implements EntityProvider<Object> {
    private static final Log LOG = ExoLogger.getLogger(JAXBObjectEntityProvider.class.getName());
    private ContextResolver<JAXBContext> jaxbContextResolver;

    public void setContexResolver(ContextResolver<JAXBContext> jaxbContexts) {
        this.jaxbContextResolver = jaxbContexts;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return this.jaxbContextResolver.getContext(type).createUnmarshaller().unmarshal(entityStream);
        }
        catch (UnmarshalException e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
        catch (JAXBException e) {
            throw new IOException("Can't read from input stream " + e);
        }
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            Marshaller m = this.jaxbContextResolver.getContext(type).createMarshaller();
            String charset = mediaType.getParameters().get("charset");
            if (charset != null) {
                m.setProperty("jaxb.encoding", charset);
            }
            m.marshal(t, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException("Can't write to output stream " + e);
        }
    }
}

