/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.DefaultMethodInvoker;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.impl.method.OptionsRequestMethodInvoker;
import org.exoplatform.services.rest.impl.resource.OptionsRequestResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.impl.resource.ResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.ResourceMethodMap;
import org.exoplatform.services.rest.impl.resource.SubResourceLocatorMap;
import org.exoplatform.services.rest.impl.resource.SubResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.SubResourceMethodMap;
import org.exoplatform.services.rest.impl.uri.UriPattern;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClass {
    private static final Log LOG = ExoLogger.getLogger(ResourceClass.class.getName());
    private final AbstractResourceDescriptor resourceDescriptor;
    private final ResourceMethodMap resourceMethodMap;
    private final SubResourceMethodMap subResourceMethodMap;
    private final SubResourceLocatorMap subResourceLocatorMap;
    private final Object resource;

    public ResourceClass(AbstractResourceDescriptor resourceDescriptor, Object resource) {
        this.resource = resource;
        this.resourceDescriptor = resourceDescriptor;
        this.resourceMethodMap = new ResourceMethodMap();
        this.subResourceMethodMap = new SubResourceMethodMap();
        this.subResourceLocatorMap = new SubResourceLocatorMap();
        this.processResourceMethods(this.getResourceMethods());
        this.resolveHeadRequest(this.getResourceMethods());
        this.resolveOptionsRequest(this.getResourceMethods());
        this.getResourceMethods().sort();
        this.processSubResourceMethods(this.getSubResourceMethods());
        this.resolveHeadRequest(this.getSubResourceMethods());
        for (ResourceMethodMap rmm : this.getSubResourceMethods().values()) {
            rmm.sort();
        }
        this.processSubResourceLocators(this.getSubResourceLocators());
    }

    public Object getResource() {
        return this.resource;
    }

    public Class getResourceClass() {
        return this.resourceDescriptor.getResourceClass();
    }

    public PathValue getPathValue() {
        return this.resourceDescriptor.getPath();
    }

    public UriPattern getUriPattern() {
        return this.resourceDescriptor.getUriPattern();
    }

    public ResourceMethodMap getResourceMethods() {
        return this.resourceMethodMap;
    }

    public SubResourceMethodMap getSubResourceMethods() {
        return this.subResourceMethodMap;
    }

    public SubResourceLocatorMap getSubResourceLocators() {
        return this.subResourceLocatorMap;
    }

    private void resolveHeadRequest(ResourceMethodMap resourceMethodMap) {
        List g = (List)resourceMethodMap.get("GET");
        if (g == null || g.size() == 0) {
            return;
        }
        List<ResourceMethodDescriptor> h = resourceMethodMap.getList("HEAD");
        for (ResourceMethodDescriptor rmd : g) {
            if (ResourceClass.containsMediaType(h, rmd)) continue;
            h.add(new ResourceMethodDescriptorImpl(rmd.getMethod(), "HEAD", rmd.getMethodParameters(), rmd.getParentResource(), rmd.consumes(), rmd.produces(), rmd.getMethodInvoker()));
        }
    }

    private void resolveOptionsRequest(ResourceMethodMap resourceMethodMap) {
        List<ResourceMethodDescriptor> o = resourceMethodMap.getList("OPTIONS");
        if (o.size() == 0) {
            List<MethodParameter> mps = Collections.emptyList();
            List<MediaType> consumes = MediaTypeHelper.DEFAULT_TYPE_LIST;
            ArrayList<MediaType> produces = new ArrayList<MediaType>(1);
            produces.add(MediaTypeHelper.WADL_TYPE);
            o.add(new OptionsRequestResourceMethodDescriptorImpl(null, "OPTIONS", mps, this.resourceDescriptor, consumes, produces, new OptionsRequestMethodInvoker()));
        }
    }

    private void resolveHeadRequest(SubResourceMethodMap subResourceMethodMap) {
        for (ResourceMethodMap rmm : subResourceMethodMap.values()) {
            List g = (List)rmm.get("GET");
            if (g == null || g.size() == 0) continue;
            List<ResourceMethodDescriptor> h = rmm.getList("HEAD");
            for (SubResourceMethodDescriptor srmd : g) {
                if (ResourceClass.containsMediaType(h, srmd)) continue;
                h.add(new SubResourceMethodDescriptorImpl(srmd.getPathValue(), srmd.getMethod(), "HEAD", srmd.getMethodParameters(), srmd.getParentResource(), srmd.consumes(), srmd.produces(), new DefaultMethodInvoker()));
            }
        }
    }

    private void processResourceMethods(ResourceMethodMap rmm) {
        for (ResourceMethodDescriptor rmd : this.resourceDescriptor.getResourceMethodDescriptors()) {
            ResourceClass.addResourceMethod(rmm, rmd);
        }
    }

    private void processSubResourceMethods(SubResourceMethodMap srmm) {
        for (SubResourceMethodDescriptor srmd : this.resourceDescriptor.getSubResourceMethodDescriptors()) {
            ResourceMethodMap rmm = srmm.getMethodMap(srmd.getUriPattern());
            ResourceClass.addResourceMethod(rmm, srmd);
        }
    }

    private void processSubResourceLocators(SubResourceLocatorMap srlm) {
        for (SubResourceLocatorDescriptor srld : this.resourceDescriptor.getSubResourceLocatorDescriptors()) {
            if (!srlm.containsKey(srld.getUriPattern())) {
                srlm.put(srld.getUriPattern(), srld);
                continue;
            }
            LOG.warn("Sub-resource locator " + srld.getParentResource().getResourceClass() + "#" + srld.getMethod().getName() + " ignored because resource method with the" + " same consumes and produces type already exists");
        }
    }

    private static void addResourceMethod(ResourceMethodMap rmm, ResourceMethodDescriptor rmd) {
        List<ResourceMethodDescriptor> r = rmm.getList(rmd.getHttpMethod());
        if (!ResourceClass.containsMediaType(r, rmd)) {
            r.add(rmd);
        } else {
            LOG.warn("(Sub)resource method " + rmd.getParentResource().getResourceClass() + "#" + rmd.getMethod().getName() + " ignored because resource method with the" + " same consumes and produces type already exists");
        }
    }

    private static boolean containsMediaType(List<ResourceMethodDescriptor> rmds, ResourceMethodDescriptor other) {
        for (ResourceMethodDescriptor rmd : rmds) {
            if (!((Object)rmd.consumes()).equals(other.consumes()) || !((Object)rmd.produces()).equals(other.produces())) continue;
            return true;
        }
        return false;
    }
}

