/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceMethodMap
extends HashMap<String, List<ResourceMethodDescriptor>> {
    private static final long serialVersionUID = -3905800364325544789L;
    private static final Comparator<ResourceMethodDescriptor> COMPARATOR = new Comparator<ResourceMethodDescriptor>(){

        @Override
        public int compare(ResourceMethodDescriptor o1, ResourceMethodDescriptor o2) {
            int r = MediaTypeHelper.MEDIA_TYPE_COMPARATOR.compare(this.getLast(o1.consumes()), this.getLast(o2.consumes()));
            if (r == 0) {
                r = MediaTypeHelper.MEDIA_TYPE_COMPARATOR.compare(this.getLast(o1.produces()), this.getLast(o2.produces()));
            }
            return r;
        }

        private MediaType getLast(List<MediaType> l) {
            return l.get(l.size() - 1);
        }
    };

    public List<ResourceMethodDescriptor> getList(String httpMethod) {
        ArrayList l = (ArrayList)this.get(httpMethod);
        if (l == null) {
            l = new ArrayList();
            this.put(httpMethod, l);
        }
        return l;
    }

    public void sort() {
        for (List l : this.values()) {
            Collections.sort(l, COMPARATOR);
        }
    }

    public Collection<String> getAllow() {
        return this.keySet();
    }
}

