/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.wadl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.impl.resource.ResourceDescriptorFactory;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;
import org.exoplatform.services.rest.resource.ResourceMethodDescriptor;
import org.exoplatform.services.rest.resource.SubResourceLocatorDescriptor;
import org.exoplatform.services.rest.resource.SubResourceMethodDescriptor;
import org.exoplatform.services.rest.wadl.BaseWadlGeneratorImpl;
import org.exoplatform.services.rest.wadl.WadlGenerator;
import org.exoplatform.services.rest.wadl.research.Application;
import org.exoplatform.services.rest.wadl.research.Method;
import org.exoplatform.services.rest.wadl.research.Param;
import org.exoplatform.services.rest.wadl.research.ParamStyle;
import org.exoplatform.services.rest.wadl.research.RepresentationType;
import org.exoplatform.services.rest.wadl.research.Request;
import org.exoplatform.services.rest.wadl.research.Resource;
import org.exoplatform.services.rest.wadl.research.Resources;
import org.exoplatform.services.rest.wadl.research.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WadlProcessor {
    private final WadlGenerator wadlGenerator;

    public WadlProcessor() {
        this.wadlGenerator = new BaseWadlGeneratorImpl();
    }

    public WadlProcessor(WadlGenerator wadlGenerator) {
        this.wadlGenerator = wadlGenerator;
    }

    public Application process(AbstractResourceDescriptor resourceDescriptor, URI baseURI) {
        Application wadlApp = this.wadlGenerator.createApplication();
        Resources wadlResources = this.wadlGenerator.createResources();
        if (baseURI != null) {
            wadlResources.setBase(baseURI.toString());
        }
        Resource wadlResource = this.processResource(resourceDescriptor);
        wadlResources.getResource().add(wadlResource);
        wadlApp.setResources(wadlResources);
        return wadlApp;
    }

    private Resource processResource(AbstractResourceDescriptor resourceDescriptor) {
        Resource wadlResource = this.wadlGenerator.createResource(resourceDescriptor);
        HashMap<String, Param> wadlResourceParams = new HashMap<String, Param>();
        for (ResourceMethodDescriptor rmd : resourceDescriptor.getResourceMethodDescriptors()) {
            Method wadlMethod = this.processMethod(rmd, wadlResourceParams);
            wadlResource.getMethodOrResource().add(wadlMethod);
        }
        for (Param p : wadlResourceParams.values()) {
            wadlResource.getParam().add(p);
        }
        this.processSubResourceMethods(wadlResource, resourceDescriptor);
        this.processSubResourceLocators(wadlResource, resourceDescriptor);
        return wadlResource;
    }

    private void processSubResourceMethods(Resource wadlResource, AbstractResourceDescriptor resourceDescriptor) {
        Resource wadlSubResource;
        String path;
        HashMap<String, HashMap<String, Param>> wadlCommonSubResourceParams = new HashMap<String, HashMap<String, Param>>();
        HashMap<String, Resource> wadlSubResources = new HashMap<String, Resource>();
        for (SubResourceMethodDescriptor subResourceMethodDescriptor : resourceDescriptor.getSubResourceMethodDescriptors()) {
            HashMap<String, Param> wadlResourceParams;
            path = subResourceMethodDescriptor.getPathValue().getPath();
            wadlSubResource = (Resource)wadlSubResources.get(path);
            if (wadlSubResource == null) {
                wadlSubResource = this.wadlGenerator.createResource(path);
                wadlResourceParams = new HashMap<String, Param>();
                wadlSubResource.getMethodOrResource().add(this.processMethod(subResourceMethodDescriptor, wadlResourceParams));
                wadlSubResources.put(path, wadlSubResource);
                wadlCommonSubResourceParams.put(path, wadlResourceParams);
                continue;
            }
            wadlResourceParams = (HashMap<String, Param>)wadlCommonSubResourceParams.get(path);
            wadlSubResource.getMethodOrResource().add(this.processMethod(subResourceMethodDescriptor, wadlResourceParams));
        }
        for (Map.Entry entry : wadlSubResources.entrySet()) {
            path = (String)entry.getKey();
            wadlSubResource = (Resource)entry.getValue();
            for (Param wadlSubParam : ((Map)wadlCommonSubResourceParams.get(path)).values()) {
                wadlSubResource.getParam().add(wadlSubParam);
            }
            wadlResource.getMethodOrResource().add(wadlSubResource);
        }
    }

    private void processSubResourceLocators(Resource wadlResource, AbstractResourceDescriptor resourceDescriptor) {
        for (SubResourceLocatorDescriptor srld : resourceDescriptor.getSubResourceLocatorDescriptors()) {
            AbstractResourceDescriptor subResourceDescriptor = ResourceDescriptorFactory.createAbstractResourceDescriptor(srld.getMethod().getReturnType());
            Resource wadlSubResource = this.processResource(subResourceDescriptor);
            wadlSubResource.setPath(srld.getPathValue().getPath());
            wadlResource.getMethodOrResource().add(wadlSubResource);
        }
    }

    private Method processMethod(ResourceMethodDescriptor rmd, Map<String, Param> wadlResourceParams) {
        Response wadlResponse;
        Method wadlMethod = this.wadlGenerator.createMethod(rmd);
        Request wadlRequest = this.processRequest(rmd, wadlResourceParams);
        if (wadlRequest != null) {
            wadlMethod.setRequest(wadlRequest);
        }
        if ((wadlResponse = this.processResponse(rmd)) != null) {
            wadlMethod.setResponse(wadlResponse);
        }
        return wadlMethod;
    }

    private Request processRequest(ResourceMethodDescriptor rmd, Map<String, Param> wadlResourceParams) {
        Request wadlRequest = this.wadlGenerator.createRequest();
        for (MethodParameter methodParameter : rmd.getMethodParameters()) {
            Param wadlParam;
            if (methodParameter.getAnnotation() == null) {
                for (MediaType mediaType : rmd.consumes()) {
                    RepresentationType wadlRepresentation = this.wadlGenerator.createRequestRepresentation(mediaType);
                    wadlRequest.getRepresentation().add(wadlRepresentation);
                }
            }
            if ((wadlParam = this.processParam(methodParameter)) == null) continue;
            if (wadlParam.getStyle() == ParamStyle.QUERY || wadlParam.getStyle() == ParamStyle.HEADER) {
                wadlRequest.getParam().add(wadlParam);
                continue;
            }
            wadlResourceParams.put(wadlParam.getName(), wadlParam);
        }
        return wadlRequest.getRepresentation().isEmpty() && wadlRequest.getParam().isEmpty() ? null : wadlRequest;
    }

    private Response processResponse(ResourceMethodDescriptor rmd) {
        Response wadlResponse = null;
        if (rmd.getMethod().getReturnType() != Void.TYPE) {
            wadlResponse = this.wadlGenerator.createResponse();
            for (MediaType mediaType : rmd.produces()) {
                RepresentationType wadlRepresentation = this.wadlGenerator.createResponseRepresentation(mediaType);
                JAXBElement<RepresentationType> wadlRepresentationElement = new JAXBElement<RepresentationType>(new QName("http://research.sun.com/wadl/2006/10", "representation"), RepresentationType.class, wadlRepresentation);
                wadlResponse.getRepresentationOrFault().add(wadlRepresentationElement);
            }
        }
        return wadlResponse;
    }

    private Param processParam(MethodParameter methodParameter) {
        Param wadlParam = null;
        if (methodParameter.getAnnotation() != null && methodParameter.getAnnotation().annotationType() != Context.class) {
            wadlParam = this.wadlGenerator.createParam(methodParameter);
        }
        return wadlParam;
    }
}

