/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptInstantiator {
    private ExoContainer container;
    private static final ConstructorsComparator COMPARATOR = new ConstructorsComparator();

    public GroovyScriptInstantiator(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
    }

    public Object instantiateScript(String spec) throws MalformedURLException, IOException {
        return this.instantiateScript(new URL(spec));
    }

    public Object instantiateScript(URL url) throws IOException {
        try {
            return this.instantiateScript(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            throw new IOException("can't load Groovy script from " + url.toString());
        }
    }

    public Object instantiateScript(InputStream stream) throws IOException {
        try {
            Class clazz = new GroovyClassLoader().parseClass(stream);
            Object object = this.createObject(clazz);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("error parsing stream, not groovy script or contains error");
        }
        finally {
            stream.close();
        }
    }

    private Object createObject(Class<?> clazz) throws Exception {
        Constructor<?>[] constructors = clazz.getConstructors();
        Arrays.sort(constructors, COMPARATOR);
        block0: for (Constructor<?> c : constructors) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length == 0) {
                return c.newInstance(new Object[0]);
            }
            ArrayList<Object> parameters = new ArrayList<Object>(parameterTypes.length);
            for (Class<?> parameterType : parameterTypes) {
                Object param = this.container.getComponentInstanceOfType(parameterType);
                if (param == null) continue block0;
                parameters.add(param);
            }
            return c.newInstance(parameters.toArray(new Object[parameters.size()]));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorsComparator
    implements Comparator<Constructor<?>> {
        private ConstructorsComparator() {
        }

        @Override
        public int compare(Constructor<?> constructor1, Constructor<?> constructor2) {
            int c2;
            int c1 = constructor1.getParameterTypes().length;
            if (c1 < (c2 = constructor2.getParameterTypes().length)) {
                return 1;
            }
            if (c1 > c2) {
                return -1;
            }
            return 0;
        }
    }
}

