/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class ConversationStateListener
implements HttpSessionListener {
    protected Log log = ExoLogger.getLogger("core.security.ConversationStateListener");

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
        ConversationRegistry conversationRegistry = (ConversationRegistry)this.getContainer(httpSession.getServletContext()).getComponentInstanceOfType(ConversationRegistry.class);
        ConversationState conversationState = conversationRegistry.unregister(stateKey);
        if (conversationState != null && this.log.isDebugEnabled()) {
            this.log.debug("Remove conversation state " + httpSession.getId());
        }
    }

    protected ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer("portal");
        }
        return container;
    }

    protected ExoContainer getContainer(ServletContext sctx) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            String containerName = null;
            if (sctx.getAttribute("portalContainerName") != null) {
                containerName = (String)sctx.getAttribute("portalContainerName");
            }
            if (containerName == null) {
                containerName = "portal";
            }
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return container;
    }
}

