/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class SetCurrentIdentityFilter
implements Filter {
    public static final String PORTAL_CONTAINER_NAME = "portalContainerName";
    private static Log log = ExoLogger.getLogger("core.security.SetCurrentIdentityFilter");
    private String portalContainerName;

    public void init(FilterConfig config) throws ServletException {
        this.portalContainerName = config.getInitParameter(PORTAL_CONTAINER_NAME);
        if (this.portalContainerName == null) {
            this.portalContainerName = config.getServletContext().getInitParameter(PORTAL_CONTAINER_NAME);
        }
        if (this.portalContainerName == null) {
            this.portalContainerName = config.getServletContext().getServletContextName();
        }
        config.getServletContext().setAttribute(PORTAL_CONTAINER_NAME, (Object)this.portalContainerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = ExoContainerContext.getContainerByName(this.portalContainerName);
        if (container == null) {
            if (log.isDebugEnabled()) {
                log.debug("Container " + this.portalContainerName + " not found.");
            }
            container = ExoContainerContext.getTopContainer();
        }
        try {
            ExoContainerContext.setCurrentContainer(container);
            ConversationState state = this.getCurrentState(container, httpRequest);
            ConversationState.setCurrent(state);
            chain.doFilter(request, response);
        }
        finally {
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                log.warn("An error occured while cleaning the ThreadLocal", e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                log.warn("An error occured while cleaning the ThreadLocal", e);
            }
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSession httpSession = httpRequest.getSession();
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
            if (log.isDebugEnabled()) {
                log.debug("Looking for Conversation State " + httpSession.getId());
            }
            if ((state = conversationRegistry.getState(stateKey)) == null) {
                Identity identity;
                if (log.isDebugEnabled()) {
                    log.debug("Conversation State not found, try create new one.");
                }
                if ((identity = identityRegistry.getIdentity(userId)) != null) {
                    state = new ConversationState(identity);
                    state.setAttribute("subject", identity.getSubject());
                } else {
                    log.error("Not found identity in IdentityRegistry for user " + userId + ", check Login Module.");
                }
                if (state != null) {
                    conversationRegistry.register(stateKey, state);
                    if (log.isDebugEnabled()) {
                        log.debug("Register Conversation state " + httpSession.getId());
                    }
                }
            }
        }
        return state;
    }

    public void destroy() {
    }
}

