/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private static final Log log = LogFactory.getLog(TableGenerator.class);
    private String tableName;
    private String columnName;
    private String query;
    private String update;

    public void configure(Type type, Properties params, Dialect dialect) {
        this.tableName = PropertiesHelper.getString(TABLE, params, DEFAULT_TABLE_NAME);
        this.columnName = PropertiesHelper.getString(COLUMN, params, DEFAULT_COLUMN_NAME);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        if (this.tableName.indexOf(46) < 0) {
            this.tableName = Table.qualify(catalogName, schemaName, this.tableName);
        }
        this.query = "select " + this.columnName + " from " + dialect.appendLockHint(LockMode.UPGRADE, this.tableName) + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        int result = (Integer)this.doWorkInNewTransaction(session);
        return new Integer(result);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int result;
        int rows;
        do {
            sql = this.query;
            SQL.debug(this.query);
            PreparedStatement qps = conn.prepareStatement(this.query);
            try {
                ResultSet rs = qps.executeQuery();
                if (!rs.next()) {
                    String err = "could not read a hi value - you need to populate the table: " + this.tableName;
                    log.error(err);
                    throw new IdentifierGenerationException(err);
                }
                result = rs.getInt(1);
                rs.close();
            }
            catch (SQLException sqle) {
                log.error("could not read a hi value", sqle);
                throw sqle;
            }
            finally {
                qps.close();
            }
            sql = this.update;
            SQL.debug(this.update);
            PreparedStatement ups = conn.prepareStatement(this.update);
            try {
                ups.setInt(1, result + 1);
                ups.setInt(2, result);
                rows = ups.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error("could not update hi value in: " + this.tableName, sqle);
                throw sqle;
            }
            finally {
                ups.close();
            }
        } while (rows == 0);
        return new Integer(result);
    }
}

