/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final Log log = LogFactory.getLog(NamedQueryLoader.class);

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) throws HibernateException {
        AbstractQueryImpl query;
        if (log.isDebugEnabled()) {
            log.debug("loading entity: " + this.persister.getEntityName() + " using named query: " + this.queryName);
        }
        if ((query = (AbstractQueryImpl)session.getNamedQuery(this.queryName)).hasNamedParameters()) {
            query.setParameter(query.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query.setParameter(0, (Object)id, this.persister.getIdentifierType());
        }
        query.setOptionalId(id);
        query.setOptionalEntityName(this.persister.getEntityName());
        query.setOptionalObject(optionalObject);
        query.setFlushMode(FlushMode.NEVER);
        query.list();
        return session.getPersistenceContext().getEntity(new EntityKey(id, this.persister, session.getEntityMode()));
    }
}

