/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyAccessException;
import org.hibernate.cfg.Environment;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.CGLIBProxyFactory;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.AbstractEntityTuplizer;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.PojoInstantiator;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

public class PojoEntityTuplizer
extends AbstractEntityTuplizer {
    static final Log log = LogFactory.getLog(PojoEntityTuplizer.class);
    private final Class mappedClass;
    private final Class proxyInterface;
    private final boolean lifecycleImplementor;
    private final boolean validatableImplementor;
    private final Set lazyPropertyNames = new HashSet();
    private BulkBean optimizer;
    private FastClass fastClass;

    public PojoEntityTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappedEntity) {
        super(entityMetamodel, mappedEntity);
        this.mappedClass = mappedEntity.getMappedClass();
        this.proxyInterface = mappedEntity.getProxyInterface();
        this.lifecycleImplementor = Lifecycle.class.isAssignableFrom(this.mappedClass);
        this.validatableImplementor = Validatable.class.isAssignableFrom(this.mappedClass);
        Iterator iter = mappedEntity.getPropertyClosureIterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.isLazy()) continue;
            this.lazyPropertyNames.add(property.getName());
        }
        String[] getterNames = new String[this.propertySpan];
        String[] setterNames = new String[this.propertySpan];
        Class[] propTypes = new Class[this.propertySpan];
        for (int i = 0; i < this.propertySpan; ++i) {
            getterNames[i] = this.getters[i].getMethodName();
            setterNames[i] = this.setters[i].getMethodName();
            propTypes[i] = this.getters[i].getReturnType();
        }
        if (this.hasCustomAccessors || !Environment.useReflectionOptimizer()) {
            this.fastClass = null;
            this.optimizer = null;
        } else {
            this.fastClass = ReflectHelper.getFastClass(this.mappedClass);
            this.optimizer = ReflectHelper.getBulkBean(this.mappedClass, getterNames, setterNames, propTypes, this.fastClass);
            if (this.optimizer == null) {
                this.fastClass = null;
            }
        }
    }

    protected ProxyFactory buildProxyFactory(PersistentClass persistentClass, Getter idGetter, Setter idSetter) {
        HashSet<Class> proxyInterfaces = new HashSet<Class>();
        proxyInterfaces.add(HibernateProxy.class);
        Class mappedClass = persistentClass.getMappedClass();
        Class proxyInterface = persistentClass.getProxyInterface();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + this.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        Iterator iter = persistentClass.getSubclassIterator();
        while (iter.hasNext()) {
            Subclass subclass = (Subclass)iter.next();
            Class subclassProxy = subclass.getProxyInterface();
            Class subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        Iterator properties = persistentClass.getPropertyIterator();
        Class clazz = persistentClass.getMappedClass();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            Method method = property.getGetter(clazz).getMethod();
            if (method != null && Modifier.isFinal(method.getModifiers())) {
                log.error("Getters of lazy classes cannot be final: " + persistentClass.getEntityName() + "." + property.getName());
            }
            if ((method = property.getSetter(clazz).getMethod()) == null || !Modifier.isFinal(method.getModifiers())) continue;
            log.error("Setters of lazy classes cannot be final: " + persistentClass.getEntityName() + "." + property.getName());
        }
        Method idGetterMethod = idGetter == null ? null : idGetter.getMethod();
        Method idSetterMethod = idSetter == null ? null : idSetter.getMethod();
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        CGLIBProxyFactory pf = new CGLIBProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, persistentClass.hasEmbeddedIdentifier() ? (AbstractComponentType)persistentClass.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            log.warn("could not create proxy factory for:" + this.getEntityName(), he);
            pf = null;
        }
        return pf;
    }

    protected Instantiator buildInstantiator(PersistentClass persistentClass) {
        return new PojoInstantiator(persistentClass, this.fastClass);
    }

    public void setPropertyValues(Object entity, Object[] values) throws HibernateException {
        if (!this.getEntityMetamodel().hasLazyProperties() && this.optimizer != null) {
            this.setPropertyValuesWithOptimizer(entity, values);
        } else {
            super.setPropertyValues(entity, values);
        }
    }

    public Object[] getPropertyValues(Object entity) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValues(entity);
    }

    public Object[] getPropertyValuesToInsert(Object entity, Map mergeMap, SessionImplementor session) throws HibernateException {
        if (this.shouldGetAllProperties(entity) && this.optimizer != null) {
            return this.getPropertyValuesWithOptimizer(entity);
        }
        return super.getPropertyValuesToInsert(entity, mergeMap, session);
    }

    protected void setPropertyValuesWithOptimizer(Object object, Object[] values) {
        try {
            this.optimizer.setPropertyValues(object, values);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception setting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", true, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    protected Object[] getPropertyValuesWithOptimizer(Object object) {
        try {
            return this.optimizer.getPropertyValues(object);
        }
        catch (Throwable t) {
            throw new PropertyAccessException(t, "exception getting property value with CGLIB (set hibernate.cglib.use_reflection_optimizer=false for more info)", false, this.mappedClass, ReflectHelper.getPropertyName(t, this.optimizer));
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.POJO;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public boolean isLifecycleImplementor() {
        return this.lifecycleImplementor;
    }

    public boolean isValidatableImplementor() {
        return this.validatableImplementor;
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getGetter(mappedEntity.getMappedClass());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        return mappedProperty.getSetter(mappedEntity.getMappedClass());
    }

    public Class getConcreteProxyClass() {
        return this.proxyInterface;
    }

    public void afterInitialize(Object entity, boolean lazyPropertiesAreUnfetched, SessionImplementor session) {
        if (this.isInstrumented()) {
            Set lazyProps = lazyPropertiesAreUnfetched && this.getEntityMetamodel().hasLazyProperties() ? this.lazyPropertyNames : null;
            FieldInterceptor.initFieldInterceptor(entity, this.getEntityName(), session, lazyProps);
        }
    }

    public boolean hasUninitializedLazyProperties(Object entity) {
        if (this.getEntityMetamodel().hasLazyProperties()) {
            FieldInterceptor callback = FieldInterceptor.getFieldInterceptor(entity);
            return callback != null && !callback.isInitialized();
        }
        return false;
    }

    public boolean isInstrumented() {
        return InterceptFieldEnabled.class.isAssignableFrom(this.getMappedClass());
    }
}

