/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.EqualsHelper;
import org.hibernate.util.StringHelper;

public abstract class NullableType
extends AbstractType {
    private static final boolean IS_TRACE_ENABLED = LogFactory.getLog(StringHelper.qualifier(Type.class.getName())).isTraceEnabled();

    public abstract Object get(ResultSet var1, String var2) throws HibernateException, SQLException;

    public abstract void set(PreparedStatement var1, Object var2, int var3) throws HibernateException, SQLException;

    public abstract int sqlType();

    public abstract String toString(Object var1) throws HibernateException;

    public abstract Object fromStringValue(String var1) throws HibernateException;

    public final void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        if (settable[0]) {
            this.nullSafeSet(st, value, index);
        }
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index);
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        try {
            if (value == null) {
                if (IS_TRACE_ENABLED) {
                    LogFactory.getLog(this.getClass()).trace("binding null to parameter: " + index);
                }
                st.setNull(index, this.sqlType());
            } else {
                if (IS_TRACE_ENABLED) {
                    LogFactory.getLog(this.getClass()).trace("binding '" + this.toString(value) + "' to parameter: " + index);
                }
                this.set(st, value, index);
            }
        }
        catch (RuntimeException re) {
            LogFactory.getLog(this.getClass()).info("could not bind value '" + this.toString(value) + "' to parameter: " + index);
        }
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0]);
    }

    public final Object nullSafeGet(ResultSet rs, String[] names) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0]);
    }

    public final Object nullSafeGet(ResultSet rs, String name) throws HibernateException, SQLException {
        try {
            Object value = this.get(rs, name);
            if (value == null || rs.wasNull()) {
                if (IS_TRACE_ENABLED) {
                    LogFactory.getLog(this.getClass()).trace("returning null as column: " + name);
                }
                return null;
            }
            if (IS_TRACE_ENABLED) {
                LogFactory.getLog(this.getClass()).trace("returning '" + this.toString(value) + "' as column: " + name);
            }
            return value;
        }
        catch (RuntimeException re) {
            LogFactory.getLog(this.getClass()).info("could not read column value from result set: " + name);
            throw re;
        }
    }

    public final Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, name);
    }

    public final String toXMLString(Object value, SessionFactoryImplementor pc) throws HibernateException {
        return this.toString(value);
    }

    public final Object fromXMLString(String xml, Mapping factory) throws HibernateException {
        return xml == null || xml.length() == 0 ? null : this.fromStringValue(xml);
    }

    public final int getColumnSpan(Mapping session) {
        return 1;
    }

    public final int[] sqlTypes(Mapping session) {
        return new int[]{this.sqlType()};
    }

    public final boolean isEqual(Object x, Object y, EntityMode entityMode) {
        return this.isEqual(x, y);
    }

    public boolean isEqual(Object x, Object y) {
        return EqualsHelper.equals(x, y);
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        return value == null ? "null" : this.toString(value);
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return this.fromXMLString(xml.getText(), factory);
    }

    public void setToXMLNode(Node xml, Object value, SessionFactoryImplementor factory) throws HibernateException {
        xml.setText(this.toXMLString(value, factory));
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }
}

