/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.sax;

import java.io.IOException;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.sax.Attributes;
import org.htmlparser.sax.Feedback;
import org.htmlparser.sax.Locator;
import org.htmlparser.util.DefaultParserFeedback;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.ParserFeedback;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLReader
implements org.xml.sax.XMLReader {
    protected boolean mNameSpaces = true;
    protected boolean mNameSpacePrefixes = false;
    protected EntityResolver mEntityResolver = null;
    protected DTDHandler mDTDHandler = null;
    protected ContentHandler mContentHandler = null;
    protected ErrorHandler mErrorHandler = null;
    protected Parser mParser;
    protected NamespaceSupport mSupport = new NamespaceSupport();
    protected String[] mParts;

    public XMLReader() {
        this.mSupport.pushContext();
        this.mSupport.declarePrefix("", "http://www.w3.org/TR/REC-html40");
        this.mParts = new String[3];
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean ret;
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            ret = this.mNameSpaces;
        } else if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            ret = this.mNameSpacePrefixes;
        } else {
            throw new SAXNotSupportedException(name + " not yet understood");
        }
        return ret;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            this.mNameSpaces = value;
        } else if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.mNameSpacePrefixes = value;
        } else {
            throw new SAXNotSupportedException(name + " not yet understood");
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name + " not yet understood");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException(name + " not yet understood");
    }

    public void setEntityResolver(EntityResolver resolver2) {
        this.mEntityResolver = resolver2;
    }

    public EntityResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.mDTDHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.mDTDHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.mContentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.mContentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.mErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        block7: {
            if (null != this.mContentHandler) {
                try {
                    this.mParser = new Parser(new Lexer(new Page(input.getByteStream(), input.getEncoding())));
                    Locator locator = new Locator(this.mParser);
                    ParserFeedback feedback = null != this.mErrorHandler ? new Feedback(this.mErrorHandler, locator) : new DefaultParserFeedback(0);
                    this.mParser.setFeedback(feedback);
                    this.mContentHandler.setDocumentLocator(locator);
                    try {
                        this.mContentHandler.startDocument();
                        NodeIterator iterator = this.mParser.elements();
                        while (iterator.hasMoreNodes()) {
                            this.doSAX(iterator.nextNode());
                        }
                        this.mContentHandler.endDocument();
                    }
                    catch (SAXException se) {
                        if (null != this.mErrorHandler) {
                            this.mErrorHandler.fatalError(new SAXParseException("contentHandler threw me", locator, se));
                        }
                    }
                }
                catch (ParserException pe) {
                    if (null == this.mErrorHandler) break block7;
                    this.mErrorHandler.fatalError(new SAXParseException(pe.getMessage(), "", "", 0, 0));
                }
            }
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        block7: {
            if (null != this.mContentHandler) {
                try {
                    this.mParser = new Parser(systemId);
                    Locator locator = new Locator(this.mParser);
                    ParserFeedback feedback = null != this.mErrorHandler ? new Feedback(this.mErrorHandler, locator) : new DefaultParserFeedback(0);
                    this.mParser.setFeedback(feedback);
                    this.mContentHandler.setDocumentLocator(locator);
                    try {
                        this.mContentHandler.startDocument();
                        NodeIterator iterator = this.mParser.elements();
                        while (iterator.hasMoreNodes()) {
                            this.doSAX(iterator.nextNode());
                        }
                        this.mContentHandler.endDocument();
                    }
                    catch (SAXException se) {
                        if (null != this.mErrorHandler) {
                            this.mErrorHandler.fatalError(new SAXParseException("contentHandler threw me", locator, se));
                        }
                    }
                }
                catch (ParserException pe) {
                    if (null == this.mErrorHandler) break block7;
                    this.mErrorHandler.fatalError(new SAXParseException(pe.getMessage(), "", systemId, 0, 0));
                }
            }
        }
    }

    protected void doSAX(Node node) throws ParserException, SAXException {
        if (node instanceof Remark) {
            String text = this.mParser.getLexer().getPage().getText(node.getStartPosition(), node.getEndPosition());
            this.mContentHandler.ignorableWhitespace(text.toCharArray(), 0, text.length());
        } else if (node instanceof Text) {
            String text = this.mParser.getLexer().getPage().getText(node.getStartPosition(), node.getEndPosition());
            this.mContentHandler.characters(text.toCharArray(), 0, text.length());
        } else if (node instanceof Tag) {
            Tag end;
            Tag tag = (Tag)node;
            if (this.mNameSpaces) {
                this.mSupport.processName(tag.getTagName(), this.mParts, false);
            } else {
                this.mParts[0] = "";
                this.mParts[1] = "";
            }
            this.mParts[2] = this.mNameSpacePrefixes ? tag.getTagName() : (this.mNameSpaces ? "" : tag.getTagName());
            this.mContentHandler.startElement(this.mParts[0], this.mParts[1], this.mParts[2], new Attributes(tag, this.mSupport, this.mParts));
            NodeList children = tag.getChildren();
            if (null != children) {
                for (int i = 0; i < children.size(); ++i) {
                    this.doSAX(children.elementAt(i));
                }
            }
            if (null != (end = tag.getEndTag())) {
                if (this.mNameSpaces) {
                    this.mSupport.processName(end.getTagName(), this.mParts, false);
                } else {
                    this.mParts[0] = "";
                    this.mParts[1] = "";
                }
                this.mParts[2] = this.mNameSpacePrefixes ? end.getTagName() : (this.mNameSpaces ? "" : end.getTagName());
                this.mContentHandler.endElement(this.mParts[0], this.mParts[1], this.mParts[2]);
            }
        }
    }
}

