/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.carol.cmi.Config;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.Protocol;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;
import org.objectweb.carol.util.configuration.ProtocolConfigurationImpl;
import org.objectweb.carol.util.configuration.ProtocolConfigurationImplMBean;
import org.objectweb.carol.util.configuration.ServerConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.carol.util.mbean.MBeanUtils;

public class ConfigurationRepository {
    private static Log logger = LogFactory.getLog(class$org$objectweb$carol$util$configuration$ConfigurationRepository == null ? (class$org$objectweb$carol$util$configuration$ConfigurationRepository = ConfigurationRepository.class$("org.objectweb.carol.util.configuration.ConfigurationRepository")) : class$org$objectweb$carol$util$configuration$ConfigurationRepository);
    private static Properties defaultProperties = null;
    private static ServerConfiguration serverConfiguration = null;
    private static Map managedProtocols = null;
    private static Map managedConfigurations = null;
    private static InheritableThreadLocal threadLocal = null;
    private static ProtocolConfiguration defaultConfiguration = null;
    private static Properties properties = null;
    private static boolean initDone = false;
    static /* synthetic */ Class class$org$objectweb$carol$util$configuration$ConfigurationRepository;

    private ConfigurationRepository() {
    }

    protected static void checkInitialized() {
        if (!initDone) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Do the configuration as the configuration was not yet done!");
                }
                ConfigurationRepository.init();
            }
            catch (ConfigurationException ce) {
                IllegalStateException ise = new IllegalStateException("Configuration of carol was not done and when trying to initialize it, it fails.");
                ise.initCause(ce);
                throw ise;
            }
        }
    }

    protected static void checkConfigured() {
        ConfigurationRepository.checkInitialized();
        if (managedConfigurations == null) {
            throw new IllegalStateException("Cannot find a configuration, carol was not configured");
        }
    }

    public static ProtocolConfiguration[] getConfigurations() {
        ConfigurationRepository.checkConfigured();
        Set set = managedConfigurations.keySet();
        ProtocolConfiguration[] configs = new ProtocolConfiguration[set.size()];
        int c = 0;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            configs[c] = (ProtocolConfiguration)managedConfigurations.get(key);
            ++c;
        }
        return configs;
    }

    public static ProtocolConfiguration getConfiguration(String configName) {
        ConfigurationRepository.checkConfigured();
        return (ProtocolConfiguration)managedConfigurations.get(configName);
    }

    public static Protocol getProtocol(String protocolName) {
        ConfigurationRepository.checkConfigured();
        return (Protocol)managedProtocols.get(protocolName);
    }

    public static ProtocolConfiguration newConfiguration(String configurationName, String protocolName) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol p = null;
        if (managedConfigurations.get(configurationName) != null) {
            throw new ConfigurationException("There is an existing configuration with the name '" + configurationName + "'. Use another name.");
        }
        if (managedProtocols != null) {
            p = (Protocol)managedProtocols.get(protocolName);
        }
        if (p == null) {
            throw new ConfigurationException("Protocol '" + protocolName + "' doesn't exists in carol. Cannot build");
        }
        return new ProtocolConfigurationImpl(configurationName, p, new Properties());
    }

    public static ProtocolConfiguration setCurrentConfiguration(ProtocolConfiguration config) {
        ConfigurationRepository.checkConfigured();
        ProtocolConfiguration old = ConfigurationRepository.getCurrentConfiguration();
        threadLocal.set(config);
        return old;
    }

    public static ProtocolConfiguration getCurrentConfiguration() {
        ConfigurationRepository.checkConfigured();
        Object o = threadLocal.get();
        if (o != null) {
            return (ProtocolConfiguration)o;
        }
        return defaultConfiguration;
    }

    public static void init(URL carolPropertiesFileURL) throws ConfigurationException {
        ConfigurationRepository.init(carolPropertiesFileURL, null, null);
    }

    public static void init(String idMbeanServer, String serverName) throws ConfigurationException {
        ConfigurationRepository.init(Thread.currentThread().getContextClassLoader().getResource("carol.properties"), idMbeanServer, serverName);
    }

    public static void init(URL carolPropertiesFileURL, String idMbeanServer, String serverName) throws ConfigurationException {
        if (initDone) {
            return;
        }
        Properties carolDefaultProperties = ConfigurationRepository.getDefaultProperties();
        Properties carolProperties = ConfigurationRepository.getPropertiesFromURL(carolPropertiesFileURL);
        properties = ConfigurationRepository.mergeProperties(carolDefaultProperties, carolProperties);
        serverConfiguration = new ServerConfiguration(properties);
        managedProtocols = new HashMap();
        managedConfigurations = new HashMap();
        threadLocal = new InheritableThreadLocal();
        int propertyBeginLength = "carol".length();
        int propertyEndLength = "context.factory".length();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("carol") || !key.endsWith("context.factory")) continue;
            String protocolName = key.substring(propertyBeginLength + 1, key.length() - propertyEndLength - 1);
            if (logger.isDebugEnabled()) {
                logger.debug("Build protocol object for protocol name found '" + protocolName + "'.");
            }
            Protocol protocol = new Protocol(protocolName, properties);
            managedProtocols.put(protocolName, protocol);
            if (!protocolName.equals("cmi")) continue;
            try {
                Config.setProperties((Properties)properties);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cmi is not available, don't configure it.");
            }
            catch (Exception ex) {
                TraceCarol.error("Cannot set the cmi configuration.", ex);
                throw new ConfigurationException("Cannot set the cmi configuration.", ex);
            }
        }
        String protocols = properties.getProperty("carol.protocols");
        String defaultProtocol = properties.getProperty("carol.protocols.default");
        if (defaultProtocol == null) {
            throw new ConfigurationException("No default protocol defined with property 'carol.protocols.default', check your carol configuration.");
        }
        if (protocols == null) {
            logger.info("No protocols were defined for property 'carol.protocols', trying with default protocol = '" + defaultProtocol + "'.");
            protocols = defaultProtocol;
        }
        String[] protocolsArray = protocols.split(",");
        for (int p = 0; p < protocolsArray.length; ++p) {
            String pName = protocolsArray[p];
            Protocol protocol = (Protocol)managedProtocols.get(pName);
            if (protocol == null) {
                throw new ConfigurationException("Cannot find a protocol with name '" + pName + "' in the list of available protocols.");
            }
            ProtocolConfigurationImpl protoConfig = new ProtocolConfigurationImpl(pName, protocol, properties);
            managedConfigurations.put(pName, protoConfig);
        }
        if (protocolsArray[0] != null) {
            defaultConfiguration = (ProtocolConfiguration)managedConfigurations.get(protocolsArray[0]);
        }
        if (idMbeanServer != null && serverName != null) {
            ConfigurationRepository.initMbeans(idMbeanServer, serverName);
        }
        initDone = true;
    }

    public static void addConfiguration(ProtocolConfiguration protocolConfiguration) throws ConfigurationException {
        String protocolConfigName = protocolConfiguration.getName();
        if (managedConfigurations.get(protocolConfigName) != null) {
            throw new ConfigurationException("The configuration named '" + protocolConfigName + "' already exist.");
        }
        managedConfigurations.put(protocolConfigName, protocolConfiguration);
    }

    public static ServerConfiguration getServerConfiguration() {
        ConfigurationRepository.checkConfigured();
        return serverConfiguration;
    }

    protected static Properties mergeProperties(Properties defaultValues, Properties values) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)defaultValues);
        p.putAll((Map<?, ?>)values);
        return p;
    }

    public static void init() throws ConfigurationException {
        ConfigurationRepository.init(Thread.currentThread().getContextClassLoader().getResource("carol.properties"));
    }

    protected static Properties getDefaultProperties() throws ConfigurationException {
        if (defaultProperties == null) {
            URL defaultConfigurationFile = Thread.currentThread().getContextClassLoader().getResource("carol-defaults.properties");
            defaultProperties = ConfigurationRepository.getPropertiesFromURL(defaultConfigurationFile);
        }
        return defaultProperties;
    }

    protected static Properties getPropertiesFromURL(URL url) throws ConfigurationException {
        if (url == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Return empty properties, URL is null");
            }
            return new Properties();
        }
        InputStream is = null;
        try {
            URLConnection urlConnect = null;
            urlConnect = url.openConnection();
            urlConnect.setDefaultUseCaches(false);
            is = urlConnect.getInputStream();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Invalid URL '" + url + "' : " + ioe.getMessage(), ioe);
        }
        if (is == null) {
            throw new ConfigurationException("No inputstream for URL '" + url + "'.");
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Could not load input stream of  URL '" + url + "' : " + ioe.getMessage());
        }
        try {
            is.close();
        }
        catch (IOException ioe) {
            throw new ConfigurationException("Cannot close inputStream", ioe);
        }
        return p;
    }

    public static ProtocolConfiguration getDefaultConfiguration() {
        ConfigurationRepository.checkConfigured();
        return defaultConfiguration;
    }

    public static Properties getProperties() {
        ConfigurationRepository.checkConfigured();
        return properties;
    }

    public static int getActiveConfigurationsNumber() {
        ConfigurationRepository.checkConfigured();
        if (managedConfigurations != null) {
            return managedConfigurations.size();
        }
        return 0;
    }

    public static void addInterceptors(String protocolName, String interceptorInitializer) throws ConfigurationException {
        ConfigurationRepository.checkConfigured();
        Protocol protocol = ConfigurationRepository.getProtocol(protocolName);
        if (protocol == null) {
            throw new ConfigurationException("Cannot add interceptor on an unknown protocol '" + protocolName + "'.");
        }
        protocol.addInterceptor(interceptorInitializer);
    }

    protected static void initMbeans(String idMbeanServer, String serverName) throws ConfigurationException {
        Iterator it = managedConfigurations.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            ProtocolConfiguration protocolConfiguration = (ProtocolConfiguration)managedConfigurations.get(key);
            if (!(protocolConfiguration instanceof ProtocolConfigurationImplMBean)) continue;
            MBeanUtils.registerProtocolConfigurationMBean((ProtocolConfigurationImplMBean)((Object)protocolConfiguration), logger, idMbeanServer, serverName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

