/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.mbean;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.ProtocolConfigurationImplMBean;

public class MBeanUtils {
    private static MBeanServer mbeanServer = null;

    private MBeanUtils() {
    }

    protected static void initMBeanServer(Log logger, String idMbeanServer) throws ConfigurationException {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(idMbeanServer);
        if (mbeanServers.size() == 0) {
            throw new ConfigurationException("No MBean Servers were found with id '" + idMbeanServer + "'");
        }
        if (mbeanServers.size() > 1 && logger.isDebugEnabled()) {
            logger.debug("Take first MBeanServer of the list");
        }
        mbeanServer = (MBeanServer)mbeanServers.get(0);
    }

    public static void registerProtocolConfigurationMBean(ProtocolConfigurationImplMBean protocolConfiguration, Log logger, String idMbeanServer, String serverName) throws ConfigurationException {
        if (mbeanServer == null) {
            MBeanUtils.initMBeanServer(logger, idMbeanServer);
        }
        StringBuffer sb = new StringBuffer(mbeanServer.getDefaultDomain());
        sb.append(":j2eeType=JNDIResource");
        sb.append(",name=");
        sb.append(protocolConfiguration.getName());
        sb.append(",J2EEServer=");
        sb.append(serverName);
        ObjectName on = null;
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new ConfigurationException("Cannot build ObjectName for configuration '" + protocolConfiguration.getName() + "'", e);
        }
        protocolConfiguration.setobjectName(on.toString());
        try {
            mbeanServer.registerMBean(protocolConfiguration, on);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot register MBean '" + on + "' in MBeanServer", e);
        }
    }
}

