/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntClassLoader;
import org.xml.sax.InputSource;
import xdoclet.loader.XDocletModule;
import xdoclet.loader.XDocletXmlParser;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;

public class ModuleFinder {
    private static final FileFilter jarFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    };
    private static String classpath;
    private static List modules;
    static /* synthetic */ Class class$xdoclet$loader$ModuleFinder;
    static /* synthetic */ Class class$xdoclet$loader$LoaderMessages;

    public static String getClasspath() {
        return classpath;
    }

    public static File getNewestFileOnClassPath() {
        List moduleFiles = ModuleFinder.findModuleFiles();
        long newest = Long.MIN_VALUE;
        File newestFile = null;
        Iterator i = moduleFiles.iterator();
        while (i.hasNext()) {
            File moduleFile = (File)i.next();
            if (moduleFile.lastModified() < newest) continue;
            newestFile = moduleFile;
            newest = moduleFile.lastModified();
        }
        return newestFile;
    }

    public static void setClasspath(String classpath) {
        ModuleFinder.classpath = classpath;
    }

    public static void initClasspath(Class clazz) {
        if (System.getProperty("xdoclet.class.path") == null) {
            try {
                classpath = ((AntClassLoader)clazz.getClassLoader()).getClasspath();
            }
            catch (ClassCastException e) {
                classpath = System.getProperty("java.class.path");
            }
        } else {
            classpath = System.getProperty("xdoclet.class.path");
        }
    }

    public static List findModules() {
        if (modules == null) {
            modules = new ArrayList();
            Log log = LogUtil.getLog(class$xdoclet$loader$ModuleFinder == null ? (class$xdoclet$loader$ModuleFinder = ModuleFinder.class$("xdoclet.loader.ModuleFinder")) : class$xdoclet$loader$ModuleFinder, "findModules");
            log.debug(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? (class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("xdoclet.loader.LoaderMessages")) : class$xdoclet$loader$LoaderMessages, "REGISTERING_MODULES"));
            XDocletXmlParser parser = new XDocletXmlParser();
            List moduleFiles = ModuleFinder.findModuleFiles();
            Iterator moduleFileIterator = moduleFiles.iterator();
            while (moduleFileIterator.hasNext()) {
                File file = (File)moduleFileIterator.next();
                if (file.exists()) {
                    try {
                        InputStream xdocletXmlIs = null;
                        URL xtagsURL = null;
                        if (file.isDirectory()) {
                            xdocletXmlIs = new FileInputStream(new File(file, "META-INF" + File.separator + "xdoclet.xml"));
                            xtagsURL = new File(file, "META-INF" + File.separator + "xtags.xml").toURL();
                        } else {
                            JarFile jar = new JarFile(file);
                            JarEntry xdocletXml = jar.getJarEntry("META-INF/xdoclet.xml");
                            xtagsURL = new URL(new URL("jar:" + file.toURL() + "!/"), "META-INF/xtags.xml");
                            if (xdocletXml != null) {
                                log.debug(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? ModuleFinder.class$("xdoclet.loader.LoaderMessages") : class$xdoclet$loader$LoaderMessages, "PARSING_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                                xdocletXmlIs = jar.getInputStream(xdocletXml);
                            } else {
                                log.debug(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? ModuleFinder.class$("xdoclet.loader.LoaderMessages") : class$xdoclet$loader$LoaderMessages, "SKIP_NO_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                            }
                        }
                        if (xdocletXmlIs == null) continue;
                        InputSource in = new InputSource(xdocletXmlIs);
                        in.setSystemId(xtagsURL.toString());
                        XDocletModule module = parser.parse(in);
                        if (module != null) {
                            module.setXTagsDefinitionURL(xtagsURL);
                            modules.add(module);
                            continue;
                        }
                        log.warn(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? ModuleFinder.class$("xdoclet.loader.LoaderMessages") : class$xdoclet$loader$LoaderMessages, "BAD_XDOCLET_XML", new String[]{file.getAbsolutePath()}));
                        continue;
                    }
                    catch (ZipException ze) {
                        log.warn(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? ModuleFinder.class$("xdoclet.loader.LoaderMessages") : class$xdoclet$loader$LoaderMessages, "INVALID_ZIP_FILE", new String[]{file.getName()}));
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? (class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("xdoclet.loader.LoaderMessages")) : class$xdoclet$loader$LoaderMessages, "LOAD_MODULE_ERROR", new String[]{e.getMessage()}));
                    }
                }
                log.warn(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? ModuleFinder.class$("xdoclet.loader.LoaderMessages") : class$xdoclet$loader$LoaderMessages, "NONEXISTANT_CLASSPATH_ENTRY", new String[]{file.getAbsolutePath()}));
            }
            log.debug(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? (class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("xdoclet.loader.LoaderMessages")) : class$xdoclet$loader$LoaderMessages, "DONE_REGISTERING_MODULES", new String[]{String.valueOf(modules.size())}));
        }
        return modules;
    }

    public static void resetFoundModules() {
        modules = null;
    }

    private static List findModuleFiles() {
        if (classpath == null) {
            throw new IllegalStateException(Translator.getString(class$xdoclet$loader$LoaderMessages == null ? (class$xdoclet$loader$LoaderMessages = ModuleFinder.class$("xdoclet.loader.LoaderMessages")) : class$xdoclet$loader$LoaderMessages, "INIT_CLASSPATH_NOT_CALLED"));
        }
        ArrayList<File> result = new ArrayList<File>();
        StringTokenizer pathTokenizer = new StringTokenizer(classpath, System.getProperty("path.separator"));
        while (pathTokenizer.hasMoreTokens()) {
            File file = new File(pathTokenizer.nextToken());
            if (file.isDirectory()) {
                if (!new File(file, "META-INF" + File.separator + "xdoclet.xml").exists()) continue;
                result.add(file);
                continue;
            }
            if (!jarFilter.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        modules = null;
    }
}

