/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.BrowseDialog;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.client.DavSearch;
import org.exoplatform.applications.ooplugin.client.Multistatus;
import org.exoplatform.applications.ooplugin.client.ResponseDoc;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.applications.ooplugin.search.SQLQuery;
import org.exoplatform.services.log.ExoLogger;

public class SearchDialog
extends BrowseDialog {
    private static final Log LOG = ExoLogger.getLogger(SearchDialog.class);
    public static final String DIALOG_NAME = "_SearchDialog";
    public static final String EDT_TEXT = "edtText";
    public static final String BTN_SEARCH = "btnSearch";
    public static final String BTN_OPEN = "btnOpen";
    private String searchContent = "";
    private Thread searchThread;

    public SearchDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = DIALOG_NAME;
        this.addHandler("lstItems", 3, new ListItemsClick());
        this.addHandler(BTN_SEARCH, 1, new SearchClick());
        this.addHandler(BTN_OPEN, 1, new OpenClick());
        this.isNeedAddHandlers = false;
    }

    protected void disableAll() {
        super.disableAll();
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_SEARCH))).setEnable(true);
    }

    protected void enableAll() {
        super.enableAll();
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_SEARCH))).setEnable(true);
    }

    private boolean tryOpenSelected() throws Exception {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.xControlContainer.getControl("lstItems"));
        short selectedPos = xListBox.getSelectedItemPos();
        if (selectedPos < 0) {
            return false;
        }
        ResponseDoc response = (ResponseDoc)this.responses.get(selectedPos);
        if (this.isCollection(response)) {
            return false;
        }
        String href = response.getHref();
        this.doOpenRemoteFile(href);
        return true;
    }

    private class OpenClick
    extends ActionListener {
        private OpenClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                SearchDialog.this.tryOpenSelected();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    private class ListItemsClick
    extends ActionListener {
        private ListItemsClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                SearchDialog.this.tryOpenSelected();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    private class SearchThread
    extends Thread {
        private SearchThread() {
        }

        public void run() {
            try {
                DavSearch davSearch = new DavSearch(SearchDialog.this.config.getContext());
                davSearch.setResourcePath("/");
                SQLQuery sqlQuery = new SQLQuery();
                sqlQuery.setQuery("select * from nt:base where contains(*, '" + SearchDialog.this.searchContent + "')");
                davSearch.setQuery(sqlQuery);
                int status = davSearch.execute();
                if (status != 207) {
                    SearchDialog.this.showMessageBox("Search error! Code: " + status);
                    return;
                }
                Multistatus multistatus = davSearch.getMultistatus();
                SearchDialog.this.responses = multistatus.getResponses();
                SearchDialog.this.fillItemsList();
                if (SearchDialog.this.responses.size() == 0) {
                    SearchDialog.this.showMessageBox("No files found!");
                }
                SearchDialog.this.enableAll();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    private class SearchClick
    extends ActionListener {
        private SearchClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                SearchDialog.this.disableAll();
                XTextComponent xEdtText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)SearchDialog.this.xControlContainer.getControl(SearchDialog.EDT_TEXT));
                SearchDialog.this.searchContent = xEdtText.getText();
                SearchDialog.this.searchThread = new SearchThread();
                SearchDialog.this.searchThread.start();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception" + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

