/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.client.DocumentApi;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentManager {
    private static Log LOG = ExoLogger.getLogger(DocumentManager.class);
    protected static String[][] availableDocuments = new String[][]{{"multistatus", "org.exoplatform.applications.ooplugin.client.Multistatus"}};

    public static DocumentApi getResponseDocument(InputStream inStream) {
        if (inStream == null) {
            return null;
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(inStream);
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node curDocumentNode = nodeList.item(i);
                String localName = curDocumentNode.getLocalName();
                String nameSpace = curDocumentNode.getNamespaceURI();
                if (localName == null || !"DAV:".equals(nameSpace)) continue;
                for (int docI = 0; docI < availableDocuments.length; ++docI) {
                    if (!localName.equals(availableDocuments[docI][0])) continue;
                    DocumentApi responseDoc = (DocumentApi)Class.forName(availableDocuments[docI][1]).newInstance();
                    responseDoc.initFromDocument(document);
                    return responseDoc;
                }
            }
        }
        catch (Exception exc) {
            LOG.info((Object)"Unhandled exception. ", (Throwable)exc);
            exc.printStackTrace();
        }
        return null;
    }
}

