/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.LocalFileSystem;
import org.exoplatform.applications.ooplugin.OOUtils;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.dialog.DialogBuilder;
import org.exoplatform.applications.ooplugin.dialog.EventHandler;
import org.exoplatform.applications.ooplugin.utils.TextUtils;
import org.exoplatform.applications.ooplugin.utils.WebDavUtils;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.services.log.ExoLogger;

public class PlugInDialog {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.PlugInDialog");
    protected String dialogName = "";
    protected boolean enabled = false;
    protected XComponentContext xComponentContext;
    protected XFrame xFrame;
    protected XToolkit xToolkit;
    protected XDialog xDialog;
    protected XControlContainer xControlContainer;
    protected ArrayList<EventHandler> eventHandlers = new ArrayList();
    protected WebDavConfig config;

    public PlugInDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit) {
        this.config = config;
        this.xComponentContext = xComponentContext;
        this.xFrame = xFrame;
        this.xToolkit = xToolkit;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableg() {
        return this.enabled;
    }

    public String getDialogName() {
        return this.dialogName;
    }

    public XControlContainer getControlContainer() {
        return this.xControlContainer;
    }

    public void setControlContainer(XControlContainer xControlContainer) {
        this.xControlContainer = xControlContainer;
    }

    public XComponentContext getConponentContext() {
        return this.xComponentContext;
    }

    public void addHandler(String componentName, int componentType, Object listener) {
        EventHandler handler = new EventHandler(componentName, componentType, listener);
        this.eventHandlers.add(handler);
    }

    public boolean launchBeforeOpen() {
        return true;
    }

    public void createDialog() throws com.sun.star.uno.Exception {
        if ("".equals(this.dialogName)) {
            return;
        }
        try {
            DialogBuilder builder = new DialogBuilder(this, this.xFrame, this.xToolkit);
            builder.init();
            Object dialog = builder.createDialog(this.dialogName, this.eventHandlers);
            this.xDialog = (XDialog)UnoRuntime.queryInterface(XDialog.class, (Object)dialog);
            if (this.launchBeforeOpen()) {
                this.enabled = true;
                this.xDialog.execute();
            }
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)dialog);
            xComponent.dispose();
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
        }
    }

    protected void prepareTmpPath(String tempPath) {
        tempPath = tempPath.lastIndexOf("/") != 0 ? tempPath.substring(0, tempPath.lastIndexOf("/")) : "/";
        String documentPath = LocalFileSystem.getDocumentsPath() + File.separatorChar + LocalFileSystem.STORAGEDIR + File.separatorChar + this.config.getWorkSpace() + tempPath;
        File outDirectory = new File(documentPath = documentPath.replace("\\", "/"));
        if (!outDirectory.exists()) {
            outDirectory.mkdirs();
        }
    }

    protected void doOpenRemoteFile(String href) throws Exception {
        HTTPConnection connection;
        HTTPResponse response;
        int status;
        String serverPrefix = this.config.getServerPrefix();
        if (!href.startsWith(serverPrefix)) {
            return;
        }
        String resourcePath = href.substring(serverPrefix.length());
        String[] pathSegments = resourcePath.split("/");
        StringBuffer sb = new StringBuffer();
        for (String segment : pathSegments) {
            sb.append(TextUtils.DecodePath(segment));
        }
        resourcePath = sb.toString();
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if ((status = (response = (connection = WebDavUtils.getAuthConnection(this.config)).Get(href)).getStatusCode()) != 200) {
            this.showMessageBox("Can't open remote file. ErrorCode: " + status);
            return;
        }
        this.prepareTmpPath(resourcePath);
        String filePath = LocalFileSystem.getDocumentsPath() + File.separatorChar + LocalFileSystem.STORAGEDIR + File.separatorChar + this.config.getWorkSpace() + resourcePath;
        filePath = filePath.replace("\\", "/");
        filePath = filePath.replace("?", ".");
        File outFile = new File(filePath);
        if (outFile.exists()) {
            outFile.delete();
        }
        outFile.createNewFile();
        FileOutputStream fileOutStream = new FileOutputStream(outFile);
        byte[] fileContent = response.getData();
        fileOutStream.write(fileContent);
        fileOutStream.close();
        OOUtils.loadFromFile(this.xComponentContext, filePath, resourcePath);
    }

    public void showMessageBox(String sMessage) {
        try {
            if (null != this.xFrame && null != this.xToolkit) {
                XMessageBox xMsgBox;
                WindowDescriptor aDescriptor = new WindowDescriptor();
                aDescriptor.Type = WindowClass.MODALTOP;
                aDescriptor.WindowServiceName = new String("infobox");
                aDescriptor.ParentIndex = (short)-1;
                aDescriptor.Parent = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getContainerWindow());
                aDescriptor.Bounds = new Rectangle(0, 0, 300, 200);
                aDescriptor.WindowAttributes = 208;
                XWindowPeer xPeer = this.xToolkit.createWindow(aDescriptor);
                if (null != xPeer && null != (xMsgBox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xPeer))) {
                    xMsgBox.setCaptionText("eXo-Platform OOPlug-In.");
                    xMsgBox.setMessageText(sMessage);
                    xMsgBox.execute();
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            log.info((Object)("Unhandled exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public short confirmMessageBox(String sMessage) {
        try {
            if (null != this.xFrame && null != this.xToolkit) {
                XMessageBox xMsgBox;
                WindowDescriptor aDescriptor = new WindowDescriptor();
                aDescriptor.Type = WindowClass.MODALTOP;
                aDescriptor.WindowServiceName = new String("querybox");
                aDescriptor.ParentIndex = (short)-1;
                aDescriptor.Parent = (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.xFrame.getContainerWindow());
                aDescriptor.Bounds = new Rectangle(0, 0, 350, 200);
                aDescriptor.WindowAttributes = 0x20000D0;
                XWindowPeer xPeer = this.xToolkit.createWindow(aDescriptor);
                if (null != xPeer && null != (xMsgBox = (XMessageBox)UnoRuntime.queryInterface(XMessageBox.class, (Object)xPeer))) {
                    xMsgBox.setCaptionText("eXo-Platform OOPlug-In.");
                    xMsgBox.setMessageText(sMessage);
                    return xMsgBox.execute();
                }
            }
        }
        catch (com.sun.star.uno.Exception e) {
            log.info((Object)("Unhandled exception" + e.getMessage()), (Throwable)e);
        }
        return 3;
    }
}

