/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.dialog;

import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.XActionListener;
import com.sun.star.awt.XButton;
import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.PlugInDialog;
import org.exoplatform.applications.ooplugin.Resources;
import org.exoplatform.applications.ooplugin.config.XmlConfig;
import org.exoplatform.applications.ooplugin.dialog.Component;
import org.exoplatform.applications.ooplugin.dialog.ComponentProperty;
import org.exoplatform.applications.ooplugin.dialog.DialogModel;
import org.exoplatform.applications.ooplugin.dialog.EventHandler;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.applications.ooplugin.events.ItemListener;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogBuilder
extends XmlConfig {
    public static final String DIALOG_CONFIG = "/config/dialogconfig.xml";
    public static final String XML_DIALOGCONFIG = "dialogconfig";
    public static final String XML_DIALOG = "dialog";
    public static final String XML_NAME = "name";
    public static final String XML_COMPONENTS = "components";
    public static final String XML_COMPONENT = "component";
    public static final String XML_CLASS = "class";
    public static final String XML_HANDLER = "handler";
    public static final String XML_PROPERTIES = "properties";
    public static final String XML_PROPERTY = "property";
    public static final String XML_TYPE = "type";
    public static final String XML_VALUE = "value";
    private ArrayList<DialogModel> dialogs = new ArrayList();
    private static final Log LOG = ExoLogger.getLogger(DialogBuilder.class);
    private PlugInDialog plugInDialog;
    private XComponentContext xComponentContext;
    private XFrame xFrame;
    private XToolkit xToolkit;

    public DialogBuilder(PlugInDialog plugInDialog, XFrame xFrame, XToolkit xToolkit) {
        this.plugInDialog = plugInDialog;
        this.xComponentContext = plugInDialog.getConponentContext();
        this.xFrame = xFrame;
        this.xToolkit = xToolkit;
    }

    public Object createDialog(String dialogName, ArrayList<EventHandler> eventHandlers) throws Exception {
        DialogModel xmlDialog = null;
        for (int i = 0; i < this.dialogs.size(); ++i) {
            DialogModel curDialog = this.dialogs.get(i);
            if (!dialogName.equals(curDialog.getDialogName())) continue;
            xmlDialog = curDialog;
            break;
        }
        if (xmlDialog == null) {
            return null;
        }
        XMultiComponentFactory xMultiComponentFactory = this.xComponentContext.getServiceManager();
        Object dialogModel = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialogModel", this.xComponentContext);
        XPropertySet xPSetDialog = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)dialogModel);
        ArrayList<ComponentProperty> properties = xmlDialog.getProperties();
        for (int i = 0; i < properties.size(); ++i) {
            ComponentProperty property = properties.get(i);
            this.setProperty(xPSetDialog, property);
        }
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)dialogModel);
        XNameContainer xNameCont = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)dialogModel);
        ArrayList<Component> components = xmlDialog.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            Component component = components.get(i);
            Object componentModel = xMultiServiceFactory.createInstance(component.getClassName());
            XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)componentModel);
            ArrayList<ComponentProperty> compProperties = component.getProperties();
            for (int propi = 0; propi < compProperties.size(); ++propi) {
                ComponentProperty property = compProperties.get(propi);
                this.setProperty(propertySet, property);
            }
            xNameCont.insertByName(component.getPropertyValue("Name"), componentModel);
        }
        Object dialog = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.UnoControlDialog", this.xComponentContext);
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)dialog);
        XControlModel xControlModel = (XControlModel)UnoRuntime.queryInterface(XControlModel.class, (Object)dialogModel);
        xControl.setModel(xControlModel);
        XControlContainer xControlCont = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)dialog);
        this.plugInDialog.setControlContainer(xControlCont);
        block9: for (int i = 0; i < eventHandlers.size(); ++i) {
            EventHandler eventHandler = eventHandlers.get(i);
            Object listener = eventHandler.getListener();
            XControl compObject = xControlCont.getControl(eventHandler.getComponentName());
            switch (eventHandler.getComponentType()) {
                case 1: {
                    XButton xButtonObject = (XButton)UnoRuntime.queryInterface(XButton.class, (Object)compObject);
                    if (!(listener instanceof ActionListener)) continue block9;
                    xButtonObject.addActionListener((XActionListener)listener);
                    continue block9;
                }
                case 2: {
                    XComboBox xComboBox = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)compObject);
                    if (listener instanceof ActionListener) {
                        xComboBox.addActionListener((XActionListener)listener);
                        continue block9;
                    }
                    if (!(listener instanceof ItemListener)) continue block9;
                    xComboBox.addItemListener((XItemListener)listener);
                    continue block9;
                }
                case 3: {
                    XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)compObject);
                    if (!(listener instanceof XActionListener)) continue block9;
                    xListBox.addActionListener((XActionListener)listener);
                }
            }
        }
        Object toolkit = xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.ExtToolkit", this.xComponentContext);
        this.xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)toolkit);
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        xWindow.setVisible(false);
        xControl.createPeer(this.xToolkit, null);
        return dialog;
    }

    private void setProperty(XPropertySet propertySet, ComponentProperty property) throws Exception {
        if (property.isType("string")) {
            propertySet.setPropertyValue(property.getName(), (Object)property.getValue());
            return;
        }
        if (property.isType("integer")) {
            Integer intValue = new Integer(property.getValue());
            propertySet.setPropertyValue(property.getName(), (Object)intValue);
            return;
        }
        if (property.isType("short")) {
            Short shortValue = new Short(property.getValue());
            propertySet.setPropertyValue(property.getName(), (Object)shortValue);
            return;
        }
        if (property.isType("boolean")) {
            Boolean booleanValue = new Boolean(property.getValue());
            propertySet.setPropertyValue(property.getName(), (Object)booleanValue);
            return;
        }
        if (property.isType("image")) {
            String imagePath = "file:///" + Resources.getImage(property.getValue());
            propertySet.setPropertyValue(property.getName(), (Object)imagePath);
            return;
        }
        if (property.isType("fontdescriptor")) {
            String fontValue = property.getValue();
            String[] fontsValues = fontValue.split(":");
            FontDescriptor fontDescriptor = new FontDescriptor();
            fontDescriptor.Name = fontsValues[0];
            fontDescriptor.CharacterWidth = new Float(fontsValues[1]).floatValue();
            fontDescriptor.WordLineMode = true;
            if (fontsValues.length > 2) {
                fontDescriptor.Weight = 150.0f;
            }
            propertySet.setPropertyValue(property.getName(), (Object)fontDescriptor);
        }
    }

    public void init() {
        try {
            Document document = this.getDocumentFromResource(DIALOG_CONFIG);
            Node dialogConfigNode = this.getChildNode(document, XML_DIALOGCONFIG);
            NodeList nodes = dialogConfigNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node curNode = nodes.item(i);
                if (!XML_DIALOG.equals(curNode.getLocalName())) continue;
                this.parseDialog(curNode);
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
        }
    }

    private void parseDialog(Node dialogNode) {
        Node nameNode = this.getChildNode(dialogNode, XML_NAME);
        DialogModel dialog = new DialogModel(nameNode.getTextContent());
        Node propertiesNode = this.getChildNode(dialogNode, XML_PROPERTIES);
        NodeList properties = propertiesNode.getChildNodes();
        for (int i = 0; i < properties.getLength(); ++i) {
            Node curNode = properties.item(i);
            if (!XML_PROPERTY.equals(curNode.getLocalName())) continue;
            NamedNodeMap nnm = curNode.getAttributes();
            String propertyName = nnm.getNamedItem(XML_NAME).getTextContent();
            String propertyType = nnm.getNamedItem(XML_TYPE).getTextContent();
            String propertyValue = nnm.getNamedItem(XML_VALUE).getTextContent();
            ComponentProperty property = new ComponentProperty(propertyName, propertyType, propertyValue);
            dialog.getProperties().add(property);
        }
        Node componentsNode = this.getChildNode(dialogNode, XML_COMPONENTS);
        NodeList components = componentsNode.getChildNodes();
        for (int i = 0; i < components.getLength(); ++i) {
            Node curNode = components.item(i);
            if (!XML_COMPONENT.equals(curNode.getLocalName())) continue;
            Component component = this.parseComponent(curNode);
            dialog.getComponents().add(component);
        }
        this.dialogs.add(dialog);
    }

    private Component parseComponent(Node componentNode) {
        Node classNode = this.getChildNode(componentNode, XML_CLASS);
        String handler = "";
        Node handlerNode = this.getChildNode(componentNode, XML_HANDLER);
        if (handlerNode != null) {
            handler = handlerNode.getTextContent();
        }
        Component component = new Component(classNode.getTextContent(), handler);
        NodeList properties = componentNode.getChildNodes();
        for (int i = 0; i < properties.getLength(); ++i) {
            Node curNode = properties.item(i);
            if (!XML_PROPERTY.equals(curNode.getLocalName())) continue;
            NamedNodeMap nnm = curNode.getAttributes();
            String propertyName = nnm.getNamedItem(XML_NAME).getTextContent();
            String propertyType = nnm.getNamedItem(XML_TYPE).getTextContent();
            String propertyValue = nnm.getNamedItem(XML_VALUE).getTextContent();
            ComponentProperty property = new ComponentProperty(propertyName, propertyType, propertyValue);
            component.getProperties().add(property);
        }
        return component;
    }
}

