/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.scale;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;

public class ScaleBase {
    Log log = ExoLogger.getLogger((String)"repload.ScaleBase");
    String[] args;
    private String sConf;
    private String sRepository;
    private String sWorkspace;
    private String sRoot;
    private String sVdfile;
    private String sMimeType;
    private StandaloneContainer container;
    private CredentialsImpl credentials;
    private RepositoryService repositoryService;
    private RepositoryImpl repository;
    private SessionImpl session;
    private Node root;
    private Node rootTestNode;
    private long min;
    private long max;
    private long sum;
    private int iteration = 100;
    private double avr;

    public ScaleBase(String[] args) {
        this.args = args;
        try {
            this.initRepository();
        }
        catch (Exception e) {
            this.log.error((Object)"Error init reposytory", (Throwable)e);
        }
    }

    public void initRepository() throws Exception {
        try {
            this.sConf = this.getPartam("-conf", this.args);
            this.sRepository = this.getPartam("-repo", this.args);
            this.sWorkspace = this.getPartam("-ws", this.args);
            this.sRoot = this.getPartam("-root", this.args);
            this.sVdfile = this.getPartam("-vdfile", this.args);
            this.sMimeType = this.getPartam("-mimeType", this.args);
            this.log.info((Object)("-conf: " + this.sConf));
            StandaloneContainer.setConfigurationPath((String)this.sConf);
            this.container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            this.credentials = new CredentialsImpl("admin", "admin".toCharArray());
            this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
            this.repository = (RepositoryImpl)this.repositoryService.getRepository(this.sRepository);
            if (this.repository != null) {
                this.log.info((Object)"--->>> perository");
            }
            this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, this.sWorkspace);
            if (this.session != null) {
                this.log.info((Object)"--->>> session");
            }
            this.root = this.session.getRootNode();
            if (this.root != null) {
                this.log.info((Object)"--->>> root");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not initialize repository", (Throwable)e);
        }
        try {
            if (this.sRoot.startsWith("/")) {
                this.rootTestNode = (Node)this.session.getItem(this.sRoot);
                this.log.info((Object)("--->>> Node " + this.sRoot + " exist"));
            } else {
                new Exception("Test root is not absolute path: " + this.sRoot);
            }
        }
        catch (PathNotFoundException e) {
            try {
                this.rootTestNode = this.addNodes(this.sRoot, this.root);
                this.session.save();
                this.log.info((Object)("--->>> Node " + this.sRoot + " create"));
                if (this.rootTestNode != null) {
                    this.log.info((Object)"--->>> rootTestNode");
                }
            }
            catch (Exception ee) {
                this.log.error((Object)("Can not create roottest node: " + this.sRoot), (Throwable)ee);
            }
        }
    }

    String getPartam(String paramName, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] para = args[i].split("=");
            if (!para[0].equals(paramName)) continue;
            return para[1];
        }
        return "";
    }

    private Node addNodes(String sRoot, Node parentNode) throws Exception {
        String[] mas = sRoot.split("/");
        Node temp = parentNode;
        for (int i = 1; i < mas.length; ++i) {
            if (temp.hasNode(mas[i])) {
                temp = (NodeImpl)temp.getNode(mas[i]);
                continue;
            }
            temp = (NodeImpl)temp.addNode(mas[i]);
            this.session.save();
        }
        return temp;
    }

    public void createFolder() throws RepositoryException {
        Node createBase = this.rootTestNode.addNode("createFolder", "nt:folder");
        this.min = 100000L;
        this.max = -1L;
        this.sum = 0L;
        for (int i = 0; i < this.iteration; ++i) {
            long start = System.currentTimeMillis();
            createBase.addNode("folder" + i, "nt:folder");
            this.session.save();
            long end = System.currentTimeMillis();
            long tmp = end - start;
            if (tmp > this.max) {
                this.max = tmp;
            }
            if (tmp < this.min) {
                this.min = tmp;
            }
            this.sum += tmp;
        }
        this.avr = (double)this.sum / (double)this.iteration;
        System.out.println("\nCreate folder:");
        System.out.println("\tavr: " + this.avr + " ms");
        System.out.println("\tmin: " + this.min + " ms");
        System.out.println("\tmax: " + this.max + " ms");
    }

    public void deleteFolder() throws RepositoryException {
        Node deleteBase = this.rootTestNode.addNode("deleteFolder", "nt:folder");
        this.min = 10000000L;
        this.max = 0L;
        this.sum = 0L;
        for (int i = 0; i < this.iteration; ++i) {
            Node temp = deleteBase.addNode("folder" + i, "nt:folder");
            this.session.save();
            long start = System.currentTimeMillis();
            temp.remove();
            this.session.save();
            long end = System.currentTimeMillis();
            long tmp = end - start;
            if (tmp > this.max) {
                this.max = tmp;
            }
            if (tmp < this.min) {
                this.min = tmp;
            }
            this.sum += tmp;
        }
        this.avr = (double)this.sum / (double)this.iteration;
        System.out.println("\nDelete folder:");
        System.out.println("\tavr: " + this.avr + " ms");
        System.out.println("\tmin: " + this.min + " ms");
        System.out.println("\tmax: " + this.max + " ms");
    }

    public void uploadFile() throws RepositoryException, IOException {
        Node uploadBase = this.rootTestNode.addNode("uploadFolder", "nt:folder");
        this.min = 10000000L;
        this.max = 0L;
        this.sum = 0L;
        for (int i = 0; i < this.iteration; ++i) {
            long start = System.currentTimeMillis();
            Node nodeFile = uploadBase.addNode("file" + i, "nt:file");
            Node contentNode = nodeFile.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:data", (InputStream)new FileInputStream(this.sVdfile));
            contentNode.setProperty("jcr:mimeType", this.sMimeType);
            contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
            this.session.save();
            long end = System.currentTimeMillis();
            long tmp = end - start;
            if (tmp > this.max) {
                this.max = tmp;
            }
            if (tmp < this.min) {
                this.min = tmp;
            }
            this.sum += tmp;
        }
        this.avr = (double)this.sum / (double)this.iteration;
        System.out.println("\nUpload file:");
        System.out.println("\tavr: " + this.avr + " ms");
        System.out.println("\tmin: " + this.min + " ms");
        System.out.println("\tmax: " + this.max + " ms");
    }

    public void downloadFile() throws RepositoryException, IOException {
        Node uploadBase = this.rootTestNode.getNode("uploadFolder");
        this.min = 10000000L;
        this.max = 0L;
        this.sum = 0L;
        for (int i = 0; i < this.iteration; ++i) {
            int len;
            long start = System.currentTimeMillis();
            Node temp = uploadBase.getNode("file" + i);
            InputStream is = temp.getNode("jcr:content").getProperty("jcr:data").getStream();
            byte[] buf = new byte[204800];
            while ((len = is.read(buf)) > 0) {
            }
            long end = System.currentTimeMillis();
            long tmp = end - start;
            if (tmp > this.max) {
                this.max = tmp;
            }
            if (tmp < this.min) {
                this.min = tmp;
            }
            this.sum += tmp;
        }
        this.avr = (double)this.sum / (double)this.iteration;
        System.out.println("\nDownload file:");
        System.out.println("\tavr: " + this.avr + " ms");
        System.out.println("\tmin: " + this.min + " ms");
        System.out.println("\tmax: " + this.max + " ms");
    }
}

