/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.repoload.DataUploaderTh;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUploader {
    protected Log log = ExoLogger.getLogger((String)"repload.DataUploader");
    protected String[] args;
    protected HashMap<String, String> mapConfig;
    protected String tree = "10-5-5-5";
    protected String sVdfile = "/image.tif";
    protected String sConf = "/exo-configuration.xml";
    protected String sRoot = "/testroot";
    protected String sWorkspace = "ws";
    protected String sRepository = "db1";
    protected String sReadTree = "false";
    protected SessionImpl session;
    protected SessionDataManager dataManager;
    protected RepositoryImpl repository;
    protected CredentialsImpl credentials;
    protected WorkspaceImpl workspace;
    protected RepositoryService repositoryService;
    protected NodeImpl root;
    protected NodeImpl rootTestNode;
    protected StandaloneContainer container;
    protected WorkspaceStorageConnection connection;
    protected WorkspaceDataContainerBase workspaceDataContainer;
    protected LocationFactory locationFactory;
    protected TransientValueData fileData;
    protected Calendar date;
    protected String sName;
    protected String sFile;
    public int countNodes;
    protected String sMimeType;
    protected FileCleaner fileCleaner;

    public DataUploader(String[] args) {
        this.mapConfig = this.parceCommandLine(args);
        this.args = args;
    }

    public void initRepository() throws Exception {
        this.sConf = this.mapConfig.get("-conf");
        this.sRepository = this.mapConfig.get("-repo");
        this.sWorkspace = this.mapConfig.get("-ws");
        this.sRoot = this.mapConfig.get("-root");
        this.sVdfile = this.mapConfig.get("-vdfile");
        this.sReadTree = this.mapConfig.get("-readtree");
        this.sMimeType = this.mapConfig.get("-mimeType");
        this.fileCleaner = new FileCleaner();
        if (!this.sVdfile.equals("")) {
            this.fileData = new TransientValueData((InputStream)new FileInputStream(this.sVdfile));
            this.fileData.setFileCleaner(this.fileCleaner);
        }
        try {
            StandaloneContainer.addConfigurationPath((String)this.sConf);
            this.container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            this.credentials = new CredentialsImpl("admin", "admin".toCharArray());
            this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
            this.repository = (RepositoryImpl)this.repositoryService.getRepository(this.sRepository);
            if (this.repository != null) {
                this.log.info((Object)"--->>> perository");
            }
            this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, this.sWorkspace);
            if (this.session != null) {
                this.log.info((Object)"--->>> session");
            }
            this.locationFactory = this.session.getLocationFactory();
            if (this.locationFactory != null) {
                this.log.info((Object)"--->>> locationFactory");
            }
            this.dataManager = this.session.getTransientNodesManager();
            if (this.dataManager != null) {
                this.log.info((Object)"--->>> dataManager");
            }
            this.workspaceDataContainer = (WorkspaceDataContainerBase)this.session.getContainer().getComponentInstanceOfType(WorkspaceDataContainerBase.class);
            this.connection = this.workspaceDataContainer.openConnection();
            if (this.connection != null) {
                this.log.info((Object)"--->>> connection");
            }
            this.workspace = this.session.getWorkspace();
            if (this.workspace != null) {
                this.log.info((Object)"--->>> workspace");
            }
            this.root = (NodeImpl)this.session.getRootNode();
            if (this.root != null) {
                this.log.info((Object)"--->>> root");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not initialize repository", (Throwable)e);
        }
        try {
            if (this.sRoot.startsWith("/")) {
                this.rootTestNode = (NodeImpl)this.session.getItem(this.sRoot);
                this.log.info((Object)("--->>> Node " + this.sRoot + " exist"));
            } else {
                new Exception("Test root is not absolute path: " + this.sRoot);
            }
        }
        catch (PathNotFoundException e) {
            try {
                this.rootTestNode = this.addNodes(this.sRoot, this.root);
                this.session.save();
                this.log.info((Object)("--->>> Node " + this.sRoot + " create"));
                if (this.rootTestNode != null) {
                    this.log.info((Object)"--->>> rootTestNode");
                }
            }
            catch (Exception ee) {
                this.log.error((Object)("Can not create roottest node: " + this.sRoot), (Throwable)ee);
            }
        }
        DCPropertyQName.dcElementSet = this.locationFactory.parseJCRName("dc:elementSet").getInternalName();
        DCPropertyQName.dcTitle = this.locationFactory.parseJCRName("dc:title").getInternalName();
        DCPropertyQName.dcCreator = this.locationFactory.parseJCRName("dc:creator").getInternalName();
        DCPropertyQName.dcSubject = this.locationFactory.parseJCRName("dc:subject").getInternalName();
        DCPropertyQName.dcDescription = this.locationFactory.parseJCRName("dc:description").getInternalName();
        DCPropertyQName.dcPublisher = this.locationFactory.parseJCRName("dc:publisher").getInternalName();
    }

    private NodeImpl addNodes(String sRoot, NodeImpl parentNode) throws Exception {
        String[] mas = sRoot.split("/");
        NodeImpl temp = parentNode;
        for (int i = 1; i < mas.length; ++i) {
            if (temp.hasNode(mas[i])) {
                temp = (NodeImpl)temp.getNode(mas[i]);
                continue;
            }
            temp = (NodeImpl)temp.addNode(mas[i]);
            this.session.save();
        }
        return temp;
    }

    public void uploadData() throws Exception {
        int[] tree = this.getTree(this.mapConfig.get("-tree"));
        this.log.info((Object)">>>>>>>>>>>---------- Upload data ----------<<<<<<<<<<<<");
        this.sName = "node";
        this.sFile = "file";
        this.date = Calendar.getInstance();
        this.countNodes = 0;
        long start = System.currentTimeMillis();
        for (int i = 1; i <= tree[0]; ++i) {
            try {
                TransientNodeData nodeData_L1 = this.addNode(this.connection, this.sName + i, i, this.rootTestNode, this.date);
                for (int j = 1; j <= tree[1]; ++j) {
                    TransientNodeData nodeData_L2 = this.addNode(this.connection, this.sName + j, j, nodeData_L1, this.date);
                    long localStart = System.currentTimeMillis();
                    for (int k = 1; k <= tree[2]; ++k) {
                        TransientNodeData nodeData_L3 = this.addNode(this.connection, this.sName + k, k, nodeData_L2, this.date);
                        for (int index = 1; index <= tree[3]; ++index) {
                            this.addNode_file(this.connection, this.sFile + index, index, nodeData_L3, this.date, this.fileData);
                            ++this.countNodes;
                        }
                        this.connection.commit();
                        this.connection = this.getConnection();
                        this.log.info((Object)("Node " + i + " - " + j + " - " + k + " - " + "[1..." + tree[3] + "] add"));
                    }
                    long localEnd = System.currentTimeMillis();
                    this.log.info((Object)("\tThe time of adding of " + tree[2] * tree[3] + " nodes: " + (double)(localEnd - localStart) / 1000.0 + " sec"));
                    this.log.info((Object)("\tTotal adding time " + this.countNodes + " nodes: " + (double)(localEnd - start) / 1000.0 + " sec"));
                }
                continue;
            }
            catch (Exception e) {
                this.connection.rollback();
                this.log.error((Object)">>>>>>>>>>>---------- Upload data Exception ----------<<<<<<<<<<<<", (Throwable)e);
            }
        }
        long end = System.currentTimeMillis();
        this.log.info((Object)("The time of the adding of " + this.countNodes + " nodes: " + (double)(end - start) / 1000.0 + " sec"));
    }

    public void uploadDataTh() {
        int i;
        int[] tree = this.getTree(this.mapConfig.get("-tree"));
        Thread[] threads = new Thread[tree[0]];
        DataUploaderTh[] uploaderThs = new DataUploaderTh[tree[0]];
        for (i = 0; i < threads.length; ++i) {
            uploaderThs[i] = new DataUploaderTh(this.args, this.workspaceDataContainer, this.rootTestNode, i + 1);
            threads[i] = new Thread(uploaderThs[i]);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
    }

    public void readData() {
        if (this.sReadTree.compareTo("true") == 0) {
            int[] tree = this.getTree(this.mapConfig.get("-tree"));
            for (int i = 1; i <= tree[0]; ++i) {
                try {
                    NodeImpl n_1 = this.getNode(this.rootTestNode, this.sName + i);
                    for (int j = 1; j <= tree[1]; ++j) {
                        NodeImpl n_2 = this.getNode(n_1, this.sName + j);
                        for (int k = 1; k <= tree[2]; ++k) {
                            NodeImpl n_3 = this.getNode(n_2, this.sName + k);
                            for (int s = 1; s <= tree[3]; ++s) {
                                NodeImpl n_4 = this.getNode(n_3, this.sFile + s);
                                NodeImpl sourceNode = this.getNode(n_4, "jcr:content");
                                InputStream fis = this.getProperty(sourceNode, "jcr:data").getStream();
                                Value[] t = this.getProperty(n_4, "dc:title").getValues();
                                String tit = t[0].getString();
                                Value[] d = this.getProperty(n_4, "dc:description").getValues();
                                String des = d[0].getString();
                                this.log.info((Object)("--->>> Node " + this.mapConfig.get("-root") + "/" + this.sName + i + "/" + this.sName + j + "/" + this.sName + k + "/" + this.sFile + s + " exist : " + fis.available() + " b   |   dc:title --> " + tit + "   |   dc:description --> " + des));
                            }
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    this.log.error((Object)">>>>>>>>>>>---------- Read data Exception ----------<<<<<<<<<<<<", (Throwable)e);
                }
            }
        }
    }

    private TransientNodeData creteNodeData_nt_folder(String name, int orderNum, NodeImpl parentNode) {
        InternalQName[] mixinTypeNames = new InternalQName[]{};
        InternalQName iQName = new InternalQName("", name);
        QPath path = QPath.makeChildPath((QPath)parentNode.getInternalPath(), (InternalQName)iQName);
        AccessControlList acl = new AccessControlList();
        String uuid = IdGenerator.generate();
        TransientNodeData nodeData = new TransientNodeData(path, uuid, -1, Constants.NT_FOLDER, mixinTypeNames, orderNum, parentNode.getInternalIdentifier(), acl);
        return nodeData;
    }

    protected TransientNodeData addNode(WorkspaceStorageConnection con, String name, int orderNum, NodeImpl parentNode, Calendar date) throws Exception {
        TransientNodeData nodeData = this.creteNodeData_nt_folder(name, orderNum, parentNode);
        con.add((NodeData)nodeData);
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FOLDER));
        con.add((PropertyData)primaryTypeData);
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(date));
        con.add((PropertyData)createdData);
        return nodeData;
    }

    private TransientNodeData creteNodeData(InternalQName iQName, int orderNum, TransientNodeData parentNode, InternalQName primaryType, InternalQName mixinName) throws Exception {
        InternalQName[] mixinTypeNames = null;
        mixinTypeNames = mixinName == null ? new InternalQName[]{} : new InternalQName[]{mixinName};
        QPath path = QPath.makeChildPath((QPath)parentNode.getQPath(), (InternalQName)iQName);
        AccessControlList acl = new AccessControlList();
        String uuid = IdGenerator.generate();
        TransientNodeData nodeData = new TransientNodeData(path, uuid, -1, primaryType, mixinTypeNames, orderNum, parentNode.getIdentifier(), acl);
        return nodeData;
    }

    protected TransientNodeData addNode(WorkspaceStorageConnection con, String name, int orderNum, TransientNodeData parentNode, Calendar date) throws Exception {
        TransientNodeData nodeData = this.creteNodeData(new InternalQName("", name), orderNum, parentNode, Constants.NT_FOLDER, null);
        con.add((NodeData)nodeData);
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FOLDER));
        con.add((PropertyData)primaryTypeData);
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(date));
        con.add((PropertyData)createdData);
        return nodeData;
    }

    protected void addNode_file(WorkspaceStorageConnection con, String name, int orderNum, TransientNodeData parentNode, Calendar date, TransientValueData fData) throws Exception {
        TransientNodeData nodeData = this.creteNodeData(new InternalQName("", name), orderNum, parentNode, Constants.NT_FILE, DCPropertyQName.dcElementSet);
        con.add((NodeData)nodeData);
        TransientPropertyData primaryTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), false);
        primaryTypeData.setValue((ValueData)new TransientValueData(Constants.NT_FILE));
        con.add((PropertyData)primaryTypeData);
        TransientPropertyData createdData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_CREATED), IdGenerator.generate(), -1, 5, nodeData.getIdentifier(), false);
        createdData.setValue((ValueData)new TransientValueData(date));
        con.add((PropertyData)createdData);
        TransientPropertyData mixinTypeData = new TransientPropertyData(QPath.makeChildPath((QPath)nodeData.getQPath(), (InternalQName)Constants.JCR_MIXINTYPES), IdGenerator.generate(), -1, 7, nodeData.getIdentifier(), true);
        mixinTypeData.setValue((ValueData)new TransientValueData(DCPropertyQName.dcElementSet));
        con.add((PropertyData)mixinTypeData);
        TransientNodeData contentNode = this.creteNodeData(Constants.JCR_CONTENT, 0, nodeData, Constants.NT_RESOURCE, null);
        con.add((NodeData)contentNode);
        TransientPropertyData primaryTypeContenNode = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, contentNode.getIdentifier(), false);
        primaryTypeContenNode.setValue((ValueData)new TransientValueData(Constants.NT_RESOURCE));
        con.add((PropertyData)primaryTypeContenNode);
        TransientPropertyData uuidPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_UUID), IdGenerator.generate(), -1, 1, contentNode.getIdentifier(), false);
        uuidPropertyData.setValue((ValueData)new TransientValueData(IdGenerator.generate()));
        con.add((PropertyData)uuidPropertyData);
        TransientPropertyData mimeTypePropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_MIMETYPE), IdGenerator.generate(), -1, 1, contentNode.getIdentifier(), false);
        mimeTypePropertyData.setValue((ValueData)new TransientValueData(this.sMimeType));
        con.add((PropertyData)mimeTypePropertyData);
        TransientPropertyData lastModifiedPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_LASTMODIFIED), IdGenerator.generate(), -1, 5, contentNode.getIdentifier(), false);
        lastModifiedPropertyData.setValue((ValueData)new TransientValueData(date));
        con.add((PropertyData)lastModifiedPropertyData);
        TransientPropertyData dataPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)contentNode.getQPath(), (InternalQName)Constants.JCR_DATA), IdGenerator.generate(), -1, 2, contentNode.getIdentifier(), false);
        dataPropertyData.setValue((ValueData)fData);
        con.add((PropertyData)dataPropertyData);
        this.addDcElementSet(con, nodeData);
    }

    private void addDcElementSet(WorkspaceStorageConnection con, TransientNodeData nodeData) throws Exception {
        this.addDCProperty(con, nodeData, DCPropertyQName.dcTitle, "T123456789");
        this.addDCProperty(con, nodeData, DCPropertyQName.dcCreator, "C123456789");
        this.addDCProperty(con, nodeData, DCPropertyQName.dcSubject, "S123456789");
        this.addDCProperty(con, nodeData, DCPropertyQName.dcDescription, "D123456789");
        this.addDCProperty(con, nodeData, DCPropertyQName.dcPublisher, "P123456789");
    }

    private void addDCProperty(WorkspaceStorageConnection con, TransientNodeData dcNode, InternalQName propertyQName, String propertyContent) throws Exception {
        TransientPropertyData dcPropertyData = new TransientPropertyData(QPath.makeChildPath((QPath)dcNode.getQPath(), (InternalQName)propertyQName), IdGenerator.generate(), -1, 1, dcNode.getIdentifier(), true);
        dcPropertyData.setValue((ValueData)new TransientValueData(propertyContent));
        con.add((PropertyData)dcPropertyData);
    }

    public NodeImpl getNode(NodeImpl parentNode, String relPath) throws PathNotFoundException, RepositoryException {
        JCRPath itemPath = this.session.getLocationFactory().createJCRPath(parentNode.getLocation(), relPath);
        NodeImpl node = (NodeImpl)this.dataManager.getItem(itemPath.getInternalPath(), true);
        if (node == null) {
            throw new PathNotFoundException("Node not found " + itemPath.getAsString(true));
        }
        return node;
    }

    public Property getProperty(NodeImpl node, String relPath) throws PathNotFoundException, RepositoryException {
        JCRPath itemPath = this.locationFactory.createJCRPath(node.getLocation(), relPath);
        ItemImpl prop = this.dataManager.getItem(itemPath.getInternalPath(), true);
        if (prop == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + itemPath.getAsString(false));
        }
        return (Property)prop;
    }

    protected int[] getTree(String sTree) {
        String[] masTree = sTree.split("-");
        int[] iTree = new int[4];
        for (int i = 0; i < 4; ++i) {
            iTree[i] = Integer.valueOf(masTree[i]);
        }
        return iTree;
    }

    protected WorkspaceStorageConnection getConnection() throws Exception {
        return this.workspaceDataContainer.openConnection();
    }

    public WorkspaceDataContainerBase getWorkspaceDataContainer() {
        return this.workspaceDataContainer;
    }

    private HashMap<String, String> parceCommandLine(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-conf", "");
        map.put("-root", "");
        map.put("-tree", "");
        map.put("-vdfile", "");
        map.put("-repo", "");
        map.put("-ws", "");
        map.put("-readtree", "false");
        map.put("-read", "");
        map.put("-readdc", "false");
        map.put("-threads", "1");
        map.put("-iteration", "1");
        map.put("-concurrent", "false");
        map.put("-mimeType", "image/tiff");
        map.put("-api", "false");
        for (int i = 0; i < args.length; ++i) {
            String[] params = args[i].split("=");
            if (!map.containsKey(params[0])) {
                this.log.error((Object)("Error: " + params[0] + " unknown parameter"));
            }
            map.remove(params[0]);
            map.put(params[0], params[1]);
            this.log.info((Object)(params[0] + " = " + params[1]));
        }
        return map;
    }

    protected static class DCPropertyQName {
        public static InternalQName dcElementSet;
        public static InternalQName dcTitle;
        public static InternalQName dcCreator;
        public static InternalQName dcSubject;
        public static InternalQName dcDescription;
        public static InternalQName dcPublisher;

        protected DCPropertyQName() {
        }
    }
}

