/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReaderTh
implements Runnable {
    private Log log;
    protected HashMap<String, String> mapConfig;
    private int ntFolderCount;
    private int ntFileCount;
    private String threadName;
    private Node startNode;
    private Thread thReader;
    private int iteration;
    private long end;
    private long start;
    private long time = 0L;
    private boolean readProperty;

    public DataReaderTh(Node startNode, String threadName, HashMap<String, String> conf) {
        this.log = ExoLogger.getLogger((String)("repload.DataReaderTh_" + threadName));
        this.mapConfig = conf;
        this.threadName = threadName;
        this.startNode = startNode;
        this.thReader = new Thread((Runnable)this, threadName);
        this.iteration = Integer.valueOf(this.mapConfig.get("-iteration"));
        this.readProperty = Boolean.valueOf(this.mapConfig.get("-readprop"));
    }

    public void readChilds(Node parent) throws RepositoryException {
        String primaryType = parent.getPrimaryNodeType().getName();
        if (primaryType.equals("nt:folder")) {
            ++this.ntFolderCount;
            this.log.info((Object)("\t" + this.ntFolderCount + " nt:folder has been raed"));
            NodeIterator ni = parent.getNodes();
            if (ni.hasNext()) {
                while (ni.hasNext()) {
                    Node n1 = ni.nextNode();
                    this.readChilds(n1);
                }
            }
        } else if (primaryType.equals("nt:file")) {
            ++this.ntFileCount;
            this.log.info((Object)("\t" + this.ntFileCount + " nt:file has been raed"));
            if (this.readProperty) {
                this.showDCProperty(parent);
                NodeIterator ni = parent.getNodes();
                if (ni.hasNext()) {
                    while (ni.hasNext()) {
                        Node n1 = ni.nextNode();
                        this.readChilds(n1);
                    }
                } else {
                    this.showProperty(parent);
                }
            }
        } else if (this.readProperty) {
            this.showProperty(parent);
        }
    }

    public void showDCProperty(Node parent) throws RepositoryException {
        PropertyIterator pi = parent.getProperties();
        String sMix = parent.getPrimaryNodeType().getName();
        if (sMix.equals("nt:file")) {
            for (NodeType mt : parent.getMixinNodeTypes()) {
                sMix = sMix + " " + mt.getName();
            }
            this.log.info((Object)(sMix + " " + parent.getPath()));
            if (this.mapConfig.get("-readdc").equals("true")) {
                String[] dcprop = new String[]{"dc:title", "dc:creator", "dc:subject", "dc:description", "dc:publisher"};
                for (int i = 0; i < dcprop.length; ++i) {
                    Property propdc = parent.getProperty(dcprop[i]);
                    String s = propdc.getValues()[0].getString();
                    this.log.info((Object)("\t\t" + propdc.getName() + " " + PropertyType.nameFromValue((int)propdc.getType()) + " " + s));
                }
            }
        }
    }

    public void showProperty(Node parent) throws RepositoryException {
        PropertyIterator pi = parent.getProperties();
        String sMix = parent.getPrimaryNodeType().getName();
        if (sMix.equals("nt:resource")) {
            for (NodeType mt : parent.getMixinNodeTypes()) {
                sMix = sMix + " " + mt.getName();
            }
            this.log.info((Object)(sMix + " " + parent.getPath()));
            while (pi.hasNext()) {
                Property prop = pi.nextProperty();
                if (prop.getType() == 2) {
                    this.log.info((Object)("\t\t" + prop.getName() + " " + PropertyType.nameFromValue((int)prop.getType())));
                    continue;
                }
                String s = prop.getString();
                if (s.length() > 64) {
                    s = s.substring(0, 64);
                }
                this.log.info((Object)("\t\t" + prop.getName() + " " + PropertyType.nameFromValue((int)prop.getType()) + " " + s));
            }
        }
    }

    @Override
    public void run() {
        try {
            this.start = System.currentTimeMillis();
            for (int i = 0; i < this.iteration; ++i) {
                this.readChilds(this.startNode);
            }
            this.end = System.currentTimeMillis();
            this.time = this.end - this.start;
        }
        catch (RepositoryException e) {
            this.log.error((Object)"Error: read data", (Throwable)e);
            this.time = -1L;
        }
    }

    public void startRead() {
        this.thReader.start();
    }

    public long getTimeAdding() {
        return this.time;
    }

    public int getNTCount() {
        return this.ntFileCount;
    }

    public String getThreadName() {
        return this.threadName;
    }
}

