/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.search.spell.TRStringDistance;
import org.apache.lucene.store.Directory;

public class ExtendedSpellChecker
extends SpellChecker {
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private float minScore = 0.5f;
    private IndexSearcher indexSearcher;

    public ExtendedSpellChecker(Directory spellIndex) throws IOException {
        super(spellIndex);
    }

    public void setSpellIndex(Directory spellIndex) throws IOException {
        super.setSpellIndex(spellIndex);
        if (this.indexSearcher != null) {
            this.indexSearcher.close();
        }
        this.indexSearcher = new IndexSearcher(this.spellIndex);
    }

    public void setAccuracy(float minScore) {
        super.setAccuracy(minScore);
        this.minScore = minScore;
    }

    public String[] suggestSimilar(String word, int numSug) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, false);
    }

    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular) throws IOException {
        int goalFreq;
        float min = this.minScore;
        TRStringDistance sd = new TRStringDistance(word);
        int lengthWord = word.length();
        int freq = ir != null && field != null ? ir.docFreq(new Term(field, word)) : 0;
        int n = goalFreq = morePopular && ir != null && field != null ? freq : 0;
        if (!morePopular && freq > 0) {
            return new String[]{word};
        }
        BooleanQuery query = new BooleanQuery();
        for (int ng = this.getMin(lengthWord); ng <= this.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = ExtendedSpellChecker.formGrams(word, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                ExtendedSpellChecker.add(query, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                ExtendedSpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                ExtendedSpellChecker.add(query, key, grams[i]);
            }
        }
        Hits hits = this.indexSearcher.search((Query)query);
        SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
        int stop = Math.min(hits.length(), 10 * numSug);
        SuggestWord sugWord = new SuggestWord();
        for (int i = 0; i < stop; ++i) {
            sugWord.string = hits.doc(i).get("word");
            if (sugWord.string.equals(word)) continue;
            sugWord.score = 1.0f - (float)sd.getDistance(sugWord.string) / (float)Math.max(sugWord.string.length(), lengthWord);
            if (sugWord.score < min) continue;
            if (ir != null) {
                sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                if (morePopular && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
            }
            sugQueue.insert((Object)sugWord);
            if (sugQueue.size() == numSug) {
                min = ((SuggestWord)sugQueue.top()).score;
            }
            sugWord = new SuggestWord();
        }
        String[] list = new String[sugQueue.size()];
        for (int i = sugQueue.size() - 1; i >= 0; --i) {
            list[i] = ((SuggestWord)sugQueue.pop()).string;
        }
        return list;
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    public void indexDictionary(Dictionary dict) throws IOException {
        super.indexDictionary(dict);
        this.indexSearcher.close();
        this.indexSearcher = new IndexSearcher(this.spellIndex);
    }

    private int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }
}

