/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryParser;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryBuilder;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.exoplatform.services.jcr.impl.core.query.lucene.WorkspaceTraversalResult;
import org.exoplatform.services.log.ExoLogger;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Log log = ExoLogger.getLogger(QueryImpl.class);
    protected final QueryRootNode allNodesQueryNode;
    protected final QueryRootNode root;

    public QueryImpl(SessionImpl session, SessionDataManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(session, itemMgr, index, propReg);
        this.root = QueryParser.parse(statement, language, session.getLocationFactory(), factory);
        this.allNodesQueryNode = QueryImpl.createMatchAllNodesQuery(factory);
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing query: \n" + this.root.dump()));
        }
        if (this.allNodesQueryNode.equals(this.root)) {
            return new WorkspaceTraversalResult(this.session, new InternalQName[]{Constants.JCR_PRIMARYTYPE, Constants.JCR_PATH, Constants.JCR_SCORE}, this.session.getLocationFactory());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.index.getIndexFormatVersion());
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        InternalQName[] orderProperties = new InternalQName[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getProperty();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        return new QueryResultImpl(this.index, this.itemMgr, this.session.getLocationFactory(), this.session.getValueFactory(), this.session.getAccessManager(), this.session.getUserID(), this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getSelectProperties(), orderProperties, ascSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    protected InternalQName[] getSelectProperties() throws RepositoryException {
        ArrayList<InternalQName> selectProps = new ArrayList<InternalQName>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final InternalQName[] ntName = new InternalQName[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(AndQueryNode node, Object data) {
                    return node.acceptOperands(this, data);
                }

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = Constants.NT_BASE;
            }
            ExtendedNodeType nt = this.session.getWorkspace().getNodeTypeManager().getNodeType(ntName[0]);
            PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinitionImpl propDef = (PropertyDefinitionImpl)propDefs[i];
                if (propDef.isResidualSet() || propDef.isMultiple()) continue;
                selectProps.add(propDef.getQName());
            }
        }
        if (!selectProps.contains((Object)Constants.JCR_PATH)) {
            selectProps.add(Constants.JCR_PATH);
        }
        if (!selectProps.contains((Object)Constants.JCR_SCORE)) {
            selectProps.add(Constants.JCR_SCORE);
        }
        return selectProps.toArray(new InternalQName[selectProps.size()]);
    }

    public boolean needsSystemTree() {
        return this.root.needsSystemTree();
    }

    private static QueryRootNode createMatchAllNodesQuery(QueryNodeFactory factory) {
        QueryRootNode allNodesQueryNode = factory.createQueryRootNode();
        PathQueryNode pathNode = factory.createPathQueryNode(allNodesQueryNode);
        LocationStepQueryNode lsNode = factory.createLocationStepQueryNode(pathNode);
        lsNode.setNameTest(null);
        lsNode.setIncludeDescendants(true);
        pathNode.addPathStep(lsNode);
        pathNode.setAbsolute(true);
        allNodesQueryNode.setLocationNode(pathNode);
        return allNodesQueryNode;
    }
}

