/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.HighlightingExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.log.ExoLogger;

class RowIteratorImpl
implements RowIterator {
    private static final Log log = ExoLogger.getLogger(RowIteratorImpl.class);
    private static final String EXCERPT_FUNC_LPAR = "excerpt(";
    private static final String SPELLCHECK_FUNC_LPAR = "spellcheck(";
    private static final InternalQName REP_EXCERPT_LPAR = new InternalQName("internal", "excerpt(");
    private final ScoreNodeIterator nodes;
    private final InternalQName[] properties;
    private final LocationFactory resolver;
    private final ExcerptProvider excerptProvider;
    private final SpellSuggestion spellSuggestion;
    private final ValueFactory vfactory;

    RowIteratorImpl(ScoreNodeIterator nodes, InternalQName[] properties, LocationFactory resolver, ValueFactory vFactory) {
        this(nodes, properties, resolver, null, null, vFactory);
    }

    RowIteratorImpl(ScoreNodeIterator nodes, InternalQName[] properties, LocationFactory resolver, ExcerptProvider exProvider, SpellSuggestion spellSuggestion, ValueFactory vFactory) {
        this.nodes = nodes;
        this.properties = properties;
        this.resolver = resolver;
        this.excerptProvider = exProvider;
        this.spellSuggestion = spellSuggestion;
        this.vfactory = vFactory;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.nodes.getScore(), this.nodes.nextNodeImpl());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.nodes.skip(skipNum);
    }

    public long getSize() {
        return this.nodes.getSize();
    }

    public long getPosition() {
        return this.nodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.nodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private final NodeImpl node;
        private Value[] values;
        private Set propertySet;

        RowImpl(float score, NodeImpl node) {
            this.score = score;
            this.node = node;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    String propertyName = RowIteratorImpl.this.resolver.createJCRName(RowIteratorImpl.this.properties[i]).getAsString();
                    if (this.node.hasProperty(propertyName)) {
                        PropertyImpl prop = (PropertyImpl)this.node.getProperty(propertyName);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = RowIteratorImpl.this.vfactory.createValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = Constants.JCR_PATH.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.vfactory.createValue(this.node.getPath(), 8) : (Constants.JCR_SCORE.equals((Object)RowIteratorImpl.this.properties[i]) ? RowIteratorImpl.this.vfactory.createValue((long)Math.round(this.score * 1000.0f)) : (this.isExcerptFunction(RowIteratorImpl.this.properties[i]) ? this.getExcerpt() : (this.isSpellCheckFunction(RowIteratorImpl.this.properties[i]) ? this.getSpellCheckedStatement() : null)));
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (this.propertySet == null) {
                HashSet<InternalQName> tmp = new HashSet<InternalQName>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                this.propertySet = tmp;
            }
            try {
                InternalQName prop = RowIteratorImpl.this.resolver.parseJCRName(propertyName).getInternalName();
                if (!this.propertySet.contains((Object)prop)) {
                    if (this.isExcerptFunction(propertyName)) {
                        return this.getExcerpt(propertyName);
                    }
                    throw new ItemNotFoundException(propertyName);
                }
                if (this.node.hasProperty(propertyName)) {
                    Property p = this.node.getProperty(propertyName);
                    if (p.getDefinition().getRequiredType() == 0) {
                        return RowIteratorImpl.this.vfactory.createValue(p.getString());
                    }
                    return p.getValue();
                }
                if (Constants.JCR_PATH.equals((Object)prop)) {
                    return RowIteratorImpl.this.vfactory.createValue(this.node.getPath(), 8);
                }
                if (Constants.JCR_SCORE.equals((Object)prop)) {
                    return RowIteratorImpl.this.vfactory.createValue((long)Math.round(this.score * 1000.0f));
                }
                if (this.isExcerptFunction(prop)) {
                    return this.getExcerpt();
                }
                if (this.isSpellCheckFunction(prop)) {
                    return this.getSpellCheckedStatement();
                }
                return null;
            }
            catch (RepositoryException e) {
                if (this.isExcerptFunction(propertyName)) {
                    return this.getExcerpt(propertyName);
                }
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }

        private boolean isExcerptFunction(InternalQName name) {
            return name.getNamespace().equals("internal") && name.getName().startsWith(RowIteratorImpl.EXCERPT_FUNC_LPAR);
        }

        private boolean isExcerptFunction(String name) {
            try {
                return name.startsWith(RowIteratorImpl.this.resolver.createJCRName(REP_EXCERPT_LPAR).getAsString());
            }
            catch (RepositoryException e) {
                return false;
            }
        }

        private Value getExcerpt() {
            return this.createExcerpt(this.node.getInternalIdentifier());
        }

        private Value getExcerpt(String excerptCall) throws RepositoryException {
            int idx = excerptCall.indexOf(RowIteratorImpl.EXCERPT_FUNC_LPAR);
            int end = excerptCall.lastIndexOf(41);
            if (end == -1) {
                throw new RepositoryException("Missing right parenthesis");
            }
            String pathStr = excerptCall.substring(idx + RowIteratorImpl.EXCERPT_FUNC_LPAR.length(), end).trim();
            String decodedPath = ISO9075.decode(pathStr);
            try {
                NodeImpl n = (NodeImpl)this.node.getNode(decodedPath);
                return this.createExcerpt(n.getInternalIdentifier());
            }
            catch (PathNotFoundException e) {
                try {
                    Property p = this.node.getProperty(decodedPath);
                    return this.highlight(p.getValue().getString());
                }
                catch (PathNotFoundException e1) {
                    return null;
                }
            }
        }

        private Value createExcerpt(String id) {
            if (RowIteratorImpl.this.excerptProvider == null) {
                return null;
            }
            try {
                long time = System.currentTimeMillis();
                String excerpt = RowIteratorImpl.this.excerptProvider.getExcerpt(id, 3, 150);
                time = System.currentTimeMillis() - time;
                log.debug((Object)("Created excerpt in " + new Long(time) + " ms."));
                if (excerpt != null) {
                    return RowIteratorImpl.this.vfactory.createValue(excerpt);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        private Value highlight(String text) {
            if (!(RowIteratorImpl.this.excerptProvider instanceof HighlightingExcerptProvider)) {
                return null;
            }
            HighlightingExcerptProvider hep = (HighlightingExcerptProvider)RowIteratorImpl.this.excerptProvider;
            try {
                long time = System.currentTimeMillis();
                text = hep.highlight(text);
                time = System.currentTimeMillis() - time;
                log.debug((Object)("Highlighted text in " + new Long(time) + " ms."));
                return RowIteratorImpl.this.vfactory.createValue(text);
            }
            catch (IOException e) {
                return null;
            }
        }

        private boolean isSpellCheckFunction(InternalQName name) {
            return name.getNamespace().equals("internal") && name.getName().startsWith(RowIteratorImpl.SPELLCHECK_FUNC_LPAR);
        }

        private Value getSpellCheckedStatement() {
            String v = null;
            if (RowIteratorImpl.this.spellSuggestion != null) {
                try {
                    v = RowIteratorImpl.this.spellSuggestion.getSuggestion();
                }
                catch (IOException e) {
                    log.warn((Object)"Spell checking failed", (Throwable)e);
                }
            }
            if (v != null) {
                return RowIteratorImpl.this.vfactory.createValue(v);
            }
            return null;
        }
    }
}

