/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataPersister {
    public static Log log = ExoLogger.getLogger((String)"jcr.NodeTypeDataPersister");
    private DataManager dataManager;
    private PlainChangesLog changesLog;
    private NodeData ntRoot;
    private ValueFactoryImpl valueFactory = null;
    private LocationFactory locationFactory;

    public NodeTypeDataPersister(DataManager dataManager, ValueFactoryImpl valueFactory, LocationFactory locationFactory) {
        this.dataManager = dataManager;
        this.valueFactory = valueFactory;
        this.locationFactory = locationFactory;
        this.changesLog = new PlainChangesLogImpl();
        try {
            NodeData jcrSystem = (NodeData)dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.ntRoot = (NodeData)dataManager.getItemData(jcrSystem, new QPathEntry(Constants.JCR_NODETYPES, 1));
            }
        }
        catch (RepositoryException e) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized.");
        }
    }

    boolean isInitialized() {
        return this.ntRoot != null;
    }

    private InternalQName parseName(String name) throws RepositoryException {
        return this.locationFactory.parseJCRName(name).getInternalName();
    }

    void saveChanges() throws RepositoryException, InvalidItemStateException {
        this.dataManager.save(new TransactionChangesLog(this.changesLog));
        this.changesLog.clear();
    }

    public synchronized void initNodetypesRoot(NodeData nsSystem, boolean addACL) {
        if (this.ntRoot == null) {
            long start = System.currentTimeMillis();
            TransientNodeData jcrNodetypes = TransientNodeData.createNodeData(nsSystem, Constants.JCR_NODETYPES, Constants.NT_UNSTRUCTURED, "00exo0jcr0node0types0root0uuid00");
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData(jcrNodetypes, Constants.JCR_PRIMARYTYPE, 7, false);
            primaryType.setValue(new TransientValueData(jcrNodetypes.getPrimaryTypeName()));
            this.changesLog.add(ItemState.createAddedState(jcrNodetypes)).add(ItemState.createAddedState(primaryType));
            if (addACL) {
                AccessControlList acl = new AccessControlList();
                InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
                jcrNodetypes.setMixinTypeNames(mixins);
                ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
                for (InternalQName mixin : mixins) {
                    mixValues.add(new TransientValueData(mixin));
                }
                TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.JCR_MIXINTYPES, 7, true, mixValues);
                TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
                ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
                for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                    AccessControlEntry entry = acl.getPermissionEntries().get(i);
                    permsValues.add(new TransientValueData(entry));
                }
                TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)jcrNodetypes, Constants.EXO_PERMISSIONS, 100, true, permsValues);
                this.changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
                this.changesLog.add(new ItemState(jcrNodetypes, 16, false, null));
            }
            this.ntRoot = jcrNodetypes;
            if (log.isDebugEnabled()) {
                log.debug((Object)("/jcr:system/jcr:nodetypes is created, creation time: " + (System.currentTimeMillis() - start) + " ms"));
            }
        } else {
            log.warn((Object)"/jcr:system/jcr:nodetypes already exists");
        }
    }

    public synchronized void initStorage(List<NodeType> nodetypes) throws PathNotFoundException, RepositoryException {
        if (!this.isInitialized()) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not exists. Possible is not initialized (call initNodetypesRoot() before)");
            return;
        }
        long ntStart = System.currentTimeMillis();
        for (NodeType nt : nodetypes) {
            try {
                this.addNodeType(nt);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Node type " + nt.getName() + " is initialized. "));
            }
            catch (ItemExistsException e) {
                log.warn((Object)("Node exists " + nt.getName() + ". Error: " + e.getMessage()));
            }
        }
        this.saveChanges();
        log.info((Object)("Node types initialized. Time: " + (System.currentTimeMillis() - ntStart) + " ms"));
    }

    public boolean hasNodeTypeData(String nodeTypeName) throws RepositoryException {
        return this.hasNodeTypeData(this.parseName(nodeTypeName));
    }

    public boolean hasNodeTypeData(InternalQName nodeTypeName) throws RepositoryException {
        try {
            return this.getNodeTypesData(nodeTypeName).size() > 0;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    private List<NodeDataReader> getNodeTypesData(InternalQName nodeTypeName) throws RepositoryException {
        NodeDataReader ntReader = new NodeDataReader(this.ntRoot, this.dataManager, this.valueFactory);
        ntReader.forNode(nodeTypeName);
        ntReader.read();
        ntReader.getNodes(nodeTypeName);
        return ntReader.getNodes(nodeTypeName);
    }

    public NodeData addNodeType(NodeType nodeType) throws PathNotFoundException, RepositoryException, ValueFormatException {
        int i;
        if (!this.isInitialized()) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized.");
            return null;
        }
        TransientNodeData ntNode = TransientNodeData.createNodeData(this.ntRoot, this.parseName(nodeType.getName()), Constants.NT_NODETYPE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(ntNode.getPrimaryTypeName()));
        TransientPropertyData name = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_NODETYPENAME, 7, false);
        name.setValue(new TransientValueData(this.parseName(nodeType.getName())));
        TransientPropertyData isMixin = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_ISMIXIN, 6, false);
        isMixin.setValue(new TransientValueData(nodeType.isMixin()));
        TransientPropertyData hasOrderableChildNodes = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_HASORDERABLECHILDNODES, 6, false);
        hasOrderableChildNodes.setValue(new TransientValueData(nodeType.hasOrderableChildNodes()));
        this.changesLog.add(ItemState.createAddedState(ntNode)).add(ItemState.createAddedState(primaryType)).add(ItemState.createAddedState(name)).add(ItemState.createAddedState(isMixin)).add(ItemState.createAddedState(hasOrderableChildNodes));
        if (nodeType.getPrimaryItemName() != null) {
            TransientPropertyData primaryItemName = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_PRIMARYITEMNAME, 7, false);
            primaryItemName.setValue(new TransientValueData(this.parseName(nodeType.getPrimaryItemName())));
            this.changesLog.add(ItemState.createAddedState(primaryItemName));
        }
        ArrayList<ValueData> parents = new ArrayList<ValueData>();
        for (i = 0; i < nodeType.getDeclaredSupertypes().length; ++i) {
            parents.add(new TransientValueData(this.parseName(nodeType.getDeclaredSupertypes()[i].getName())));
        }
        if (parents.size() != 0) {
            TransientPropertyData supertypes = TransientPropertyData.createPropertyData(ntNode, Constants.JCR_SUPERTYPES, 7, true);
            supertypes.setValues(parents);
            this.changesLog.add(ItemState.createAddedState(supertypes));
        }
        if (nodeType.getDeclaredPropertyDefinitions().length > 0) {
            for (i = 0; i < nodeType.getDeclaredPropertyDefinitions().length; ++i) {
                TransientNodeData childProps = TransientNodeData.createNodeData((NodeData)ntNode, Constants.JCR_PROPERTYDEFINITION, Constants.NT_PROPERTYDEFINITION, i + 1);
                TransientPropertyData cpPrimaryType = TransientPropertyData.createPropertyData(childProps, Constants.JCR_PRIMARYTYPE, 7, false);
                cpPrimaryType.setValue(new TransientValueData(childProps.getPrimaryTypeName()));
                this.changesLog.add(ItemState.createAddedState(childProps)).add(ItemState.createAddedState(cpPrimaryType));
                this.initPropertyDefProps(childProps, nodeType.getDeclaredPropertyDefinitions()[i]);
            }
        }
        if (nodeType.getDeclaredChildNodeDefinitions().length > 0) {
            for (i = 0; i < nodeType.getDeclaredChildNodeDefinitions().length; ++i) {
                TransientNodeData childNodes = TransientNodeData.createNodeData((NodeData)ntNode, Constants.JCR_CHILDNODEDEFINITION, Constants.NT_CHILDNODEDEFINITION, i + 1);
                TransientPropertyData cnPrimaryType = TransientPropertyData.createPropertyData(childNodes, Constants.JCR_PRIMARYTYPE, 7, false);
                cnPrimaryType.setValue(new TransientValueData(childNodes.getPrimaryTypeName()));
                this.changesLog.add(ItemState.createAddedState(childNodes)).add(ItemState.createAddedState(cnPrimaryType));
                this.initNodeDefProps(childNodes, nodeType.getDeclaredChildNodeDefinitions()[i]);
            }
        }
        return ntNode;
    }

    private void initPropertyDefProps(NodeData parent, PropertyDefinition def) throws ValueFormatException, RepositoryException {
        if (def.getName() != null) {
            TransientPropertyData name = TransientPropertyData.createPropertyData(parent, Constants.JCR_NAME, 7, false);
            name.setValue(new TransientValueData(this.parseName(def.getName())));
            this.changesLog.add(ItemState.createAddedState(name));
        }
        TransientPropertyData autoCreated = TransientPropertyData.createPropertyData(parent, Constants.JCR_AUTOCREATED, 6, false);
        autoCreated.setValue(new TransientValueData(def.isAutoCreated()));
        TransientPropertyData isMandatory = TransientPropertyData.createPropertyData(parent, Constants.JCR_MANDATORY, 6, false);
        isMandatory.setValue(new TransientValueData(def.isMandatory()));
        TransientPropertyData onParentVersion = TransientPropertyData.createPropertyData(parent, Constants.JCR_ONPARENTVERSION, 1, false);
        onParentVersion.setValue(new TransientValueData(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion())));
        TransientPropertyData isProtected = TransientPropertyData.createPropertyData(parent, Constants.JCR_PROTECTED, 6, false);
        isProtected.setValue(new TransientValueData(def.isProtected()));
        TransientPropertyData requiredType = TransientPropertyData.createPropertyData(parent, Constants.JCR_REQUIREDTYPE, 1, false);
        requiredType.setValue(new TransientValueData(ExtendedPropertyType.nameFromValue(def.getRequiredType())));
        TransientPropertyData isMultiple = TransientPropertyData.createPropertyData(parent, Constants.JCR_MULTIPLE, 6, false);
        isMultiple.setValue(new TransientValueData(def.isMultiple()));
        this.changesLog.add(ItemState.createAddedState(autoCreated)).add(ItemState.createAddedState(isMandatory)).add(ItemState.createAddedState(onParentVersion)).add(ItemState.createAddedState(isProtected)).add(ItemState.createAddedState(requiredType)).add(ItemState.createAddedState(isMultiple));
        if (def.getValueConstraints() != null && def.getValueConstraints().length != 0) {
            ArrayList<ValueData> valueConstraintsValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getValueConstraints().length; ++i) {
                valueConstraintsValues.add(new TransientValueData(def.getValueConstraints()[i]));
            }
            TransientPropertyData valueConstraints = TransientPropertyData.createPropertyData(parent, Constants.JCR_VALUECONSTRAINTS, 1, true);
            valueConstraints.setValues(valueConstraintsValues);
            this.changesLog.add(ItemState.createAddedState(valueConstraints));
        }
        if (def.getDefaultValues() != null && def.getDefaultValues().length != 0) {
            ArrayList<ValueData> defaultValuesValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getDefaultValues().length; ++i) {
                if (def.getDefaultValues()[i] == null) continue;
                defaultValuesValues.add(new TransientValueData(def.getDefaultValues()[i].getString()));
            }
            TransientPropertyData defaultValues = TransientPropertyData.createPropertyData(parent, Constants.JCR_DEFAULTVALUES, 1, true);
            defaultValues.setValues(defaultValuesValues);
            this.changesLog.add(ItemState.createAddedState(defaultValues));
        }
    }

    private void initNodeDefProps(NodeData parent, NodeDefinition def) throws ValueFormatException, RepositoryException {
        if (def.getName() != null) {
            TransientPropertyData name = TransientPropertyData.createPropertyData(parent, Constants.JCR_NAME, 7, false);
            name.setValue(new TransientValueData(this.parseName(def.getName())));
            this.changesLog.add(ItemState.createAddedState(name));
        }
        TransientPropertyData autoCreated = TransientPropertyData.createPropertyData(parent, Constants.JCR_AUTOCREATED, 6, false);
        autoCreated.setValue(new TransientValueData(def.isAutoCreated()));
        TransientPropertyData isMandatory = TransientPropertyData.createPropertyData(parent, Constants.JCR_MANDATORY, 6, false);
        isMandatory.setValue(new TransientValueData(def.isMandatory()));
        TransientPropertyData onParentVersion = TransientPropertyData.createPropertyData(parent, Constants.JCR_ONPARENTVERSION, 1, false);
        onParentVersion.setValue(new TransientValueData(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion())));
        TransientPropertyData isProtected = TransientPropertyData.createPropertyData(parent, Constants.JCR_PROTECTED, 6, false);
        isProtected.setValue(new TransientValueData(def.isProtected()));
        TransientPropertyData sameNameSiblings = TransientPropertyData.createPropertyData(parent, Constants.JCR_SAMENAMESIBLINGS, 6, false);
        sameNameSiblings.setValue(new TransientValueData(def.allowsSameNameSiblings()));
        if (def.getDefaultPrimaryType() != null) {
            TransientPropertyData defaultPrimaryType = TransientPropertyData.createPropertyData(parent, Constants.JCR_DEFAULTPRIMNARYTYPE, 7, false);
            defaultPrimaryType.setValue(new TransientValueData(this.parseName(def.getDefaultPrimaryType().getName())));
            this.changesLog.add(ItemState.createAddedState(defaultPrimaryType));
        }
        this.changesLog.add(ItemState.createAddedState(autoCreated)).add(ItemState.createAddedState(isMandatory)).add(ItemState.createAddedState(onParentVersion)).add(ItemState.createAddedState(isProtected)).add(ItemState.createAddedState(sameNameSiblings));
        if (def.getRequiredPrimaryTypes() != null && def.getRequiredPrimaryTypes().length != 0) {
            ArrayList<ValueData> requiredPrimaryTypesValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getRequiredPrimaryTypes().length; ++i) {
                requiredPrimaryTypesValues.add(new TransientValueData(this.parseName(def.getRequiredPrimaryTypes()[i].getName())));
            }
            TransientPropertyData requiredPrimaryTypes = TransientPropertyData.createPropertyData(parent, Constants.JCR_REQUIREDPRIMARYTYPES, 7, true);
            requiredPrimaryTypes.setValues(requiredPrimaryTypesValues);
            this.changesLog.add(ItemState.createAddedState(requiredPrimaryTypes));
        }
    }

    private NodeType findType(String nodeTypeName, List<NodeType> ntList) {
        for (NodeType regNt : ntList) {
            if (!regNt.getName().equals(nodeTypeName)) continue;
            return regNt;
        }
        return null;
    }

    public List<NodeType> loadNodetypes(List<NodeType> registeredNodeTypes, NodeTypeManagerImpl ntManager) throws PathNotFoundException, RepositoryException {
        if (!this.isInitialized()) {
            NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.ntRoot = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.JCR_NODETYPES, 1));
            } else {
                throw new RepositoryException("jcr:system is not found. Possible the workspace is not initialized properly");
            }
        }
        if (this.isInitialized()) {
            ArrayList<NodeType> ntList = new ArrayList<NodeType>();
            ArrayList<NodeType> loadedList = new ArrayList<NodeType>();
            ntList.addAll(registeredNodeTypes);
            boolean nextCycle = false;
            ArrayList<NodeType> registeringTypes = new ArrayList<NodeType>();
            int registerCyclesCount = 1;
            do {
                long cycleStart = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> Node types registration cycle " + registerCyclesCount + " started"));
                }
                NodeDataReader ntReader = new NodeDataReader(this.ntRoot, this.dataManager, this.valueFactory);
                ntReader.forNodesByType(Constants.NT_NODETYPE);
                ntReader.read();
                block19: for (NodeDataReader ntr : ntReader.getNodesByType(Constants.NT_NODETYPE)) {
                    long ntStart = System.currentTimeMillis();
                    ntr.forProperty(Constants.JCR_NODETYPENAME, 7);
                    ntr.read();
                    String ntName = ntr.getPropertyValue(Constants.JCR_NODETYPENAME).getString();
                    NodeType existedNodeType = this.findType(ntName, ntList);
                    if (existedNodeType != null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Already reagistered " + ntName));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reagistering from storage " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                    }
                    ntr.forProperty(Constants.JCR_PRIMARYTYPE, 7).forProperty(Constants.JCR_ISMIXIN, 6).forProperty(Constants.JCR_HASORDERABLECHILDNODES, 6).forProperty(Constants.JCR_PRIMARYITEMNAME, 7).forProperty(Constants.JCR_SUPERTYPES, 7);
                    ntr.forNodesByType(Constants.NT_PROPERTYDEFINITION).forNodesByType(Constants.NT_CHILDNODEDEFINITION);
                    ntr.read();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Node type readed " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                    }
                    NodeTypeImpl type = new NodeTypeImpl(ntManager);
                    type.setName(ntr.getPropertyValue(Constants.JCR_NODETYPENAME).getString());
                    type.setMixin(ntr.getPropertyValue(Constants.JCR_ISMIXIN).getBoolean());
                    type.setOrderableChild(ntr.getPropertyValue(Constants.JCR_HASORDERABLECHILDNODES).getBoolean());
                    try {
                        type.setPrimaryItemName(ntr.getPropertyValue(Constants.JCR_PRIMARYITEMNAME).getString());
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    if (!registeringTypes.contains(type)) {
                        registeringTypes.add(type);
                    }
                    try {
                        List<Value> dst = ntr.getPropertyValues(Constants.JCR_SUPERTYPES);
                        NodeType[] declaredSupertypes = new NodeType[dst.size()];
                        for (int i = 0; i < dst.size(); ++i) {
                            String superTypeName = dst.get(i).getString();
                            declaredSupertypes[i] = this.findType(superTypeName, ntList);
                            if (declaredSupertypes[i] != null) continue;
                            if (nextCycle && this.findType(superTypeName, registeringTypes) == null) {
                                throw new ConstraintViolationException("Supertype " + superTypeName + " is not registered in repository (but need to be registered before nodetype " + type.getName() + "). Node type registration aborted.");
                            }
                            if (!log.isDebugEnabled()) continue block19;
                            log.debug((Object)("Supertype " + superTypeName + " is not registered. " + type.getName() + " node type will be registered in a next cycle."));
                            continue block19;
                        }
                        type.setDeclaredSupertypes(declaredSupertypes);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Property definitions for " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                    }
                    try {
                        List<NodeDataReader> pdNodes = ntr.getNodesByType(Constants.NT_PROPERTYDEFINITION);
                        PropertyDefinition[] declaredPropertyDefs = new PropertyDefinition[pdNodes.size()];
                        for (int pdi = 0; pdi < pdNodes.size(); ++pdi) {
                            NodeDataReader pdr = pdNodes.get(pdi);
                            pdr.forProperty(Constants.JCR_NAME, 7).forProperty(Constants.JCR_AUTOCREATED, 6).forProperty(Constants.JCR_MANDATORY, 6).forProperty(Constants.JCR_PROTECTED, 6).forProperty(Constants.JCR_MULTIPLE, 6).forProperty(Constants.JCR_ONPARENTVERSION, 1).forProperty(Constants.JCR_REQUIREDTYPE, 1).forProperty(Constants.JCR_VALUECONSTRAINTS, 1).forProperty(Constants.JCR_DEFAULTVALUES, 1);
                            pdr.read();
                            String[] valueConstraints = null;
                            try {
                                List<Value> valueConstraintValues = pdr.getPropertyValues(Constants.JCR_VALUECONSTRAINTS);
                                valueConstraints = new String[valueConstraintValues.size()];
                                for (int j = 0; j < valueConstraintValues.size(); ++j) {
                                    valueConstraints[j] = valueConstraintValues.get(j) != null ? valueConstraintValues.get(j).getString() : null;
                                }
                            }
                            catch (PathNotFoundException e) {
                                // empty catch block
                            }
                            Value[] defaultValues = null;
                            try {
                                List<Value> dvl = pdr.getPropertyValues(Constants.JCR_DEFAULTVALUES);
                                defaultValues = new Value[dvl.size()];
                                for (int i = 0; i < dvl.size(); ++i) {
                                    defaultValues[i] = dvl.get(i);
                                }
                            }
                            catch (PathNotFoundException e) {
                                // empty catch block
                            }
                            NameValue nameValue = (NameValue)pdr.getPropertyValue(Constants.JCR_NAME);
                            PropertyDefinitionImpl pDef = new PropertyDefinitionImpl(nameValue.getString(), type, ExtendedPropertyType.valueFromName(pdr.getPropertyValue(Constants.JCR_REQUIREDTYPE).getString()), valueConstraints, defaultValues, pdr.getPropertyValue(Constants.JCR_AUTOCREATED).getBoolean(), pdr.getPropertyValue(Constants.JCR_MANDATORY).getBoolean(), OnParentVersionAction.valueFromName((String)pdr.getPropertyValue(Constants.JCR_ONPARENTVERSION).getString()), pdr.getPropertyValue(Constants.JCR_PROTECTED).getBoolean(), pdr.getPropertyValue(Constants.JCR_MULTIPLE).getBoolean(), nameValue.getQName());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Property definitions readed " + pDef.getName() + " " + (System.currentTimeMillis() - ntStart)));
                            }
                            declaredPropertyDefs[pdi] = pDef;
                        }
                        type.setDeclaredPropertyDefs(declaredPropertyDefs);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Child nodes definitions for " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                    }
                    try {
                        List<NodeDataReader> cdNodes = ntr.getNodesByType(Constants.NT_CHILDNODEDEFINITION);
                        NodeDefinition[] declaredChildNodesDefs = new NodeDefinition[cdNodes.size()];
                        for (int cdi = 0; cdi < cdNodes.size(); ++cdi) {
                            NodeDefinitionImpl nDef;
                            NodeDataReader cdr;
                            block48: {
                                cdr = cdNodes.get(cdi);
                                cdr.forProperty(Constants.JCR_NAME, 7).forProperty(Constants.JCR_REQUIREDPRIMARYTYPES, 7).forProperty(Constants.JCR_AUTOCREATED, 6).forProperty(Constants.JCR_MANDATORY, 6).forProperty(Constants.JCR_PROTECTED, 6).forProperty(Constants.JCR_ONPARENTVERSION, 1).forProperty(Constants.JCR_SAMENAMESIBLINGS, 1).forProperty(Constants.JCR_DEFAULTPRIMNARYTYPE, 7);
                                cdr.read();
                                nDef = null;
                                try {
                                    NameValue nameValue = (NameValue)cdr.getPropertyValue(Constants.JCR_NAME);
                                    nDef = new NodeDefinitionImpl(nameValue.getString(), nameValue.getQName());
                                }
                                catch (PathNotFoundException e) {
                                    // empty catch block
                                }
                                try {
                                    String defaultNodeTypeName = cdr.getPropertyValue(Constants.JCR_DEFAULTPRIMNARYTYPE).getString();
                                    NodeType defaultNodeType = this.findType(defaultNodeTypeName, ntList);
                                    if (defaultNodeType != null) {
                                        nDef.setDefaultNodeType(defaultNodeType);
                                        break block48;
                                    }
                                    if (defaultNodeType == null && defaultNodeTypeName.equals(type.getName())) {
                                        nDef.setDefaultNodeType(type);
                                        break block48;
                                    }
                                    if (nextCycle && this.findType(defaultNodeTypeName, registeringTypes) == null) {
                                        throw new ConstraintViolationException("Default primary node type of NodeDefinition " + nDef.getName() + " is not registered in repository. Default primary node type " + defaultNodeTypeName + " must be registered before " + type.getName() + ". Node types registration aborted.");
                                    }
                                    if (!log.isDebugEnabled()) continue block19;
                                    log.debug((Object)("Default primary node type of NodeDefinition " + nDef.getName() + " is not registered." + type.getName() + " node type will be registered in a next cycle."));
                                    continue block19;
                                }
                                catch (PathNotFoundException e) {
                                    // empty catch block
                                }
                            }
                            try {
                                List<Value> requiredNodeTypesValues = cdr.getPropertyValues(Constants.JCR_REQUIREDPRIMARYTYPES);
                                NodeType[] requiredNodeTypes = new NodeType[requiredNodeTypesValues.size()];
                                for (int j = 0; j < requiredNodeTypesValues.size(); ++j) {
                                    NodeType requiredNodeType;
                                    if (requiredNodeTypesValues.get(j) != null) {
                                        String requiredNodeTypeName = requiredNodeTypesValues.get(j).getString();
                                        requiredNodeType = this.findType(requiredNodeTypeName, ntList);
                                        if (requiredNodeType == null) {
                                            if (nextCycle && this.findType(requiredNodeTypeName, registeringTypes) == null) {
                                                throw new ConstraintViolationException("Required node type of NodeDefinition " + nDef.getName() + " is not registered in repository. Required node type " + requiredNodeTypeName + " must be registered before " + type.getName() + ". Node type resistration aborted.");
                                            }
                                            if (!log.isDebugEnabled()) continue block19;
                                            log.debug((Object)("Required node type of NodeDefinition " + nDef.getName() + " is not registered." + type.getName() + " node type will be registered in a next cycle."));
                                            continue block19;
                                        }
                                    } else {
                                        throw new ConstraintViolationException("Required node type is null. Type: " + type.getName() + ". NodeDefinition: " + nDef.getName() + ". Node type resistration aborted.");
                                    }
                                    requiredNodeTypes[j] = requiredNodeType;
                                }
                                nDef.setRequiredNodeTypes(requiredNodeTypes);
                                nDef.setDeclaringNodeType(type);
                                nDef.setAutoCreate(cdr.getPropertyValue(Constants.JCR_AUTOCREATED).getBoolean());
                                nDef.setMandatory(cdr.getPropertyValue(Constants.JCR_MANDATORY).getBoolean());
                                nDef.setReadOnly(cdr.getPropertyValue(Constants.JCR_PROTECTED).getBoolean());
                                nDef.setMultiple(cdr.getPropertyValue(Constants.JCR_SAMENAMESIBLINGS).getBoolean());
                                nDef.setOnVersion(OnParentVersionAction.valueFromName((String)cdr.getPropertyValue(Constants.JCR_ONPARENTVERSION).getString()));
                            }
                            catch (PathNotFoundException e) {
                                throw new ConstraintViolationException("Mandatory property did not set. NodeDefinition: " + nDef.getName() + ". Type: " + type.getName() + ". Error: " + e.getMessage() + ". Node type resistration aborted.", (Throwable)e);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Child nodes definitions readed " + nDef.getName() + " " + (System.currentTimeMillis() - ntStart)));
                            }
                            declaredChildNodesDefs[cdi] = nDef;
                        }
                        type.setDeclaredNodeDefs(declaredChildNodesDefs);
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                    ntList.add(type);
                    loadedList.add(type);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("NodeType " + type.getName() + " loaded. " + (System.currentTimeMillis() - ntStart) + " ms"));
                }
                nextCycle = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("<<< Node types registration cycle " + registerCyclesCount + " finished. " + (System.currentTimeMillis() - cycleStart) + " ms"));
                }
                if (++registerCyclesCount < 1000) continue;
                throw new RepositoryException("Maximum cycles count of NodeType registrations reached, 1000. Registration breaked.");
            } while (registeringTypes.size() > loadedList.size());
            return loadedList;
        }
        log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized. No nodetypes loaded.");
        return new ArrayList<NodeType>();
    }
}

