/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Calendar;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.log.ExoLogger;

public class NodeIndexer {
    private static final Log log = ExoLogger.getLogger(NodeIndexer.class);
    protected static final float DEFAULT_BOOST = 1.0f;
    protected final NodeData node;
    protected final ItemDataConsumer stateProvider;
    protected final NamespaceMappings mappings;
    protected final LocationFactory resolver;
    protected final DocumentReaderService extractor;
    protected IndexingConfiguration indexingConfig;
    protected boolean supportHighlighting = false;
    protected IndexFormatVersion indexFormatVersion = IndexFormatVersion.V1;
    private ValueFactoryImpl vFactory;

    public NodeIndexer(NodeData node, ItemDataConsumer stateProvider, NamespaceMappings mappings, DocumentReaderService extractor) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.resolver = new LocationFactory(mappings);
        this.extractor = extractor;
        this.vFactory = new ValueFactoryImpl(this.resolver);
    }

    public String getNodeId() {
        return this.node.getIdentifier();
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public void setIndexFormatVersion(IndexFormatVersion indexFormatVersion) {
        this.indexFormatVersion = indexFormatVersion;
    }

    public void setIndexingConfiguration(IndexingConfiguration config) {
        this.indexingConfig = config;
    }

    protected Document createDoc() throws RepositoryException {
        Document doc = new Document();
        doc.setBoost(this.getNodeBoost());
        doc.add((Fieldable)new Field(FieldNames.UUID, this.node.getIdentifier(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
        try {
            if (this.node.getParentIdentifier() == null) {
                doc.add((Fieldable)new Field(FieldNames.PARENT, "", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                doc.add((Fieldable)new Field(FieldNames.LABEL, "", Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            } else {
                doc.add((Fieldable)new Field(FieldNames.PARENT, this.node.getParentIdentifier(), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
                String name = this.resolver.createJCRName(this.node.getQPath().getName()).getAsString();
                doc.add((Fieldable)new Field(FieldNames.LABEL, name, Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO));
            }
        }
        catch (NamespaceException e) {
            // empty catch block
        }
        for (PropertyData prop : this.stateProvider.listChildPropertiesData(this.node)) {
            if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                this.addPropertyName(doc, prop.getQPath().getName());
            }
            this.addValues(doc, prop);
        }
        return doc;
    }

    private void addMVPName(Document doc, InternalQName name) throws RepositoryException {
        String propName = this.resolver.createJCRName(name).getAsString();
        doc.add((Fieldable)new Field(FieldNames.MVP, propName, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValues(Document doc, PropertyData prop) throws RepositoryException {
        int propType = prop.getType();
        String fieldName = this.resolver.createJCRName(prop.getQPath().getName()).getAsString();
        if (propType == 2) {
            PropertyData pmime;
            List<ValueData> data = null;
            if (this.node.getQPath().getName().equals((Object)Constants.JCR_CONTENT) && (pmime = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_MIMETYPE, 0))) != null) {
                try {
                    PropertyData encProp;
                    DocumentReader dreader = this.extractor.getDocumentReader(new String(pmime.getValues().get(0).getAsByteArray()));
                    List<ValueData> list = data = prop.getValues().size() > 0 ? prop.getValues() : ((PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_DATA, 0))).getValues();
                    if (data == null) {
                        log.warn((Object)("null value found at property " + prop.getQPath().getAsString()));
                    }
                    if ((encProp = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_ENCODING, 0))) != null) {
                        String encoding = new String(encProp.getValues().get(0).getAsByteArray());
                        for (ValueData pvd : data) {
                            Throwable e2;
                            Object var14_25;
                            InputStream is = null;
                            try {
                                is = pvd.getAsStream();
                                doc.add((Fieldable)this.createFulltextField(dreader.getContentAsText(is, encoding)));
                                var14_25 = null;
                            }
                            catch (Throwable throwable) {
                                var14_25 = null;
                                try {
                                    is.close();
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                is.close();
                            }
                            catch (Throwable e2) {}
                        }
                    } else {
                        for (ValueData pvd : data) {
                            Throwable e3;
                            Object var17_28;
                            InputStream is = null;
                            try {
                                is = pvd.getAsStream();
                                doc.add((Fieldable)this.createFulltextField(dreader.getContentAsText(is)));
                                var17_28 = null;
                            }
                            catch (Throwable throwable) {
                                var17_28 = null;
                                try {
                                    is.close();
                                }
                                catch (Throwable e3) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {
                                is.close();
                            }
                            catch (Throwable e3) {}
                        }
                    }
                    if (data.size() > 1) {
                        this.addMVPName(doc, prop.getQPath().getName());
                    }
                }
                catch (HandlerNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("This content is not readable " + (Object)((Object)e)));
                    }
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("Binary value indexer IO error " + e), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Binary value indexer error " + e), (Throwable)e);
                }
            }
        } else {
            try {
                List<ValueData> data;
                List<ValueData> list = data = prop.getValues().size() > 0 ? prop.getValues() : ((PropertyData)this.stateProvider.getItemData(prop.getIdentifier())).getValues();
                if (data == null) {
                    log.warn((Object)("null value found at property " + prop.getQPath().getAsString()));
                }
                ExtendedValue val = null;
                InternalQName name = prop.getQPath().getName();
                block29: for (ValueData value : data) {
                    val = (ExtendedValue)this.vFactory.loadValue(((AbstractValueData)value).createTransientCopy(), propType);
                    switch (propType) {
                        case 6: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addBooleanValue(doc, fieldName, val.getBoolean());
                            continue block29;
                        }
                        case 5: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addCalendarValue(doc, fieldName, val.getDate());
                            continue block29;
                        }
                        case 4: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addDoubleValue(doc, fieldName, new Double(val.getDouble()));
                            continue block29;
                        }
                        case 3: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addLongValue(doc, fieldName, new Long(val.getLong()));
                            continue block29;
                        }
                        case 9: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addReferenceValue(doc, fieldName, val.getString());
                            continue block29;
                        }
                        case 8: {
                            if (!this.isIndexed(name)) continue block29;
                            this.addPathValue(doc, fieldName, val.getString());
                            continue block29;
                        }
                        case 1: {
                            if (!this.isIndexed(name)) continue block29;
                            if (name.equals((Object)Constants.JCR_UUID)) {
                                this.addStringValue(doc, fieldName, val.getString(), false, false, 1.0f);
                                continue block29;
                            }
                            this.addStringValue(doc, fieldName, val.getString(), true, this.isIncludedInNodeIndex(name), this.getPropertyBoost(name));
                            continue block29;
                        }
                        case 7: {
                            if (!this.isIndexed(name) && !name.equals((Object)Constants.JCR_PRIMARYTYPE) && !name.equals((Object)Constants.JCR_MIXINTYPES)) continue block29;
                            this.addNameValue(doc, fieldName, val.getString());
                            continue block29;
                        }
                        case 100: {
                            continue block29;
                        }
                    }
                    throw new IllegalArgumentException("illegal internal value type " + propType);
                }
                if (data.size() > 1) {
                    this.addMVPName(doc, prop.getQPath().getName());
                }
            }
            catch (RepositoryException e) {
                throw new RepositoryException("Index of property value error. " + prop.getQPath().getAsString() + ". " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    @Deprecated
    private void addValue(Document doc, ValueData value, InternalQName name, int propertyType) throws ValueFormatException, IllegalStateException, RepositoryException {
        String fieldName = this.resolver.createJCRName(name).getAsString();
        ExtendedValue val = null;
        if (2 != propertyType) {
            val = (ExtendedValue)this.vFactory.loadValue(((AbstractValueData)value).createTransientCopy(), propertyType);
        }
        switch (propertyType) {
            case 2: {
                if (!this.isIndexed(name)) break;
                this.addBinaryValue(doc, fieldName, value);
                break;
            }
            case 6: {
                if (!this.isIndexed(name)) break;
                this.addBooleanValue(doc, fieldName, val.getBoolean());
                break;
            }
            case 5: {
                if (!this.isIndexed(name)) break;
                this.addCalendarValue(doc, fieldName, val.getDate());
                break;
            }
            case 4: {
                if (!this.isIndexed(name)) break;
                this.addDoubleValue(doc, fieldName, new Double(val.getDouble()));
                break;
            }
            case 3: {
                if (!this.isIndexed(name)) break;
                this.addLongValue(doc, fieldName, new Long(val.getLong()));
                break;
            }
            case 9: {
                if (!this.isIndexed(name)) break;
                this.addReferenceValue(doc, fieldName, val.getString());
                break;
            }
            case 8: {
                if (!this.isIndexed(name)) break;
                this.addPathValue(doc, fieldName, val.getString());
                break;
            }
            case 1: {
                if (!this.isIndexed(name)) break;
                if (name.equals((Object)Constants.JCR_UUID)) {
                    this.addStringValue(doc, fieldName, val.getString(), false, false, 1.0f);
                    break;
                }
                this.addStringValue(doc, fieldName, val.getString(), true, this.isIncludedInNodeIndex(name), this.getPropertyBoost(name));
                break;
            }
            case 7: {
                if (!this.isIndexed(name) && !name.equals((Object)Constants.JCR_PRIMARYTYPE) && !name.equals((Object)Constants.JCR_MIXINTYPES)) break;
                this.addNameValue(doc, fieldName, val.getString());
                break;
            }
            case 100: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal internal value type:" + ExtendedPropertyType.nameFromValue(propertyType));
            }
        }
    }

    private void addPropertyName(Document doc, InternalQName name) throws RepositoryException {
        String fieldName = this.resolver.createJCRName(name).getAsString();
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES_SET, fieldName, Field.Store.YES, Field.Index.NO_NORMS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void addBinaryValue(Document doc, String fieldName, ValueData internalValue) throws RepositoryException {
        if (this.node.getQPath().getName().equals((Object)Constants.JCR_CONTENT)) {
            String text;
            block16: {
                try {
                    PropertyData prop = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_MIMETYPE, 0));
                    if (prop != null) {
                        List<ValueData> values = prop.getValues();
                        ValueData mimeValue = values.get(0);
                        String mime = new String(mimeValue.getAsByteArray());
                        DocumentReader dreader = this.extractor.getDocumentReader(mime);
                        InputStream is = null;
                        try {
                            is = internalValue.getAsStream();
                            PropertyData encProp = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_ENCODING, 0));
                            if (encProp != null) {
                                ValueData encValue = encProp.getValues().get(0);
                                text = dreader.getContentAsText(is, new String(encValue.getAsByteArray()));
                            } else {
                                text = dreader.getContentAsText(is);
                            }
                            Object var14_16 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_17 = null;
                            try {
                                is.close();
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (Throwable e) {}
                        break block16;
                    }
                    text = null;
                }
                catch (HandlerNotFoundException e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("This content is not readable " + (Object)((Object)e)));
                    }
                    text = null;
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.warn((Object)("Binary value indexer IO error " + e), (Throwable)e);
                    }
                    text = null;
                }
                catch (Exception e) {
                    log.error((Object)("Binary value indexer error " + e), (Throwable)e);
                    text = null;
                }
            }
            if (text != null) {
                doc.add((Fieldable)this.createFulltextField(text));
            }
        }
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), false));
    }

    protected Field createFieldWithoutNorms(String fieldName, String internalValue, boolean store) {
        Field field = new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue), Field.Store.YES, Field.Index.NO_NORMS, Field.TermVector.NO);
        return field;
    }

    protected void addCalendarValue(Document doc, String fieldName, Object internalValue) {
        Calendar value = (Calendar)internalValue;
        long millis = value.getTimeInMillis();
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DateField.timeToString(millis), false));
    }

    protected void addDoubleValue(Document doc, String fieldName, Object internalValue) {
        double doubleVal = (Double)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DoubleField.doubleToString(doubleVal), false));
    }

    protected void addLongValue(Document doc, String fieldName, Object internalValue) {
        long longVal = (Long)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, LongField.longToString(longVal), false));
    }

    protected void addReferenceValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), true));
    }

    protected void addPathValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), false));
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized, boolean includeInNodeIndex, float boost) {
        String stringValue = (String)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, stringValue, false));
        if (tokenized) {
            if (stringValue.length() == 0) {
                return;
            }
            Field f = new Field(FieldNames.createFullTextFieldName(fieldName), stringValue, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO);
            f.setBoost(boost);
            doc.add((Fieldable)f);
            if (includeInNodeIndex) {
                doc.add((Fieldable)this.createFulltextField(stringValue));
            }
        }
    }

    protected void addNameValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), false));
    }

    protected Field createFulltextField(String value) {
        if (this.supportHighlighting) {
            Field.Store stored = Field.Store.YES;
            return new Field(FieldNames.FULLTEXT, value, stored, Field.Index.TOKENIZED, Field.TermVector.WITH_OFFSETS);
        }
        return new Field(FieldNames.FULLTEXT, value, Field.Store.NO, Field.Index.TOKENIZED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Field createFulltextField(Reader value) {
        block9: {
            StringBuffer textExtract;
            block10: {
                int len;
                if (!this.supportHighlighting) break block9;
                textExtract = new StringBuffer();
                char[] buffer = new char[1024];
                while ((len = value.read(buffer)) > -1) {
                    textExtract.append(buffer, 0, len);
                }
                Object var7_5 = null;
                try {
                    value.close();
                }
                catch (IOException e2) {}
                break block10;
                {
                    catch (IOException e) {
                        log.warn((Object)("Exception reading value for fulltext field: " + e.getMessage()));
                        log.debug((Object)"Dump:", (Throwable)e);
                        Object var7_6 = null;
                        try {
                            value.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    try {
                        value.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return this.createFulltextField(textExtract.toString());
        }
        return new Field(FieldNames.FULLTEXT, value);
    }

    protected boolean isIndexed(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIndexed(this.node, propertyName);
    }

    protected boolean isIncludedInNodeIndex(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIncludedInNodeScopeIndex(this.node, propertyName);
    }

    protected float getPropertyBoost(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getPropertyBoost(this.node, propertyName);
    }

    protected float getNodeBoost() {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getNodeBoost(this.node);
    }
}

