/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortComparatorSource;
import org.apache.lucene.search.SortField;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.ErrorLog;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheck;
import org.exoplatform.services.jcr.impl.core.query.lucene.ConsistencyCheckError;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.FileBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.NSRegistryBasedNamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIndexer;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldSortComparator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellChecker;
import org.exoplatform.services.jcr.impl.core.query.lucene.SynonymProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchIndex
implements QueryHandler {
    private static final DefaultQueryNodeFactory DEFAULT_QUERY_NODE_FACTORY = new DefaultQueryNodeFactory();
    private static final Log log = ExoLogger.getLogger(SearchIndex.class);
    private static final String NS_MAPPING_FILE = "ns_mappings.properties";
    private static final String ERROR_LOG = "error.log";
    private boolean closed = false;
    private QueryHandlerContext context;
    private DocumentReaderService extractor;
    private MultiIndex index;
    private IndexFormatVersion indexFormatVersion;
    private IndexingConfiguration indexingConfig;
    private LocationFactory npResolver;
    private NamespaceMappings nsMappings;
    private final QueryHandlerEntry queryHandlerConfig;
    private SpellChecker spellChecker;
    private SynonymProvider synProvider;
    private File indexDirectory;
    private ErrorLog errorLog;
    private final ConfigurationManager cfm;

    public SearchIndex(QueryHandlerEntry queryHandlerConfig, ConfigurationManager cfm) {
        this.queryHandlerConfig = queryHandlerConfig;
        this.cfm = cfm;
    }

    @Override
    public void addNode(NodeData node) throws RepositoryException, IOException {
        throw new UnsupportedOperationException("addNode");
    }

    public ExcerptProvider createExcerptProvider(Query query) throws IOException {
        ExcerptProvider ep = this.queryHandlerConfig.createExcerptProvider(query);
        ep.init(query, this);
        return ep;
    }

    @Override
    public ExecutableQuery createExecutableQuery(SessionImpl session, SessionDataManager itemMgr, String statement, String language) throws InvalidQueryException {
        QueryImpl query = new QueryImpl(session, itemMgr, this, this.getContext().getPropertyTypeRegistry(), statement, language, this.getQueryNodeFactory());
        query.setRespectDocumentOrder(this.queryHandlerConfig.getDocumentOrder());
        return query;
    }

    @Override
    public AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            Object obj = Class.forName(this.queryHandlerConfig.getQueryClass()).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(this.queryHandlerConfig.getQueryClass() + " is not of type " + org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString());
        }
    }

    @Override
    public void deleteNode(String id) throws IOException {
        throw new UnsupportedOperationException("deleteNode");
    }

    public QueryHits executeQuery(org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl queryImpl, Query query, InternalQName[] orderProps, boolean[] orderSpecs) throws IOException {
        this.checkOpen();
        SortField[] sortFields = this.createSortFields(orderProps, orderSpecs);
        IndexReader reader = this.getIndexReader(queryImpl.needsSystemTree());
        IndexSearcher searcher = new IndexSearcher(reader);
        Hits hits = sortFields.length > 0 ? searcher.search(query, new Sort(sortFields)) : searcher.search(query);
        return new QueryHits(hits, reader);
    }

    @Override
    public QueryHandlerContext getContext() {
        return this.context;
    }

    public IndexFormatVersion getIndexFormatVersion() {
        if (this.indexFormatVersion == null) {
            SearchIndex parent;
            this.indexFormatVersion = this.getContext().getParentHandler() instanceof SearchIndex ? ((parent = (SearchIndex)this.getContext().getParentHandler()).getIndexFormatVersion().getVersion() < this.index.getIndexFormatVersion().getVersion() ? parent.getIndexFormatVersion() : this.index.getIndexFormatVersion()) : this.index.getIndexFormatVersion();
        }
        return this.indexFormatVersion;
    }

    public IndexingConfiguration getIndexingConfig() {
        return this.indexingConfig;
    }

    public IndexReader getIndexReader() throws IOException {
        return this.getIndexReader(true);
    }

    public IndexReader getIndexReader(boolean includeSystemIndex) throws IOException {
        QueryHandler parentHandler = this.getContext().getParentHandler();
        CachingMultiIndexReader parentReader = null;
        if (parentHandler instanceof SearchIndex && includeSystemIndex) {
            parentReader = ((SearchIndex)parentHandler).index.getIndexReader();
        }
        CachingMultiIndexReader reader = this.index.getIndexReader();
        if (parentReader != null) {
            CachingMultiIndexReader[] readers = new CachingMultiIndexReader[]{reader, parentReader};
            return new CombinedIndexReader(readers);
        }
        return reader;
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public SynonymProvider getSynonymProvider() {
        if (this.synProvider != null) {
            return this.synProvider;
        }
        QueryHandler handler = this.getContext().getParentHandler();
        if (handler instanceof SearchIndex) {
            return ((SearchIndex)handler).getSynonymProvider();
        }
        return null;
    }

    public Analyzer getTextAnalyzer() {
        return this.queryHandlerConfig.getAnalyzer();
    }

    @Override
    public final void setContext(QueryHandlerContext queryHandlerContext) throws IOException {
        this.context = queryHandlerContext;
    }

    @Override
    public void init() {
        try {
            String indexDir = this.context.getIndexDirectory();
            if (indexDir != null) {
                indexDir = indexDir.replace("${java.io.tmpdir}", System.getProperty("java.io.tmpdir"));
                this.indexDirectory = new File(indexDir);
                if (!this.indexDirectory.exists() && !this.indexDirectory.mkdirs()) {
                    throw new RepositoryException("fail to create index dir " + indexDir);
                }
            } else {
                throw new IOException("SearchIndex requires 'path' parameter in configuration!");
            }
            this.extractor = this.context.getExtractor();
            this.synProvider = this.queryHandlerConfig.createSynonymProvider(this.cfm);
            if (this.context.getParentHandler() instanceof SearchIndex) {
                SearchIndex sysIndex = (SearchIndex)this.context.getParentHandler();
                this.nsMappings = sysIndex.getNamespaceMappings();
            } else {
                File mapFile = new File(this.indexDirectory, NS_MAPPING_FILE);
                this.nsMappings = mapFile.exists() ? new FileBasedNamespaceMappings(mapFile) : new NSRegistryBasedNamespaceMappings(this.context.getNamespaceRegistry());
            }
            this.npResolver = new LocationFactory(this.nsMappings);
            this.indexingConfig = this.queryHandlerConfig.createIndexingConfiguration(this.nsMappings, this.context, this.cfm);
            this.queryHandlerConfig.getAnalyzer().setIndexingConfig(this.indexingConfig);
            this.index = new MultiIndex(this.indexDirectory, this, this.nsMappings);
            if (this.index.numDocs() == 0) {
                this.index.createInitialIndex(this.context.getItemStateManager(), this.context.getRootNodeIdentifer());
            }
            if (this.queryHandlerConfig.isConsistencyCheckEnabled() && (this.index.getRedoLogApplied() || this.queryHandlerConfig.isForceConsistencyCheck())) {
                log.info((Object)"Running consistency check... ");
                ConsistencyCheck check = ConsistencyCheck.run(this.index, this.context.getItemStateManager());
                if (this.queryHandlerConfig.getAutoRepair()) {
                    check.repair(true);
                } else {
                    List<ConsistencyCheckError> errors = check.getErrors();
                    if (errors.size() == 0) {
                        log.info((Object)"No errors detected.");
                    }
                    for (ConsistencyCheckError err : errors) {
                        log.info((Object)err.toString());
                    }
                }
            }
            this.spellChecker = this.queryHandlerConfig.createSpellChecker(this);
            log.info((Object)("Index initialized: " + this.queryHandlerConfig.getIndexDir() + " Version: " + this.index.getIndexFormatVersion() + ""));
            File file = new File(indexDir, ERROR_LOG);
            this.errorLog = new ErrorLog(file, this.queryHandlerConfig.getErrorLogSize());
            this.recoverErrorLog(this.errorLog);
        }
        catch (IOException e) {
            log.error((Object)e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
        catch (RepositoryConfigurationException e) {
            log.error((Object)e.getLocalizedMessage());
            throw new RuntimeException(e);
        }
    }

    private void recoverErrorLog(ErrorLog errlog) throws IOException, RepositoryException {
        HashSet<String> rem = new HashSet<String>();
        final HashSet<String> add = new HashSet<String>();
        errlog.readChanges(rem, add);
        if (rem.isEmpty() && add.isEmpty()) {
            return;
        }
        Iterator<String> removedStates = rem.iterator();
        Iterator<NodeData> addedStates = new Iterator<NodeData>(){
            private final Iterator<String> iter;
            {
                this.iter = add.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeData next() {
                while (this.iter.hasNext()) {
                    String id = this.iter.next();
                    try {
                        ItemData item = SearchIndex.this.context.getItemStateManager().getItemData(id);
                        if (item != null) {
                            if (item.isNode()) {
                                return (NodeData)item;
                            }
                            log.warn((Object)("Node expected but property found with id " + id + ". Skipping " + item.getQPath().getAsString()));
                            continue;
                        }
                        log.warn((Object)("Unable to recovery node index " + id + ". Node not found."));
                    }
                    catch (RepositoryException e) {
                        log.error((Object)("ErrorLog recovery error. Item id " + id + ". " + (Object)((Object)e)), (Throwable)e);
                    }
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        this.updateNodes(removedStates, addedStates);
        errlog.clear();
    }

    @Override
    public void close() {
        if (this.spellChecker != null) {
            this.spellChecker.close();
        }
        this.index.close();
        this.getContext().destroy();
        this.closed = true;
        log.info((Object)("Index closed: " + this.indexDirectory.getAbsolutePath()));
    }

    @Override
    public void updateNodes(Iterator<String> remove, Iterator<NodeData> add) throws RepositoryException, IOException {
        this.checkOpen();
        final HashMap<String, NodeData> aggregateRoots = new HashMap<String, NodeData>();
        final HashSet<String> removedNodeIds = new HashSet<String>();
        final HashSet addedNodeIds = new HashSet();
        this.index.update((Iterator<String>)new AbstractIteratorDecorator(remove){

            public Object next() {
                String nodeId = (String)super.next();
                removedNodeIds.add(nodeId);
                return nodeId;
            }
        }, (Iterator<Document>)new AbstractIteratorDecorator(add){

            public Object next() {
                NodeData state = (NodeData)super.next();
                if (state == null) {
                    return null;
                }
                addedNodeIds.add(state.getIdentifier());
                removedNodeIds.remove(state.getIdentifier());
                Document doc = null;
                try {
                    doc = SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    SearchIndex.this.retrieveAggregateRoot(state, (Map<String, NodeData>)aggregateRoots);
                }
                catch (RepositoryException e) {
                    log.warn((Object)("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString()));
                }
                return doc;
            }
        });
        aggregateRoots.keySet().removeAll(addedNodeIds);
        this.retrieveAggregateRoot(removedNodeIds, aggregateRoots);
        if (aggregateRoots.size() > 0) {
            this.index.update((Iterator<String>)new AbstractIteratorDecorator(aggregateRoots.keySet().iterator()){

                public Object next() {
                    return super.next();
                }
            }, (Iterator<Document>)new AbstractIteratorDecorator(aggregateRoots.values().iterator()){

                public Object next() {
                    NodeData state = (NodeData)super.next();
                    try {
                        return SearchIndex.this.createDocument(state, SearchIndex.this.getNamespaceMappings(), SearchIndex.this.index.getIndexFormatVersion());
                    }
                    catch (RepositoryException e) {
                        log.warn((Object)("Exception while creating document for node: " + state.getIdentifier() + ": " + e.toString()));
                        return null;
                    }
                }
            });
        }
    }

    protected Document createDocument(NodeData node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.extractor);
        indexer.setSupportHighlighting(this.queryHandlerConfig.getSupportHighlighting());
        indexer.setIndexingConfiguration(this.indexingConfig);
        indexer.setIndexFormatVersion(indexFormatVersion);
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc);
        return doc;
    }

    protected SortField[] createSortFields(InternalQName[] orderProps, boolean[] orderSpecs) {
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        for (int i = 0; i < orderProps.length; ++i) {
            String prop = null;
            if (Constants.JCR_SCORE.equals((Object)orderProps[i])) {
                sortFields.add(new SortField(null, 0, orderSpecs[i]));
                continue;
            }
            try {
                prop = this.npResolver.createJCRName(orderProps[i]).getAsString();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            sortFields.add(new SortField(prop, (SortComparatorSource)SharedFieldSortComparator.PROPERTIES, !orderSpecs[i]));
        }
        return sortFields.toArray(new SortField[sortFields.size()]);
    }

    protected MultiIndex getIndex() {
        return this.index;
    }

    protected DefaultQueryNodeFactory getQueryNodeFactory() {
        return DEFAULT_QUERY_NODE_FACTORY;
    }

    protected void mergeAggregatedNodeIndexes(NodeData state, Document doc) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeData[] aggregates = aggregateRules[i].getAggregatedNodeStates(state);
                    if (aggregates == null) continue;
                    for (int j = 0; j < aggregates.length; ++j) {
                        Document aDoc = this.createDocument(aggregates[j], this.getNamespaceMappings(), this.index.getIndexFormatVersion());
                        Field[] fulltextFields = aDoc.getFields(FieldNames.FULLTEXT);
                        if (fulltextFields == null) continue;
                        for (int k = 0; k < fulltextFields.length; ++k) {
                            doc.add((Fieldable)fulltextFields[k]);
                        }
                        doc.add((Fieldable)new Field(FieldNames.AGGREGATED_NODE_UUID, aggregates[j].getIdentifier().toString(), Field.Store.NO, Field.Index.NO_NORMS));
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Exception while building indexing aggregate for node with UUID: " + state.getIdentifier()), (Throwable)e);
            }
        }
    }

    protected void retrieveAggregateRoot(NodeData state, Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            try {
                for (int i = 0; i < aggregateRules.length; ++i) {
                    NodeData root = aggregateRules[i].getAggregateRoot(state);
                    if (root == null) continue;
                    map.put(root.getIdentifier(), root);
                    break;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Unable to get aggregate root for " + state.getIdentifier()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveAggregateRoot(Set<String> removedNodeIds, Map<String, NodeData> map) {
        if (this.indexingConfig != null) {
            AggregateRule[] aggregateRules = this.indexingConfig.getAggregateRules();
            if (aggregateRules == null) {
                return;
            }
            int found = 0;
            long time = System.currentTimeMillis();
            try {
                CachingMultiIndexReader reader = this.index.getIndexReader();
                try {
                    Term aggregateUUIDs = new Term(FieldNames.AGGREGATED_NODE_UUID, "");
                    TermDocs tDocs = reader.termDocs();
                    try {
                        ItemDataConsumer ism = this.getContext().getItemStateManager();
                        for (String id : removedNodeIds) {
                            aggregateUUIDs = aggregateUUIDs.createTerm(id);
                            tDocs.seek(aggregateUUIDs);
                            while (tDocs.next()) {
                                Document doc = reader.document(tDocs.doc());
                                String uuid = doc.get(FieldNames.UUID);
                                ItemData itd = ism.getItemData(uuid);
                                if (itd == null) continue;
                                if (!itd.isNode()) {
                                    throw new RepositoryException("Item with id:" + uuid + " is not a node");
                                }
                                map.put(uuid, (NodeData)itd);
                                ++found;
                            }
                        }
                    }
                    finally {
                        tDocs.close();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception while retrieving aggregate roots", (Throwable)e);
            }
            time = System.currentTimeMillis() - time;
            log.debug((Object)("Retrieved " + new Integer(found) + " aggregate roots in " + new Long(time) + " ms."));
        }
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("query handler closed and cannot be used anymore.");
        }
    }

    public QueryHandlerEntry getQueryHandlerConfig() {
        return this.queryHandlerConfig;
    }

    @Override
    public void logErrorChanges(Set<String> removed, Set<String> added) throws IOException {
        this.errorLog.writeChanges(removed, added);
    }

    protected static final class CombinedIndexReader
    extends MultiReader
    implements HierarchyResolver,
    MultiIndexReader {
        private int[] starts;
        private final CachingMultiIndexReader[] subReaders;

        public CombinedIndexReader(CachingMultiIndexReader[] indexReaders) throws IOException {
            super((IndexReader[])indexReaders);
            this.subReaders = indexReaders;
            this.starts = new int[this.subReaders.length + 1];
            int maxDoc = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.starts[i] = maxDoc;
                maxDoc += this.subReaders[i].maxDoc();
            }
            this.starts[this.subReaders.length] = maxDoc;
        }

        public ForeignSegmentDocId createDocId(String uuid) throws IOException {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                ForeignSegmentDocId doc = subReader.createDocId(uuid);
                if (doc == null) continue;
                return doc;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombinedIndexReader) {
                CombinedIndexReader other = (CombinedIndexReader)obj;
                return Arrays.equals(this.subReaders, other.subReaders);
            }
            return false;
        }

        public int getDocumentNumber(ForeignSegmentDocId docId) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                CachingMultiIndexReader subReader = this.subReaders[i];
                int realDoc = subReader.getDocumentNumber(docId);
                if (realDoc < 0) continue;
                return realDoc + this.starts[i];
            }
            return -1;
        }

        public IndexReader[] getIndexReaders() {
            IndexReader[] readers = new IndexReader[this.subReaders.length];
            System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
            return readers;
        }

        public int getParent(int n) throws IOException {
            int i = this.readerIndex(n);
            DocId id = this.subReaders[i].getParentDocId(n - this.starts[i]);
            id = id.applyOffset(this.starts[i]);
            return id.getDocumentNumber(this);
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                hash = 31 * hash + this.subReaders[i].hashCode();
            }
            return hash;
        }

        private int readerIndex(int n) {
            int lo = 0;
            int hi = this.subReaders.length - 1;
            while (hi >= lo) {
                int mid = lo + hi >> 1;
                int midValue = this.starts[mid];
                if (n < midValue) {
                    hi = mid - 1;
                    continue;
                }
                if (n > midValue) {
                    lo = mid + 1;
                    continue;
                }
                while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                    ++mid;
                }
                return mid;
            }
            return hi;
        }
    }
}

