/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypesHierarchyHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDefinitionsHolder {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemDefinitionsHolder");
    private static InternalQName RESIDUAL_NAME = new InternalQName(null, "*");
    private final HashMap<ChildNodeDefKey, NodeDefinitionImpl> nodeDefinitions = new HashMap();
    private final HashMap<ChildPropertyDefKey, PropertyDefinitionImpl> propertyDefinitions = new HashMap();
    private final HashMap<DefaultNodeDefKey, NodeDefinitionImpl> defNodeDefinitions = new HashMap();
    private final NodeTypesHierarchyHolder nodeTypesHierarchy;

    public ItemDefinitionsHolder(NodeTypesHierarchyHolder nodeTypesHierarchy) {
        this.nodeTypesHierarchy = nodeTypesHierarchy;
    }

    public NodeDefinitionImpl getChildNodeDefinition(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        NodeDefinitionImpl def = this.getNodeDefinitionFromThisOrSupertypes(parentNodeType, childName, childNodeType);
        if (def == null) {
            def = this.getNodeDefinitionFromThisOrSupertypes(parentNodeType, RESIDUAL_NAME, childNodeType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get NodeDef: parent NT: " + parentNodeType.getAsString() + " child nodeName: " + childName.getAsString() + " childNT: " + childNodeType.getAsString()));
        }
        return def;
    }

    private NodeDefinitionImpl getNodeDefinitionFromThisOrSupertypes(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
        ChildNodeDefKey key = new ChildNodeDefKey(parentNodeType, childName, childNodeType);
        NodeDefinitionImpl def = this.nodeDefinitions.get(key);
        if (def != null) {
            return def;
        }
        Iterator<InternalQName> i = this.nodeTypesHierarchy.getSuperypes(parentNodeType).iterator();
        while (i.hasNext() && (def = this.nodeDefinitions.get(key = new ChildNodeDefKey(parentNodeType, childName, i.next()))) == null) {
        }
        return def;
    }

    public NodeDefinitionImpl getDefaultChildNodeDefinition(List<InternalQName> parentNodeTypes, InternalQName childName) {
        for (InternalQName parentNodeType : parentNodeTypes) {
            DefaultNodeDefKey key = new DefaultNodeDefKey(parentNodeType, childName);
            NodeDefinitionImpl def = this.defNodeDefinitions.get(key);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    public PropertyDefinitionImpl getChildPropertyDefinition(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
        ChildPropertyDefKey key = new ChildPropertyDefKey(parentNodeType, childName, multiValued);
        PropertyDefinitionImpl def = this.propertyDefinitions.get(key);
        if (def == null) {
            key = new ChildPropertyDefKey(parentNodeType, RESIDUAL_NAME, multiValued);
            return this.propertyDefinitions.get(key);
        }
        return def;
    }

    void putAllDefinitions(List<ExtendedNodeType> nodeTypes) {
        for (ExtendedNodeType nodeType : nodeTypes) {
            this.putDefinitions(nodeType);
        }
    }

    void putDefinitions(ExtendedNodeType nodeType) {
        PropertyDefinition[] propDefs;
        NodeDefinition[] nodeDefs;
        NodeTypeImpl nodeTypeImpl = (NodeTypeImpl)nodeType;
        this.nodeTypesHierarchy.addNodeType(nodeTypeImpl);
        for (NodeDefinition nodeDef : nodeDefs = nodeType.getChildNodeDefinitions()) {
            NodeDefinitionImpl nodeDefImpl = (NodeDefinitionImpl)nodeDef;
            for (NodeType requiredNT : nodeDefImpl.getRequiredPrimaryTypes()) {
                ExtendedNodeType requiredNodeType = (ExtendedNodeType)requiredNT;
                ChildNodeDefKey nodeDefKey = new ChildNodeDefKey(nodeTypeImpl.getQName(), nodeDefImpl.getQName(), requiredNodeType.getQName());
                this.nodeDefinitions.put(nodeDefKey, nodeDefImpl);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("NodeDef added: parent NT: " + (Object)((Object)nodeTypeImpl.getQName()) + " child nodeName: " + (Object)((Object)nodeDefImpl.getQName()) + " childNT: " + (Object)((Object)requiredNodeType.getQName()) + " hash: " + nodeDefKey.hashCode()));
            }
            DefaultNodeDefKey defNodeDefKey = new DefaultNodeDefKey(nodeTypeImpl.getQName(), nodeDefImpl.getQName());
            this.defNodeDefinitions.put(defNodeDefKey, nodeDefImpl);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Default NodeDef added: parent NT: " + (Object)((Object)nodeTypeImpl.getQName()) + " child nodeName: " + (Object)((Object)nodeDefImpl.getQName()) + " hash: " + defNodeDefKey.hashCode()));
        }
        for (PropertyDefinition propDef : propDefs = nodeType.getPropertyDefinitions()) {
            PropertyDefinitionImpl propDefImpl = (PropertyDefinitionImpl)propDef;
            ChildPropertyDefKey propDefKey = new ChildPropertyDefKey(nodeTypeImpl.getQName(), propDefImpl.getQName(), propDefImpl.isMultiple());
            this.propertyDefinitions.put(propDefKey, propDefImpl);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("PropDef added: parent NT: " + (Object)((Object)nodeTypeImpl.getQName()) + " child propName: " + (Object)((Object)propDefImpl.getQName()) + " isMultiple: " + propDefImpl.isMultiple() + " hash: " + propDefKey.hashCode()));
        }
    }

    private class ChildPropertyDefKey
    extends ItemDefKey {
        private ChildPropertyDefKey(InternalQName parentNodeType, InternalQName childName, boolean multiValued) {
            super(parentNodeType, childName);
            this.hashCode = 31 * this.hashCode + (multiValued ? 1 : 0);
        }
    }

    private class DefaultNodeDefKey
    extends ItemDefKey {
        private DefaultNodeDefKey(InternalQName parentNodeType, InternalQName childName) {
            super(parentNodeType, childName);
        }
    }

    private class ChildNodeDefKey
    extends ItemDefKey {
        private ChildNodeDefKey(InternalQName parentNodeType, InternalQName childName, InternalQName childNodeType) {
            super(parentNodeType, childName);
            this.hashCode = 31 * this.hashCode + (null == childNodeType ? 0 : childNodeType.hashCode());
        }
    }

    private abstract class ItemDefKey {
        protected int hashCode = 7;

        protected ItemDefKey(InternalQName parentNodeType, InternalQName childName) {
            this.hashCode = 31 * this.hashCode + (null == parentNodeType ? 0 : parentNodeType.hashCode());
            this.hashCode = 31 * this.hashCode + (null == childName ? 0 : childName.hashCode());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ItemDefKey test = (ItemDefKey)obj;
            return this.hashCode == test.hashCode();
        }
    }
}

